/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.DynamicBundle;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFromTemplateDialog
extends DialogWrapper {
    private JTextField myNameField;
    private TemplateKindCombo myKindCombo;
    private JPanel myPanel;
    private JLabel myUpDownHint;
    private JLabel myKindLabel;
    private JLabel myNameLabel;
    private ElementCreator myCreator;
    private InputValidator myInputValidator;

    protected CreateFileFromTemplateDialog(@NotNull Project project2) {
        if (project2 == null) {
            CreateFileFromTemplateDialog.$$$reportNull$$$0(0);
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myKindLabel.setLabelFor(this.myKindCombo);
        this.myKindCombo.registerUpDownHint(this.myNameField);
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.setTemplateKindComponentsVisible(false);
        this.init();
    }

    @Override
    @Nullable
    protected ValidationInfo doValidate() {
        String text2;
        boolean canClose;
        if (this.myInputValidator != null && !(canClose = this.myInputValidator.canClose(text2 = this.myNameField.getText().trim()))) {
            String message;
            String errorText = LangBundle.message("incorrect.name", new Object[0]);
            if (this.myInputValidator instanceof InputValidatorEx && (message = ((InputValidatorEx)this.myInputValidator).getErrorText(text2)) != null) {
                errorText = message;
            }
            return new ValidationInfo(errorText, this.myNameField);
        }
        return super.doValidate();
    }

    protected JTextField getNameField() {
        return this.myNameField;
    }

    protected TemplateKindCombo getKindCombo() {
        return this.myKindCombo;
    }

    protected JLabel getKindLabel() {
        return this.myKindLabel;
    }

    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    private String getEnteredName() {
        JTextField nameField = this.getNameField();
        String text2 = nameField.getText().trim();
        nameField.setText(text2);
        return text2;
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    protected void doOKAction() {
        if (this.myCreator != null && this.myCreator.tryCreate(this.getEnteredName()).length == 0) {
            return;
        }
        super.doOKAction();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.getNameField();
    }

    public void setTemplateKindComponentsVisible(boolean flag) {
        this.myKindCombo.setVisible(flag);
        this.myKindLabel.setVisible(flag);
        this.myUpDownHint.setVisible(flag);
    }

    public static Builder createDialog(@NotNull Project project2) {
        if (project2 == null) {
            CreateFileFromTemplateDialog.$$$reportNull$$$0(1);
        }
        if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            return new NonBlockingPopupBuilderImpl(project2);
        }
        CreateFileFromTemplateDialog dialog2 = new CreateFileFromTemplateDialog(project2);
        return new BuilderImpl(dialog2, project2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TemplateKindCombo templateKindCombo;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle("messages/LangBundle", CreateFileFromTemplateDialog.class).getString("label.project.as.template.name"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKindLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle("messages/LangBundle", CreateFileFromTemplateDialog.class).getString("label.file.kind"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(30);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/LangBundle").getString("tooltip.pressing.up.or.down.arrows.while.in.editor.changes.the.kind"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myKindCombo = templateKindCombo = new TemplateKindCombo();
        jPanel.add((Component)templateKindCombo, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/ide/actions/CreateFileFromTemplateDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileCreator<T> {
        @Nullable
        public T createFile(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String getActionName(@NotNull String var1, @NotNull String var2);

        public boolean startInWriteAction();
    }

    public static interface Builder {
        public Builder setTitle(String var1);

        public Builder setValidator(InputValidator var1);

        public Builder addKind(@NotNull String var1, @Nullable Icon var2, @NotNull String var3);

        @Nullable
        public <T extends PsiElement> T show(@NotNull String var1, @Nullable String var2, @NotNull FileCreator<T> var3);

        public <T extends PsiElement> void show(@NotNull String var1, @Nullable String var2, @NotNull FileCreator<T> var3, Consumer<? super T> var4);

        @Nullable
        public Map<String, String> getCustomProperties();
    }

    private static class NonBlockingPopupBuilderImpl
    implements Builder {
        @NotNull
        private final Project myProject;
        private String myTitle;
        private final List<Trinity<String, Icon, String>> myTemplatesList;
        private InputValidator myInputValidator;

        private NonBlockingPopupBuilderImpl(@NotNull Project project2) {
            if (project2 == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(0);
            }
            this.myTitle = "Title";
            this.myTemplatesList = new ArrayList<Trinity<String, Icon, String>>();
            this.myProject = project2;
        }

        @Override
        public Builder setTitle(String title) {
            this.myTitle = title;
            return this;
        }

        @Override
        public Builder addKind(@NotNull String kind, @Nullable Icon icon2, @NotNull String templateName) {
            if (kind == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(1);
            }
            if (templateName == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(2);
            }
            this.myTemplatesList.add(Trinity.create(kind, icon2, templateName));
            return this;
        }

        @Override
        public Builder setValidator(InputValidator validator2) {
            this.myInputValidator = validator2;
            return this;
        }

        @Override
        @Nullable
        public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull FileCreator<T> creator) {
            if (errorTitle == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(3);
            }
            if (creator == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException("Modal dialog is not supported by this builder");
        }

        @Override
        public <T extends PsiElement> void show(@NotNull String errorTitle, @Nullable String selectedItem, final @NotNull FileCreator<T> fileCreator, Consumer<? super T> elementConsumer) {
            if (errorTitle == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(5);
            }
            if (fileCreator == null) {
                NonBlockingPopupBuilderImpl.$$$reportNull$$$0(6);
            }
            final CreateWithTemplatesDialogPanel contentPanel2 = new CreateWithTemplatesDialogPanel(this.myTemplatesList, selectedItem);
            ElementCreator elementCreator = new ElementCreator(this.myProject, errorTitle){

                @Override
                protected PsiElement[] create(@NotNull String newName) {
                    PsiElement[] psiElementArray;
                    PsiElement element2;
                    if (newName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((element2 = (PsiElement)fileCreator.createFile(contentPanel2.getEnteredName(), contentPanel2.getSelectedTemplate())) != null) {
                        PsiElement[] psiElementArray2 = new PsiElement[1];
                        psiElementArray = psiElementArray2;
                        psiElementArray2[0] = element2;
                    } else {
                        psiElementArray = PsiElement.EMPTY_ARRAY;
                    }
                    return psiElementArray;
                }

                @Override
                public boolean startInWriteAction() {
                    return fileCreator.startInWriteAction();
                }

                @Override
                protected String getActionName(String newName) {
                    return fileCreator.getActionName(newName, contentPanel2.getSelectedTemplate());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/actions/CreateFileFromTemplateDialog$NonBlockingPopupBuilderImpl$1", "create"));
                }
            };
            JBPopup popup2 = NewItemPopupUtil.createNewItemPopup(this.myTitle, contentPanel2, contentPanel2.getNameField());
            contentPanel2.setApplyAction(e -> {
                boolean isValid;
                String newElementName = contentPanel2.getEnteredName();
                if (StringUtil.isEmptyOrSpaces(newElementName)) {
                    return;
                }
                boolean bl = isValid = this.myInputValidator == null || this.myInputValidator.canClose(newElementName);
                if (isValid) {
                    popup2.closeOk((InputEvent)e);
                    PsiElement createdElement = NonBlockingPopupBuilderImpl.createElement(newElementName, elementCreator);
                    if (createdElement != null) {
                        elementConsumer.consume(createdElement);
                    }
                } else {
                    String errorMessage = Optional.ofNullable(this.myInputValidator).filter(validator2 -> validator2 instanceof InputValidatorEx).map(validator2 -> ((InputValidatorEx)validator2).getErrorText(newElementName)).orElse(LangBundle.message("incorrect.name", new Object[0]));
                    contentPanel2.setError(errorMessage);
                }
            });
            Disposer.register(popup2, contentPanel2);
            popup2.showCenteredInCurrentWindow(this.myProject);
        }

        @Override
        @Nullable
        public Map<String, String> getCustomProperties() {
            return null;
        }

        @Nullable
        private static PsiElement createElement(String newElementName, ElementCreator creator) {
            PsiElement[] elements2 = creator.tryCreate(newElementName);
            return elements2.length > 0 ? elements2[0] : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorTitle";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "creator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileCreator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/CreateFileFromTemplateDialog$NonBlockingPopupBuilderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKind";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BuilderImpl
    implements Builder {
        private final CreateFileFromTemplateDialog myDialog;
        private final Project myProject;

        BuilderImpl(CreateFileFromTemplateDialog dialog2, Project project2) {
            this.myDialog = dialog2;
            this.myProject = project2;
        }

        @Override
        public Builder setTitle(String title) {
            this.myDialog.setTitle(title);
            return this;
        }

        @Override
        public Builder addKind(@NotNull String name, @Nullable Icon icon2, @NotNull String templateName) {
            if (name == null) {
                BuilderImpl.$$$reportNull$$$0(0);
            }
            if (templateName == null) {
                BuilderImpl.$$$reportNull$$$0(1);
            }
            this.myDialog.getKindCombo().addItem(name, icon2, templateName);
            if (this.myDialog.getKindCombo().getComboBox().getItemCount() > 1) {
                this.myDialog.setTemplateKindComponentsVisible(true);
            }
            return this;
        }

        @Override
        public Builder setValidator(InputValidator validator2) {
            this.myDialog.myInputValidator = validator2;
            return this;
        }

        @Override
        public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedTemplateName, final @NotNull FileCreator<T> creator) {
            if (errorTitle == null) {
                BuilderImpl.$$$reportNull$$$0(2);
            }
            if (creator == null) {
                BuilderImpl.$$$reportNull$$$0(3);
            }
            final Ref<Object> created = Ref.create(null);
            this.myDialog.getKindCombo().setSelectedName(selectedTemplateName);
            this.myDialog.myCreator = new ElementCreator(this.myProject, errorTitle){

                @Override
                protected PsiElement[] create(@NotNull String newName) {
                    PsiElement element2;
                    if (newName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((element2 = (PsiElement)creator.createFile(myDialog.getEnteredName(), myDialog.getKindCombo().getSelectedName())) != null) {
                        created.set(SmartPointerManager.getInstance(myProject).createSmartPsiElementPointer(element2));
                        return new PsiElement[]{element2};
                    }
                    return PsiElement.EMPTY_ARRAY;
                }

                @Override
                public boolean startInWriteAction() {
                    return creator.startInWriteAction();
                }

                @Override
                protected String getActionName(String newName) {
                    return creator.getActionName(newName, myDialog.getKindCombo().getSelectedName());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/actions/CreateFileFromTemplateDialog$BuilderImpl$1", "create"));
                }
            };
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                SmartPsiElementPointer pointer = created.get();
                return pointer == null ? null : (T)pointer.getElement();
            }
            return null;
        }

        @Override
        public <T extends PsiElement> void show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull FileCreator<T> creator, Consumer<? super T> elementConsumer) {
            if (errorTitle == null) {
                BuilderImpl.$$$reportNull$$$0(4);
            }
            if (creator == null) {
                BuilderImpl.$$$reportNull$$$0(5);
            }
            T element2 = this.show(errorTitle, selectedItem, creator);
            elementConsumer.consume(element2);
        }

        @Override
        @Nullable
        public Map<String, String> getCustomProperties() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorTitle";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "creator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/CreateFileFromTemplateDialog$BuilderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKind";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

