/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLauncherScriptAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CreateLauncherScriptAction.class);

    public static boolean isAvailable() {
        return SystemInfo.isUnix && (!ExternalUpdateManager.isRoaming() || ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX) && Holder.INTERPRETER_NAME != null;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(0);
        }
        boolean enabled = CreateLauncherScriptAction.isAvailable();
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        String ok;
        String message;
        File target2;
        String home;
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(1);
        }
        if (!CreateLauncherScriptAction.isAvailable()) {
            return;
        }
        if (ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX) {
            String title = ApplicationBundle.message("launcher.script.title", new Object[0]);
            String message2 = ApplicationBundle.message("launcher.script.luke", new Object[0]);
            Messages.showInfoMessage(event.getProject(), message2, title);
            return;
        }
        final Project project2 = event.getProject();
        String title = ApplicationBundle.message("launcher.script.title", new Object[0]);
        String prompt = ApplicationBundle.message("launcher.script.prompt", ApplicationNamesInfo.getInstance().getFullProductName());
        String path2 = Messages.showInputDialog(project2, prompt, title, null, CreateLauncherScriptAction.defaultScriptPath(), null);
        if (path2 == null) {
            return;
        }
        if (!path2.startsWith("/") && (home = System.getenv("HOME")) != null && new File(home).isDirectory()) {
            path2 = path2.startsWith("~") ? home + path2.substring(1) : home + "/" + path2;
        }
        if ((target2 = new File(path2)).exists() && Messages.showOkCancelDialog(project2, message = ApplicationBundle.message("launcher.script.overwrite", target2), title, ok = ApplicationBundle.message("launcher.script.overwrite.button", new Object[0]), Messages.getCancelButton(), Messages.getQuestionIcon()) != 0) {
            return;
        }
        new Task.Backgroundable(project2, ApplicationBundle.message("launcher.script.title", new Object[0])){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CreateLauncherScriptAction.createLauncherScript(target2.getAbsolutePath());
                }
                catch (Exception e) {
                    CreateLauncherScriptAction.reportFailure(e, project2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateLauncherScriptAction$1", "run"));
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLauncherScript(@NotNull String pathName) throws Exception {
        if (pathName == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(2);
        }
        if (!CreateLauncherScriptAction.isAvailable()) {
            return;
        }
        File scriptFile = CreateLauncherScriptAction.createLauncherScriptFile();
        try {
            File scriptTarget = new File(pathName);
            File scriptTargetDir = scriptTarget.getParentFile();
            assert (scriptTargetDir != null) : "path: " + pathName;
            if (!scriptTargetDir.exists() && !scriptTargetDir.mkdirs() || !scriptFile.renameTo(scriptTarget)) {
                String scriptTargetDirPath = scriptTargetDir.getCanonicalPath();
                String installationScriptSrc = "#!/bin/sh\nmkdir -p \"" + scriptTargetDirPath + "\"\ninstall -g 0 -o 0 \"" + scriptFile.getCanonicalPath() + "\" \"" + pathName + "\"";
                File installationScript = ExecUtil.createTempExecutableScript((String)"launcher_installer", (String)".sh", (String)installationScriptSrc);
                String prompt = ApplicationBundle.message("launcher.script.sudo.prompt", scriptTargetDirPath);
                ProcessOutput result2 = ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{installationScript.getPath()}), (String)prompt);
                int exitCode = result2.getExitCode();
                if (exitCode != 0) {
                    String message = "Launcher script creation failed with " + exitCode;
                    String output = result2.getStdout();
                    if (!StringUtil.isEmptyOrSpaces(output)) {
                        message = message + "\nOutput: " + output.trim();
                    }
                    throw new RuntimeException(message);
                }
            }
        }
        finally {
            if (scriptFile.exists()) {
                FileUtil.delete(scriptFile);
            }
        }
    }

    public static void reportFailure(@NotNull Exception e, @Nullable Project project2) {
        if (e == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(3);
        }
        LOG.warn(e);
        String message = ExceptionUtil.getNonEmptyMessage(e, "Internal error");
        Notifications.Bus.notify(new Notification("System Messages", IdeBundle.message("notification.title.launcher.script.creation.failed", new Object[0]), message, NotificationType.ERROR), project2);
    }

    private static File createLauncherScriptFile() throws IOException, ExecutionException {
        File starter2 = Restarter.getIdeStarter();
        if (starter2 == null) {
            throw new IOException(ApplicationBundle.message("desktop.entry.script.missing", PathManager.getBinPath()));
        }
        ClassLoader loader = CreateLauncherScriptAction.class.getClassLoader();
        assert (loader != null);
        Map<String, String> variables2 = ContainerUtil.newHashMap(Pair.pair("$PYTHON$", Holder.INTERPRETER_NAME), Pair.pair("$CONFIG_PATH$", PathManager.getConfigPath()), Pair.pair("$SYSTEM_PATH$", PathManager.getSystemPath()), Pair.pair("$RUN_PATH$", starter2.getPath()));
        String launcherContents = StringUtil.convertLineSeparators(ExecUtil.loadTemplate((ClassLoader)loader, (String)"launcher.py", variables2));
        return ExecUtil.createTempExecutableScript((String)"launcher", (String)"", (String)launcherContents);
    }

    public static String defaultScriptPath() {
        String scriptName = ApplicationNamesInfo.getInstance().getDefaultLauncherName();
        if (StringUtil.isEmptyOrSpaces(scriptName)) {
            scriptName = StringUtil.toLowerCase(ApplicationNamesInfo.getInstance().getProductName());
        }
        return "/usr/local/bin/" + scriptName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CreateLauncherScriptAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createLauncherScript";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportFailure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final String INTERPRETER_NAME = PathEnvironmentVariableUtil.findInPath((String)"python") != null ? "python" : (PathEnvironmentVariableUtil.findInPath((String)"python3") != null ? "python3" : null);

        private Holder() {
        }
    }
}

