/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class CreateTemplateInPackageAction<T extends PsiElement>
extends CreateFromTemplateAction<T> {
    private final Set<? extends JpsModuleSourceRootType<?>> mySourceRootTypes;

    protected CreateTemplateInPackageAction(String text2, String description, Icon icon2, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        this(() -> text2, () -> description, icon2, rootTypes);
    }

    protected CreateTemplateInPackageAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (dynamicText == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateTemplateInPackageAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon2);
        this.mySourceRootTypes = rootTypes;
    }

    @Override
    @Nullable
    protected T createFile(String name, String templateName, PsiDirectory dir) {
        return this.checkOrCreate(name, dir, templateName);
    }

    @Nullable
    protected abstract PsiElement getNavigationElement(@NotNull T var1);

    @Override
    protected boolean isAvailable(DataContext dataContext) {
        return CreateTemplateInPackageAction.isAvailable(dataContext, this.mySourceRootTypes, this::checkPackageExists);
    }

    public static boolean isAvailable(DataContext dataContext, Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes, Predicate<? super PsiDirectory> checkPackageExists) {
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project2 == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        if (sourceRootTypes == null) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), sourceRootTypes) || !checkPackageExists.test(dir)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean checkPackageExists(PsiDirectory var1);

    @Nullable
    private T checkOrCreate(String newName, PsiDirectory directory, String templateName) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        String className = this.removeExtension(templateName, newName);
        if (className.contains(".")) {
            String[] names2 = className.split("\\.");
            for (int i = 0; i < names2.length - 1; ++i) {
                dir = CreateFileAction.findOrCreateSubdirectory(dir, names2[i]);
            }
            className = names2[names2.length - 1];
        }
        DumbService service = DumbService.getInstance(dir.getProject());
        PsiDirectory finalDir = dir;
        String finalClassName = className;
        return (T)service.computeWithAlternativeResolveEnabled(() -> this.doCreate(finalDir, finalClassName, templateName));
    }

    protected String removeExtension(String templateName, String className) {
        String extension = StringUtil.getShortName(templateName);
        if (StringUtil.isNotEmpty(extension)) {
            className = StringUtil.trimEnd(className, "." + extension);
        }
        return className;
    }

    @Nullable
    protected abstract T doCreate(PsiDirectory var1, String var2, String var3) throws IncorrectOperationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dynamicDescription";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/CreateTemplateInPackageAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

