/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH$J\b\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/actions/EditCustomSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Ljava/io/File;", "template", "", "update", "intellij.platform.ide.impl"})
public abstract class EditCustomSettingsAction
extends DumbAwareAction {
    @Nullable
    protected abstract File file();

    @NotNull
    protected abstract String template();

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled((e.getProject() != null || WelcomeFrame.getInstance() != null) && this.file() != null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project2 = e.getProject();
        JFrame frame = (JFrame)((Object)WelcomeFrame.getInstance());
        File file2 = this.file();
        if (file2 == null) {
            return;
        }
        File file3 = file2;
        if (project2 != null) {
            VirtualFile vFile;
            if (!file3.exists()) {
                String confirmation = IdeBundle.message("edit.custom.settings.confirm", FileUtil.getLocationRelativeToUserHome(file3.getPath()));
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                String string = presentation.getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = confirmation;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"confirmation");
                String string3 = IdeBundle.message("button.create", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"button.create\")");
                String string4 = IdeBundle.message("button.cancel", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"IdeBundle.message(\"button.cancel\")");
                int result2 = MessageUtil.showOkCancelDialog$default(string, string2, string3, string4, Messages.getQuestionIcon(), null, project2, 32, null);
                if (result2 == 2) {
                    return;
                }
                try {
                    String string5 = this.template();
                    LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)lineSeparator), (String)"LineSeparator.getSystemLineSeparator()");
                    FileUtil.writeToFile(file3, StringUtil.convertLineSeparators(string5, lineSeparator.getSeparatorString()));
                }
                catch (IOException ex) {
                    Logger.getInstance(this.getClass()).warn(file3.getPath(), ex);
                    String message = IdeBundle.message("edit.custom.settings.failed", file3, ex.getMessage());
                    Messages.showErrorDialog(project2, message, CommonBundle.getErrorTitle());
                    return;
                }
            }
            if ((vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file3)) != null) {
                vFile.refresh(false, false);
                PsiFile psiFile = PsiManager.getInstance(project2).findFile(vFile);
                if (psiFile != null) {
                    PsiNavigationSupport.getInstance().createNavigatable(project2, vFile, psiFile.getTextLength()).navigate(true);
                }
            }
        } else if (frame != null) {
            String string = StringUtil.convertLineSeparators(file3.exists() ? FileUtil.loadFile(file3) : this.template());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.convertLineSe\u2026le(file) else template())");
            String text2 = string;
            new DialogWrapper(file3, text2, frame, frame, true){
                private final EditorTextField editor;
                final /* synthetic */ File $file;
                final /* synthetic */ String $text;
                final /* synthetic */ JFrame $frame;

                @NotNull
                protected EditorTextField createCenterPanel() {
                    return this.editor;
                }

                @NotNull
                public EditorTextField getPreferredFocusedComponent() {
                    return this.editor;
                }

                @NotNull
                protected String getDimensionServiceKey() {
                    return "ide.config.custom.settings";
                }

                protected void doOKAction() {
                    String string = this.editor.getText();
                    LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)lineSeparator), (String)"LineSeparator.getSystemLineSeparator()");
                    String string2 = StringUtil.convertLineSeparators(string, lineSeparator.getSeparatorString());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.convertLineSe\u2026arator().separatorString)");
                    String toSave = string2;
                    try {
                        FileUtil.writeToFile(this.$file, toSave);
                        this.close(0);
                    }
                    catch (IOException ex) {
                        Logger.getInstance(this.getClass()).warn(this.$file.getPath(), ex);
                        String message = IdeBundle.message("edit.custom.settings.failed", this.$file, ex.getMessage());
                        Messages.showErrorDialog(this.getWindow(), message, CommonBundle.getErrorTitle());
                    }
                }
                {
                    this.$file = $captured_local_variable$0;
                    this.$text = $captured_local_variable$1;
                    this.$frame = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4);
                    this.setTitle(FileUtil.getLocationRelativeToUserHome($captured_local_variable$0.getPath()));
                    this.setOKButtonText(IdeBundle.message("button.save", new Object[0]));
                    Document document = EditorFactory.getInstance().createDocument($captured_local_variable$1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"EditorFactory.getInstance().createDocument(text)");
                    Document document2 = document;
                    DefaultProjectFactory defaultProjectFactory = DefaultProjectFactory.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)defaultProjectFactory, (String)"DefaultProjectFactory.getInstance()");
                    Project defaultProject = defaultProjectFactory.getDefaultProject();
                    FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName($captured_local_variable$0.getName());
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"FileTypeManager.getInsta\u2026TypeByFileName(file.name)");
                    FileType fileType2 = fileType;
                    this.editor = new EditorTextField(document2, defaultProject, fileType2, document2, defaultProject, fileType2, false, false){
                        final /* synthetic */ Document $document;
                        final /* synthetic */ Project $defaultProject;
                        final /* synthetic */ FileType $fileType;

                        @NotNull
                        protected EditorEx createEditor() {
                            EditorEx editor;
                            EditorEx editorEx = editor = super.createEditor();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"editor");
                            JScrollPane jScrollPane = editorEx.getScrollPane();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
                            jScrollPane.setVerticalScrollBarPolicy(20);
                            JScrollPane jScrollPane2 = editor.getScrollPane();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane2, (String)"editor.scrollPane");
                            jScrollPane2.setHorizontalScrollBarPolicy(30);
                            return editor;
                        }
                        {
                            this.$document = $captured_local_variable$0;
                            this.$defaultProject = $captured_local_variable$1;
                            this.$fileType = $captured_local_variable$2;
                            super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                        }
                    };
                    this.init();
                }
            }.show();
        }
    }
}

