/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;

public class FixLineSeparatorsAction
extends AnAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null || vFiles == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            for (VirtualFile vFile : vFiles) {
                FixLineSeparatorsAction.fixSeparators(vFile);
            }
        }, IdeBundle.message("command.fixing.line.separators", new Object[0]), null);
    }

    private static void fixSeparators(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                Document document;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() && !file2.getFileType().isBinary() && (document = FileDocumentManager.getInstance().getDocument(file2)) != null && FixLineSeparatorsAction.areSeparatorsBroken(document)) {
                    FixLineSeparatorsAction.fixSeparators(document);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/FixLineSeparatorsAction$1", "visitFile"));
            }
        });
    }

    private static boolean areSeparatorsBroken(@NotNull Document document) {
        if (document == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(2);
        }
        int count = document.getLineCount();
        for (int i = 1; i < count; i += 2) {
            if (document.getLineStartOffset(i) == document.getLineEndOffset(i)) continue;
            return false;
        }
        return true;
    }

    private static void fixSeparators(@NotNull Document document) {
        if (document == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (int i = 1; i < document.getLineCount(); ++i) {
                int start2 = document.getLineEndOffset(i);
                int end = document.getLineEndOffset(i) + document.getLineSeparatorLength(i);
                document.deleteString(start2, end);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/FixLineSeparatorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fixSeparators";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areSeparatorsBroken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

