/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameLanguageFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassAction
extends GotoActionBase
implements DumbAware {
    public GotoClassAction() {
        Presentation presentation = this.getTemplatePresentation();
        String text2 = GotoClassPresentationUpdater.getActionTitle() + "...";
        presentation.setText(IdeBundle.message("go.to.class.title.prefix", text2));
        presentation.setDescription(IdeBundle.messagePointer("go.to.class.action.description", StringUtil.join(GotoClassPresentationUpdater.getElementKinds(), "/")));
        this.addTextOverride("MainMenu", text2);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            GotoClassAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        boolean dumb = DumbService.isDumb(project2);
        if (Registry.is("new.search.everywhere")) {
            if (!dumb || new ClassSearchEverywhereContributor(e).isDumbAware()) {
                this.showInSearchEverywherePopup(ClassSearchEverywhereContributor.class.getSimpleName(), e, true, true);
            } else {
                GotoClassAction.invokeGoToFile(project2, e);
            }
        } else if (!dumb) {
            super.actionPerformed(e);
        } else {
            GotoClassAction.invokeGoToFile(project2, e);
        }
    }

    static void invokeGoToFile(@NotNull Project project2, @NotNull AnActionEvent e) {
        if (project2 == null) {
            GotoClassAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            GotoClassAction.$$$reportNull$$$0(2);
        }
        String actionTitle = StringUtil.trimEnd(ObjectUtils.notNull(e.getPresentation().getText(), GotoClassPresentationUpdater.getActionTitle()), "...");
        String message = IdeBundle.message("go.to.class.dumb.mode.message", actionTitle);
        DumbService.getInstance(project2).showDumbModeNotification(message);
        AnAction action2 = ActionManager.getInstance().getAction("GotoFile");
        InputEvent event = ActionCommand.getInputEvent("GotoFile");
        Component component2 = e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        ActionManager.getInstance().tryToExecute(action2, event, component2, e.getPlace(), true);
    }

    @Override
    public void gotoActionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            GotoClassAction.$$$reportNull$$$0(3);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.class");
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        final GotoClassModel2 model = new GotoClassModel2(project2);
        String pluralKinds = StringUtil.capitalize(StringUtil.join(GotoClassPresentationUpdater.getElementKinds(), s -> StringUtil.pluralize(s), "/"));
        String title = IdeBundle.message("go.to.class.toolwindow.title", pluralKinds);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Language>(){

            @Override
            protected ChooseByNameFilter<Language> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new ChooseByNameLanguageFilter(popup2, model, GotoClassSymbolConfiguration.getInstance(project2), project2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element2) {
                GotoClassAction.handleSubMemberNavigation(popup2, element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoClassAction$1", "createFilter"));
            }
        }, title, true);
    }

    static void handleSubMemberNavigation(ChooseByNamePopup popup2, Object element2) {
        if (element2 instanceof PsiElement && ((PsiElement)element2).isValid()) {
            OpenFileDescriptor descriptor2;
            OpenFileDescriptor n;
            PsiElement psiElement = GotoClassAction.getElement((PsiElement)element2, popup2);
            VirtualFile file2 = PsiUtilCore.getVirtualFile(psiElement = psiElement.getNavigationElement());
            if (file2 != null && popup2.getLinePosition() != -1 && (n = (descriptor2 = new OpenFileDescriptor(psiElement.getProject(), file2, popup2.getLinePosition(), popup2.getColumnPosition())).setUseCurrentWindow(popup2.isOpenInCurrentWindowRequested())).canNavigate()) {
                n.navigate(true);
                return;
            }
            if (file2 != null && popup2.getMemberPattern() != null) {
                NavigationUtil.activateFileWithPsiElement(psiElement, !popup2.isOpenInCurrentWindowRequested());
                Navigatable member = GotoClassAction.findMember(popup2.getMemberPattern(), popup2.getTrimmedText(), psiElement, file2);
                if (member != null) {
                    member.navigate(true);
                }
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, !popup2.isOpenInCurrentWindowRequested());
        } else {
            EditSourceUtil.navigate((NavigationItem)element2, true, popup2.isOpenInCurrentWindowRequested());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Navigatable findMember(String memberPattern, String fullPattern, PsiElement psiElement, VirtualFile file2) {
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder2 = factory == null ? null : factory.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors = FileEditorManager.getInstance(psiElement.getProject()).getEditors(file2);
        if (builder2 == null || editors.length == 0) {
            return null;
        }
        StructureView view = builder2.createStructureView(editors[0], psiElement.getProject());
        try {
            StructureViewTreeElement element2 = GotoClassAction.findElement(view.getTreeModel().getRoot(), psiElement, 4);
            if (element2 == null) {
                Navigatable navigatable = null;
                return navigatable;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher(memberPattern).build();
            int max = Integer.MIN_VALUE;
            Object target2 = null;
            for (TreeElement treeElement : element2.getChildren()) {
                int degree;
                if (!(treeElement instanceof StructureViewTreeElement)) continue;
                Object value2 = ((StructureViewTreeElement)treeElement).getValue();
                if (value2 instanceof PsiElement && value2 instanceof Navigatable && fullPattern.equals(CopyReferenceAction.elementToFqn((PsiElement)value2))) {
                    Navigatable navigatable = (Navigatable)value2;
                    return navigatable;
                }
                String presentableText = treeElement.getPresentation().getPresentableText();
                if (presentableText == null || (degree = matcher.matchingDegree(presentableText)) <= max) continue;
                max = degree;
                target2 = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable = target2 instanceof Navigatable ? (Navigatable)target2 : null;
            return navigatable;
        }
        finally {
            Disposer.dispose(view);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node, PsiElement element2, int hopes) {
        Object value2 = node.getValue();
        if (value2 instanceof PsiElement) {
            if (((PsiElement)value2).isEquivalentTo(element2)) {
                return node;
            }
            if (hopes != 0) {
                for (TreeElement child2 : node.getChildren()) {
                    StructureViewTreeElement e;
                    if (!(child2 instanceof StructureViewTreeElement) || (e = GotoClassAction.findElement((StructureViewTreeElement)child2, element2, hopes - 1)) == null) continue;
                    return e;
                }
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement getElement(@NotNull PsiElement element2, ChooseByNamePopup popup2) {
        String path2;
        if (element2 == null) {
            GotoClassAction.$$$reportNull$$$0(4);
        }
        if ((path2 = popup2.getPathToAnonymous()) != null) {
            return GotoClassAction.getElement(element2, path2);
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            GotoClassAction.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getElement(@NotNull PsiElement element2, @NotNull String path2) {
        if (element2 == null) {
            GotoClassAction.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            GotoClassAction.$$$reportNull$$$0(7);
        }
        String[] classes = path2.split("\\$");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String cls : classes) {
            if (cls.isEmpty()) continue;
            try {
                indexes.add(Integer.parseInt(cls) - 1);
            }
            catch (Exception e) {
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    GotoClassAction.$$$reportNull$$$0(8);
                }
                return psiElement;
            }
        }
        PsiElement current2 = element2;
        Iterator iterator2 = indexes.iterator();
        while (iterator2.hasNext()) {
            int index = (Integer)iterator2.next();
            PsiElement[] anonymousClasses = GotoClassAction.getAnonymousClasses(current2);
            if (index >= 0 && index < anonymousClasses.length) {
                current2 = anonymousClasses[index];
                continue;
            }
            PsiElement psiElement = current2;
            if (psiElement == null) {
                GotoClassAction.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        PsiElement psiElement = current2;
        if (psiElement == null) {
            GotoClassAction.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    private static PsiElement @NotNull [] getAnonymousClasses(@NotNull PsiElement element2) {
        if (element2 == null) {
            GotoClassAction.$$$reportNull$$$0(11);
        }
        for (AnonymousElementProvider provider : AnonymousElementProvider.EP_NAME.getExtensionList()) {
            PsiElement[] elements2 = provider.getAnonymousElements(element2);
            if (elements2.length <= 0) continue;
            if (elements2 == null) {
                GotoClassAction.$$$reportNull$$$0(12);
            }
            return elements2;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            GotoClassAction.$$$reportNull$$$0(13);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected boolean hasContributors(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GotoClassAction.$$$reportNull$$$0(14);
        }
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoClassAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoClassAction";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeGoToFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "gotoActionPerformed";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousClasses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasContributors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

