/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class InvalidateCachesAction
extends AnAction
implements DumbAware {
    public InvalidateCachesAction() {
        String text2 = ApplicationManager.getApplication().isRestartCapable() ? ActionsBundle.message("action.InvalidateCachesRestart.text", new Object[0]) : ActionsBundle.message("action.InvalidateCaches.text", new Object[0]);
        this.getTemplatePresentation().setText(text2);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InvalidateCachesAction.$$$reportNull$$$0(0);
        }
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        boolean mac = Messages.canShowMacSheetPanel();
        boolean canRestart = app.isRestartCapable();
        String[] options = new String[canRestart ? 4 : 3];
        options[0] = canRestart ? "Invalidate and &Restart" : "Invalidate and &Exit";
        options[1] = mac ? "Cancel" : "&Invalidate";
        String string = options[2] = mac ? "&Invalidate" : "Cancel";
        if (canRestart) {
            options[3] = "&Just Restart";
        }
        SmartList<String> descriptions = new SmartList<String>();
        boolean invalidateCachesInvalidatesVfs = Registry.is("idea.invalidate.caches.invalidates.vfs");
        if (invalidateCachesInvalidatesVfs) {
            descriptions.add("Local History");
        }
        for (CachesInvalidator invalidater : CachesInvalidator.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull(descriptions, invalidater.getDescription());
        }
        Collections.sort(descriptions);
        String warnings = "WARNING: ";
        if (descriptions.size() == 1) {
            warnings = warnings + (String)descriptions.get(0) + " will be also cleared.";
        } else if (!descriptions.isEmpty()) {
            warnings = warnings + "The following items will also be cleared:\n" + StringUtil.join(descriptions, s -> "  " + s, "\n");
        }
        String message = "The caches will be invalidated and rebuilt on the next startup.\n\n" + (descriptions.isEmpty() ? "" : warnings + "\n\n") + "Would you like to continue?\n";
        int result2 = Messages.showDialog(e.getData(CommonDataKeys.PROJECT), message, IdeBundle.message("dialog.title.invalidate.caches", new Object[0]), options, 0, Messages.getWarningIcon());
        if (result2 == -1 || result2 == (mac ? 1 : 2)) {
            return;
        }
        if (result2 == 3) {
            app.restart(true);
            return;
        }
        if (invalidateCachesInvalidatesVfs) {
            FSRecords.invalidateCaches();
        } else {
            FileBasedIndex.getInstance().invalidateCaches();
            GistManager.getInstance().invalidateData();
        }
        for (CachesInvalidator invalidater : CachesInvalidator.EP_NAME.getExtensions()) {
            invalidater.invalidateCaches();
        }
        if (result2 == 0) {
            app.restart(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/InvalidateCachesAction", "actionPerformed"));
    }
}

