/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.WindowAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.ScreenUtil;
import java.awt.Rectangle;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public class MaximizeActiveDialogAction
extends WindowAction {
    private static final String NORMAL_BOUNDS = "NORMAL_BOUNDS";

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MaximizeActiveDialogAction.$$$reportNull$$$0(0);
        }
        if (this.myWindow instanceof JDialog) {
            MaximizeActiveDialogAction.doMaximize((JDialog)this.myWindow);
        }
    }

    public static void doMaximize(JDialog dialog2) {
        if (MaximizeActiveDialogAction.canBeMaximized(dialog2)) {
            MaximizeActiveDialogAction.maximize(dialog2);
        } else if (MaximizeActiveDialogAction.canBeNormalized(dialog2)) {
            MaximizeActiveDialogAction.normalize(dialog2);
        }
    }

    public static boolean canBeMaximized(JDialog dialog2) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = dialog2 != null && dialog2.isResizable() ? dialog2.getRootPane() : null;
        if (rootPane == null) {
            return false;
        }
        return !ScreenUtil.getScreenRectangle(dialog2).equals(dialog2.getBounds());
    }

    public static void maximize(JDialog dialog2) {
        if (!MaximizeActiveDialogAction.canBeMaximized(dialog2)) {
            return;
        }
        dialog2.getRootPane().putClientProperty(NORMAL_BOUNDS, dialog2.getBounds());
        dialog2.setBounds(ScreenUtil.getScreenRectangle(dialog2));
    }

    public static boolean canBeNormalized(JDialog dialog2) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = dialog2 != null && dialog2.isResizable() ? dialog2.getRootPane() : null;
        if (rootPane == null) {
            return false;
        }
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle(dialog2);
        return dialog2.getBounds().equals(screenRectangle) && rootPane.getClientProperty(NORMAL_BOUNDS) instanceof Rectangle;
    }

    public static void normalize(JDialog dialog2) {
        if (!MaximizeActiveDialogAction.canBeNormalized(dialog2)) {
            return;
        }
        JRootPane rootPane = dialog2.getRootPane();
        Object value2 = rootPane.getClientProperty(NORMAL_BOUNDS);
        if (value2 instanceof Rectangle) {
            Rectangle bounds2 = (Rectangle)value2;
            ScreenUtil.fitToScreen(bounds2);
            dialog2.setBounds(bounds2);
            rootPane.putClientProperty(NORMAL_BOUNDS, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/MaximizeActiveDialogAction", "actionPerformed"));
    }
}

