/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OccurenceNavigatorActionBase
extends AnAction
implements DumbAware {
    OccurenceNavigatorActionBase() {
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e.getDataContext());
        if (navigator == null) {
            return;
        }
        if (!this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor2 = occurenceInfo.getNavigateable();
        if (descriptor2 != null && descriptor2.canNavigate()) {
            descriptor2.navigate(true);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        WindowManager.getInstance().getStatusBar(project2).setInfo(IdeBundle.message("message.occurrence.N.of.M", occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()));
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project2 = event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isMainMenuOrActionSearch(event.getPlace()));
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(event.getDataContext());
        if (navigator == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isMainMenuOrActionSearch(event.getPlace()));
            return;
        }
        presentation.setVisible(true);
        try {
            presentation.setEnabled(this.hasOccurenceToGo(navigator));
            presentation.setText(this.getDescription(navigator));
        }
        catch (IndexNotReadyException e) {
            presentation.setEnabled(false);
        }
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext) {
        ContentManager contentManager2 = ContentManagerUtil.getContentManagerFromContext(dataContext, false);
        if (contentManager2 != null) {
            OccurenceNavigator navigator;
            Content content2 = contentManager2.getSelectedContent();
            OccurenceNavigator occurenceNavigator = navigator = content2 != null ? OccurenceNavigatorActionBase.findNavigator(content2.getComponent()) : null;
            if (navigator != null) {
                return navigator;
            }
        }
        return (OccurenceNavigator)((Object)OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext));
    }

    @Nullable
    private static OccurenceNavigator findNavigator(JComponent parent) {
        LinkedList<JComponent> queue = new LinkedList<JComponent>();
        queue.addLast(parent);
        while (!queue.isEmpty()) {
            JComponent component2 = (JComponent)queue.removeFirst();
            if (component2 instanceof OccurenceNavigator) {
                return (OccurenceNavigator)((Object)component2);
            }
            if (component2 instanceof JTabbedPane) {
                JComponent selectedComponent = (JComponent)((JTabbedPane)component2).getSelectedComponent();
                if (selectedComponent == null) continue;
                queue.addLast(selectedComponent);
                continue;
            }
            if (component2 == null) continue;
            for (int i = 0; i < component2.getComponentCount(); ++i) {
                Component child2 = component2.getComponent(i);
                if (!(child2 instanceof JComponent)) continue;
                queue.addLast((JComponent)child2);
            }
        }
        return null;
    }

    @Nullable
    private static Component getOccurenceNavigatorFromContext(DataContext dataContext) {
        Project project2;
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window != null) {
            Component component3;
            for (Component c = component3 = window.getFocusOwner(); c != null; c = c.getParent()) {
                if (!(c instanceof OccurenceNavigator)) continue;
                return c;
            }
        }
        if ((project2 = CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project2);
        String id2 = mgr.getLastActiveToolWindowId(component2 -> OccurenceNavigatorActionBase.findNavigator(component2) != null);
        if (id2 == null) {
            return null;
        }
        return (Component)((Object)OccurenceNavigatorActionBase.findNavigator(mgr.getToolWindow(id2).getComponent()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/OccurenceNavigatorActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

