/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(0);
        }
        boolean showFiles = (project2 = e.getProject()) != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor2 = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        VirtualFile toSelect2 = null;
        if (StringUtil.isNotEmpty(GeneralSettings.getInstance().getDefaultProjectDirectory())) {
            toSelect2 = VfsUtil.findFileByIoFile(new File(GeneralSettings.getInstance().getDefaultProjectDirectory()), true);
        }
        descriptor2.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, toSelect2 == null && showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, project2, toSelect2 != null ? toSelect2 : this.getPathToSelect(), files2 -> {
            for (VirtualFile file2 : files2) {
                if (descriptor2.isFileSelectable(file2)) continue;
                String message = IdeBundle.message("error.dir.contains.no.project", file2.getPresentableUrl());
                Messages.showInfoMessage(project2, message, IdeBundle.message("title.cannot.open.project", new Object[0]));
                return;
            }
            for (VirtualFile file2 : files2) {
                OpenFileAction.doOpenFile(project2, file2);
            }
        });
    }

    @Nullable
    protected VirtualFile getPathToSelect() {
        return VfsUtil.getUserHomeDir();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Actions.Menu_open);
        }
    }

    private static void doOpenFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            OpenFileAction.$$$reportNull$$$0(2);
        }
        if (file2.isDirectory()) {
            boolean preferAttach;
            Path filePath2 = Paths.get(file2.getPath(), new String[0]);
            boolean canAttach = ProjectAttachProcessor.canAttachToProject();
            boolean bl = preferAttach = PlatformUtils.isDataGrip() && project2 != null && canAttach && !ProjectUtil.isValidProjectPath(filePath2);
            if (preferAttach && PlatformProjectOpenProcessor.attachToProject(project2, filePath2, null)) {
                return;
            }
            Project openedProject = canAttach ? PlatformProjectOpenProcessor.doOpenProject(filePath2, new OpenProjectTask(false, project2)) : ProjectUtil.openOrImport(file2.getPath(), project2, false);
            FileChooserUtil.setLastOpenedFile(openedProject, file2);
            return;
        }
        if ((project2 == null || !file2.equals(project2.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file2)) {
            int answer;
            int n = answer = file2.getFileType() instanceof ProjectFileType ? 0 : Messages.showYesNoCancelDialog(project2, IdeBundle.message("message.open.file.is.project", file2.getName()), IdeBundle.message("title.open.project", new Object[0]), IdeBundle.message("message.open.file.is.project.open.as.project", new Object[0]), IdeBundle.message("message.open.file.is.project.open.as.file", new Object[0]), IdeBundle.message("button.cancel", new Object[0]), Messages.getQuestionIcon());
            if (answer == 2) {
                return;
            }
            if (answer == 0) {
                Project openedProject = ProjectUtil.openOrImport(file2.getPath(), project2, false);
                if (openedProject != null) {
                    FileChooserUtil.setLastOpenedFile(openedProject, file2);
                }
                return;
            }
        }
        LightEditUtil.markUnknownFileTypeAsPlainTextIfNeeded(project2, file2);
        FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file2, project2);
        if (type == null) {
            return;
        }
        if (project2 != null && !project2.isDefault()) {
            OpenFileAction.openFile(file2, project2);
        } else if (LightEdit.openFile(file2)) {
            LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.WelcomeScreenOpenAction);
        } else {
            PlatformProjectOpenProcessor.createTempProjectAndOpenFile(Paths.get(file2.getPath(), new String[0]), new OpenProjectTask());
        }
    }

    public static void openFile(String filePath2, @NotNull Project project2) {
        VirtualFile file2;
        if (project2 == null) {
            OpenFileAction.$$$reportNull$$$0(3);
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath2)) != null && file2.isValid()) {
            OpenFileAction.openFile(file2, project2);
        }
    }

    public static void openFile(VirtualFile file2, @NotNull Project project2) {
        if (project2 == null) {
            OpenFileAction.$$$reportNull$$$0(4);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        if (LightEdit.owns(project2)) {
            if (LightEdit.openFile(file2)) {
                LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.LightEditOpenAction);
            }
        } else {
            PsiNavigationSupport.getInstance().createNavigatable(project2, file2, -1).navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/OpenFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message("title.open.file.or.project", new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        @Override
        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message("title.open.project", new Object[0]));
        }
    }

    public static class OnWelcomeScreen
    extends OpenFileAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OnWelcomeScreen.$$$reportNull$$$0(0);
            }
            if (!NewWelcomeScreen.isNewWelcomeScreen(e)) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/OpenFileAction$OnWelcomeScreen", "update"));
        }
    }
}

