/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.SystemProperties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    private static final boolean ourCanInspectDirs = SystemProperties.getBooleanProperty("idea.chooser.lookup.for.project.dirs", true);

    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        this(chooseFiles, chooseFiles);
    }

    public OpenProjectFileChooserDescriptor(boolean chooseFiles, boolean chooseJars) {
        super(chooseFiles, true, chooseJars, chooseJars, false, false);
        this.setHideIgnored(false);
    }

    @Override
    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
        return super.isFileVisible(file2, showHiddenFiles) && (file2.isDirectory() || OpenProjectFileChooserDescriptor.isProjectFile(file2));
    }

    @Override
    public boolean isFileSelectable(VirtualFile file2) {
        return OpenProjectFileChooserDescriptor.isProjectDirectory(file2) || OpenProjectFileChooserDescriptor.isProjectFile(file2);
    }

    @Override
    public Icon getIcon(VirtualFile file2) {
        if (OpenProjectFileChooserDescriptor.canInspectDirectory(file2)) {
            if (OpenProjectFileChooserDescriptor.isIprFile(file2) || OpenProjectFileChooserDescriptor.isIdeaDirectory(file2)) {
                return OpenProjectFileChooserDescriptor.dressIcon(file2, ProductIcons.getInstance().getProjectNodeIcon());
            }
            Icon icon2 = OpenProjectFileChooserDescriptor.getImporterIcon(file2);
            if (icon2 != null) {
                return OpenProjectFileChooserDescriptor.dressIcon(file2, icon2);
            }
        }
        return super.getIcon(file2);
    }

    private static boolean canInspectDirectory(VirtualFile file2) {
        VirtualFile parent;
        VirtualFile home = VfsUtil.getUserHomeDir();
        if (home == null || VfsUtilCore.isAncestor(file2, home, false)) {
            return false;
        }
        if (VfsUtilCore.isAncestor(home, file2, true)) {
            return true;
        }
        if (SystemInfo.isUnix && file2.isInLocalFileSystem() && (parent = file2.getParent()) != null && parent.getParent() == null) {
            return false;
        }
        return ourCanInspectDirs;
    }

    private static Icon getImporterIcon(VirtualFile file2) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider(file2);
        if (provider != null) {
            return file2.isDirectory() && provider.lookForProjectsInDirectory() ? ProductIcons.getInstance().getProjectNodeIcon() : provider.getIcon(file2);
        }
        return null;
    }

    public static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OpenProjectFileChooserDescriptor.$$$reportNull$$$0(0);
        }
        return !file2.isDirectory() && file2.isValid() && (OpenProjectFileChooserDescriptor.isIprFile(file2) || OpenProjectFileChooserDescriptor.hasImportProvider(file2));
    }

    private static boolean isProjectDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OpenProjectFileChooserDescriptor.$$$reportNull$$$0(1);
        }
        return file2.isDirectory() && file2.isValid() && (OpenProjectFileChooserDescriptor.isIdeaDirectory(file2) || OpenProjectFileChooserDescriptor.hasImportProvider(file2));
    }

    private static boolean isIprFile(VirtualFile file2) {
        return "ipr".equalsIgnoreCase(file2.getExtension());
    }

    private static boolean isIdeaDirectory(VirtualFile file2) {
        return ProjectKt.getProjectStoreDirectory(file2) != null;
    }

    private static boolean hasImportProvider(VirtualFile file2) {
        return ProjectOpenProcessor.getImportProvider(file2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/ide/actions/OpenProjectFileChooserDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

