/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinActiveTabAction
extends DumbAwareAction
implements Toggleable {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Handler handler2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(0);
        }
        if ((handler2 = this.getHandler(e)) == null) {
            return;
        }
        boolean selected2 = !handler2.isPinned;
        handler2.setPinned(selected2);
        Toggleable.setSelected(e.getPresentation(), selected2);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Handler handler2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (handler2 = this.getHandler(e)) != null;
        boolean selected2 = enabled && handler2.isPinned;
        e.getPresentation().setIcon(e.isFromActionToolbar() ? AllIcons.General.Pin_tab : null);
        Toggleable.setSelected(e.getPresentation(), selected2);
        String text2 = ActionPlaces.isMainMenuOrActionSearch(e.getPlace()) || handler2 != null && !handler2.isActiveTab ? (selected2 ? IdeBundle.message("action.unpin.active.tab", new Object[0]) : IdeBundle.message("action.pin.active.tab", new Object[0])) : (selected2 ? IdeBundle.message("action.unpin.tab", new Object[0]) : IdeBundle.message("action.pin.tab", new Object[0]));
        e.getPresentation().setText(text2);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected Handler getHandler(@NotNull AnActionEvent e) {
        VirtualFile selectedFile;
        Content content2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(2);
        }
        Project project2 = e.getProject();
        EditorWindow currentWindow = e.getData(EditorWindow.DATA_KEY);
        Content content3 = content2 = currentWindow != null ? null : this.getContentFromEvent(e);
        if (content2 != null && content2.isPinnable()) {
            return PinActiveTabAction.createHandler(content2);
        }
        EditorWindow window = currentWindow != null ? currentWindow : (project2 != null ? FileEditorManagerEx.getInstanceEx(project2).getCurrentWindow() : null);
        VirtualFile virtualFile2 = selectedFile = window == null ? null : this.getFileFromEvent(e, window);
        if (selectedFile != null) {
            return PinActiveTabAction.createHandler(window, selectedFile);
        }
        return null;
    }

    @Nullable
    protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(3);
        }
        if (window == null) {
            PinActiveTabAction.$$$reportNull$$$0(4);
        }
        return PinActiveTabAction.getFileInWindow(e, window);
    }

    @Nullable
    protected Content getContentFromEvent(@NotNull AnActionEvent e) {
        Content content2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(5);
        }
        if ((content2 = PinActiveTabAction.getNonToolWindowContent(e)) == null) {
            content2 = PinActiveTabAction.getToolWindowContent(e);
        }
        return content2 != null && content2.isValid() ? content2 : null;
    }

    @NotNull
    private static Handler createHandler(final Content content2) {
        return new Handler(content2.isPinned(), Objects.requireNonNull(content2.getManager()).getSelectedContent() == content2){

            @Override
            void setPinned(boolean value2) {
                content2.setPinned(value2);
            }
        };
    }

    @NotNull
    private static Handler createHandler(final EditorWindow window, final VirtualFile selectedFile) {
        return new Handler(window.isFilePinned(selectedFile), selectedFile.equals(window.getSelectedFile())){

            @Override
            void setPinned(boolean value2) {
                window.setFilePinned(selectedFile, value2);
            }
        };
    }

    @Nullable
    private static Content getNonToolWindowContent(@NotNull AnActionEvent e) {
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(6);
        }
        Content result2 = null;
        Content[] contents = e.getData(ViewContext.CONTENT_KEY);
        if (contents != null && contents.length == 1) {
            result2 = contents[0];
        }
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        ContentManager contentManager2 = ContentManagerUtil.getContentManagerFromContext(e.getDataContext(), true);
        Content content2 = result2 = contentManager2 != null ? contentManager2.getSelectedContent() : null;
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        return null;
    }

    @Nullable
    private static Content getToolWindowContent(@NotNull AnActionEvent e) {
        ToolWindow window;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(7);
        }
        Content result2 = (window = e.getData(PlatformDataKeys.TOOL_WINDOW)) != null ? window.getContentManager().getSelectedContent() : null;
        return result2 != null && result2.isPinnable() ? result2 : null;
    }

    @Nullable
    private static VirtualFile getFileInWindow(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        VirtualFile file2;
        if (e == null) {
            PinActiveTabAction.$$$reportNull$$$0(8);
        }
        if (window == null) {
            PinActiveTabAction.$$$reportNull$$$0(9);
        }
        if ((file2 = e.getData(CommonDataKeys.VIRTUAL_FILE)) == null) {
            file2 = window.getSelectedFile();
        }
        if (file2 != null && window.isFileOpen(file2)) {
            return file2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileFromEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentFromEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNonToolWindowContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolWindowContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileInWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class EW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                EW.$$$reportNull$$$0(0);
            }
            if (window == null) {
                EW.$$$reportNull$$$0(1);
            }
            return window.getSelectedFile();
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                EW.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction$EW";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileFromEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFromEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                TW.$$$reportNull$$$0(0);
            }
            if (window == null) {
                TW.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                TW.$$$reportNull$$$0(2);
            }
            return PinActiveTabAction.getToolWindowContent(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/PinActiveTabAction$TW";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileFromEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentFromEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Handler {
        public final boolean isPinned;
        public final boolean isActiveTab;

        abstract void setPinned(boolean var1);

        public Handler(boolean isPinned, boolean isActiveTab) {
            this.isPinned = isPinned;
            this.isActiveTab = isActiveTab;
        }
    }
}

