/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    @Override
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            QuickChangeColorSchemeAction.$$$reportNull$$$0(1);
        }
        EditorColorsScheme current2 = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme : EditorColorsManager.getInstance().getAllSchemes()) {
            QuickChangeColorSchemeAction.addScheme(group, current2, scheme, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, EditorColorsScheme current2, final EditorColorsScheme scheme, final boolean addScheme) {
        group.add(new DumbAwareAction(scheme.getDisplayName(), "", scheme == current2 ? AllIcons.Actions.Forward : ourNotCurrentAction){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme);
                QuickChangeColorSchemeAction.changeLafIfNecessary(scheme);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeColorSchemeAction$1", "actionPerformed"));
            }
        });
    }

    public static void changeLafIfNecessary(EditorColorsScheme scheme) {
        QuickChangeColorSchemeAction.changeLafIfNecessary(scheme, null);
    }

    public static void changeLafIfNecessary(EditorColorsScheme scheme, @Nullable Runnable onDone) {
        UIManager.LookAndFeelInfo currentLafInfo;
        UITheme theme;
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        LafManager lafManager = LafManager.getInstance();
        boolean isDarkEditorTheme = ColorUtil.isDark(scheme.getDefaultBackground());
        UIManager.LookAndFeelInfo suitableLaf = null;
        String schemeName = SchemeManager.getBaseName(scheme);
        for (UIManager.LookAndFeelInfo laf : lafManager.getInstalledLookAndFeels()) {
            if (!(laf instanceof UIThemeBasedLookAndFeelInfo) || !schemeName.equals(((UIThemeBasedLookAndFeelInfo)laf).getTheme().getEditorSchemeName())) continue;
            suitableLaf = laf;
            break;
        }
        UITheme uITheme = theme = (currentLafInfo = lafManager.getCurrentLookAndFeel()) instanceof UIThemeBasedLookAndFeelInfo ? ((UIThemeBasedLookAndFeelInfo)currentLafInfo).getTheme() : null;
        if (isDarkEditorTheme && (UIUtil.isUnderIntelliJLaF() || theme != null && !theme.isDark())) {
            if (Messages.showYesNoDialog(ApplicationBundle.message("color.scheme.theme.change.confirmation", "dark", productName), ApplicationBundle.message("color.scheme.theme.change.confirmation.title", productName), Messages.getYesButton(), Messages.getNoButton(), Messages.getQuestionIcon()) == 0) {
                lafManager.setCurrentLookAndFeel(suitableLaf != null ? suitableLaf : new DarculaLookAndFeelInfo(), true);
                lafManager.updateUI();
                SwingUtilities.invokeLater(DarculaInstaller::install);
            }
        } else if (!isDarkEditorTheme && (StartupUiUtil.isUnderDarcula() || theme != null && theme.isDark()) && lafManager instanceof LafManagerImpl && Messages.showYesNoDialog(ApplicationBundle.message("color.scheme.theme.change.confirmation", "bright", productName), ApplicationBundle.message("color.scheme.theme.change.confirmation.title", productName), Messages.getYesButton(), Messages.getNoButton(), Messages.getQuestionIcon()) == 0) {
            lafManager.setCurrentLookAndFeel(suitableLaf != null ? suitableLaf : ((LafManagerImpl)lafManager).getDefaultLaf(), true);
            lafManager.updateUI();
            SwingUtilities.invokeLater(DarculaInstaller::uninstall);
        }
        if (onDone != null) {
            SwingUtilities.invokeLater(onDone);
        }
    }

    @Override
    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "group";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/QuickChangeColorSchemeAction";
        objectArray[2] = "fillActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

