/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.components.JBComponent;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecentLocationsRenderer
extends ColoredListCellRenderer<RecentLocationItem> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SpeedSearch mySpeedSearch;
    @NotNull
    private final RecentLocationsDataModel myData;
    @NotNull
    private final JBCheckBox myCheckBox;

    RecentLocationsRenderer(@NotNull Project project2, @NotNull SpeedSearch speedSearch, @NotNull RecentLocationsDataModel data2, @NotNull JBCheckBox checkBox2) {
        if (project2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(0);
        }
        if (speedSearch == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(1);
        }
        if (data2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(2);
        }
        if (checkBox2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.mySpeedSearch = speedSearch;
        this.myData = data2;
        this.myCheckBox = checkBox2;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends RecentLocationItem> list2, RecentLocationItem value2, int index, boolean selected2, boolean hasFocus) {
        EditorEx editor = value2.getEditor();
        if (this.myProject.isDisposed() || editor.isDisposed()) {
            return super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        String breadcrumbs = this.myData.getBreadcrumbsMap(this.myCheckBox.isSelected()).get(value2.getInfo());
        JPanel panel2 = new JPanel(new VerticalFlowLayout(0, 0));
        if (index != 0) {
            panel2.add(RecentLocationsRenderer.createSeparatorLine(colorsScheme));
        }
        panel2.add(RecentLocationsRenderer.createTitleComponent(this.myProject, list2, this.mySpeedSearch, breadcrumbs, value2.getInfo(), colorsScheme, selected2));
        panel2.add(RecentLocationsRenderer.setupEditorComponent(editor, editor.getDocument().getText(), this.mySpeedSearch, colorsScheme, selected2));
        return panel2;
    }

    @NotNull
    private static Color getBackgroundColor(@NotNull EditorColorsScheme colorsScheme, boolean selected2) {
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(4);
        }
        Color color = selected2 ? HintUtil.getRecentLocationsSelectionColor(colorsScheme) : colorsScheme.getDefaultBackground();
        if (color == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(5);
        }
        return color;
    }

    @NotNull
    private static JComponent createTitleComponent(@NotNull Project project2, @NotNull JList<? extends RecentLocationItem> list2, @NotNull SpeedSearch speedSearch, @Nullable String breadcrumb, @NotNull IdeDocumentHistoryImpl.PlaceInfo placeInfo, @NotNull EditorColorsScheme colorsScheme, boolean selected2) {
        if (project2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(6);
        }
        if (list2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(7);
        }
        if (speedSearch == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(8);
        }
        if (placeInfo == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(9);
        }
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(10);
        }
        BorderLayoutPanel title = ((BorderLayoutPanel)JBUI.Panels.simplePanel().withBorder(JBUI.Borders.empty())).addToLeft(RecentLocationsRenderer.createTitleTextComponent(project2, list2, speedSearch, placeInfo, colorsScheme, breadcrumb, selected2));
        title.setBorder(JBUI.Borders.empty(8, 6, 5, 0));
        title.setBackground(RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected2));
        BorderLayoutPanel borderLayoutPanel = title;
        if (borderLayoutPanel == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(11);
        }
        return borderLayoutPanel;
    }

    @NotNull
    private static JPanel createSeparatorLine(@NotNull EditorColorsScheme colorsScheme) {
        Color color;
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(12);
        }
        if ((color = colorsScheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR)) == null) {
            color = JBColor.namedColor("Group.separatorColor", new JBColor(Gray.xCD, Gray.x51));
        }
        JBComponent jBComponent = JBUI.Panels.simplePanel().withBorder(JBUI.Borders.customLine(color, 1, 0, 0, 0));
        if (jBComponent == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(13);
        }
        return jBComponent;
    }

    @NotNull
    private static JComponent setupEditorComponent(@NotNull EditorEx editor, @NotNull String text2, @NotNull SpeedSearch speedSearch, @NotNull EditorColorsScheme colorsScheme, boolean selected2) {
        Iterable<TextRange> ranges2;
        if (editor == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(15);
        }
        if (speedSearch == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(16);
        }
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(17);
        }
        if ((ranges2 = speedSearch.matchingFragments(text2)) != null) {
            RecentLocationsRenderer.selectSearchResultsInEditor(editor, ranges2.iterator());
        } else {
            RecentLocationsAction.clearSelectionInEditor(editor);
        }
        editor.setBackgroundColor(RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected2));
        editor.setBorder(JBUI.Borders.empty(0, 4, 6, 0));
        if (RecentLocationsAction.getEmptyFileText().equals(editor.getDocument().getText())) {
            editor.getMarkupModel().addRangeHighlighter(0, RecentLocationsAction.getEmptyFileText().length(), 1000, RecentLocationsRenderer.createEmptyTextForegroundTextAttributes(colorsScheme), HighlighterTargetArea.EXACT_RANGE);
        }
        JComponent jComponent = editor.getComponent();
        if (jComponent == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(18);
        }
        return jComponent;
    }

    @NotNull
    private static SimpleColoredComponent createTitleTextComponent(@NotNull Project project2, @NotNull JList<? extends RecentLocationItem> list2, @NotNull SpeedSearch speedSearch, @NotNull IdeDocumentHistoryImpl.PlaceInfo placeInfo, @NotNull EditorColorsScheme colorsScheme, @Nullable String breadcrumbText, boolean selected2) {
        Icon icon2;
        String fileName;
        if (project2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(19);
        }
        if (list2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(20);
        }
        if (speedSearch == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(21);
        }
        if (placeInfo == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(22);
        }
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(23);
        }
        SimpleColoredComponent titleTextComponent = new SimpleColoredComponent();
        String text2 = fileName = placeInfo.getFile().getName();
        titleTextComponent.append(fileName, RecentLocationsRenderer.createFileNameTextAttributes(colorsScheme, selected2));
        if (StringUtil.isNotEmpty(breadcrumbText) && !StringUtil.equals(breadcrumbText, fileName)) {
            text2 = text2 + " " + breadcrumbText;
            titleTextComponent.append("  ");
            titleTextComponent.append(breadcrumbText, RecentLocationsRenderer.createBreadcrumbsTextAttributes(colorsScheme, selected2));
        }
        if ((icon2 = RecentLocationsRenderer.fetchIcon(project2, placeInfo)) != null) {
            titleTextComponent.setIcon(icon2);
            titleTextComponent.setIconTextGap(4);
        }
        titleTextComponent.setBorder(JBUI.Borders.empty());
        if (!SystemInfo.isWindows) {
            titleTextComponent.setFont(FontUtil.minusOne(UIUtil.getLabelFont()));
        }
        if (speedSearch.matchingFragments(text2) != null) {
            SpeedSearchUtil.applySpeedSearchHighlighting(list2, titleTextComponent, false, selected2);
        }
        long timeStamp = placeInfo.getTimeStamp();
        if (UISettings.getInstance().getShowInplaceComments() && Registry.is("show.last.visited.timestamps") && timeStamp != -1L) {
            titleTextComponent.append(" " + DateFormatUtil.formatPrettyDateTime(timeStamp), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
        SimpleColoredComponent simpleColoredComponent = titleTextComponent;
        if (simpleColoredComponent == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(24);
        }
        return simpleColoredComponent;
    }

    @Nullable
    private static Icon fetchIcon(@NotNull Project project2, @NotNull IdeDocumentHistoryImpl.PlaceInfo placeInfo) {
        if (project2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(25);
        }
        if (placeInfo == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(26);
        }
        return IconUtil.getIcon((VirtualFile)placeInfo.getFile(), (int)2, (Project)project2);
    }

    @NotNull
    private static SimpleTextAttributes createFileNameTextAttributes(@NotNull EditorColorsScheme colorsScheme, boolean selected2) {
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(27);
        }
        TextAttributes textAttributes = RecentLocationsRenderer.createDefaultTextAttributesWithBackground(colorsScheme, RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected2));
        textAttributes.setFontType(1);
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        if (simpleTextAttributes == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(28);
        }
        return simpleTextAttributes;
    }

    @NotNull
    private static SimpleTextAttributes createBreadcrumbsTextAttributes(@NotNull EditorColorsScheme colorsScheme, boolean selected2) {
        Color unusedForeground;
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(29);
        }
        Color backgroundColor = RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected2);
        TextAttributes attributes = colorsScheme.getAttributes(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        if (attributes != null && (unusedForeground = attributes.getForegroundColor()) != null) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)new TextAttributes(unusedForeground, backgroundColor, null, null, 0));
            if (simpleTextAttributes == null) {
                RecentLocationsRenderer.$$$reportNull$$$0(30);
            }
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)RecentLocationsRenderer.createDefaultTextAttributesWithBackground(colorsScheme, backgroundColor));
        if (simpleTextAttributes == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(31);
        }
        return simpleTextAttributes;
    }

    @NotNull
    private static TextAttributes createDefaultTextAttributesWithBackground(@NotNull EditorColorsScheme colorsScheme, @NotNull Color backgroundColor) {
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(32);
        }
        if (backgroundColor == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(33);
        }
        TextAttributes defaultTextAttributes = new TextAttributes();
        TextAttributes textAttributes = colorsScheme.getAttributes(HighlighterColors.TEXT);
        if (textAttributes != null) {
            defaultTextAttributes = textAttributes.clone();
            defaultTextAttributes.setBackgroundColor(backgroundColor);
        }
        TextAttributes textAttributes2 = defaultTextAttributes;
        if (textAttributes2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(34);
        }
        return textAttributes2;
    }

    @NotNull
    private static TextAttributes createEmptyTextForegroundTextAttributes(@NotNull EditorColorsScheme colorsScheme) {
        TextAttributes unusedAttributes;
        if (colorsScheme == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(35);
        }
        TextAttributes textAttributes = (unusedAttributes = colorsScheme.getAttributes(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES)) != null ? unusedAttributes : SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes();
        if (textAttributes == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(36);
        }
        return textAttributes;
    }

    @Override
    protected void customizeCellRenderer(@NotNull JList<? extends RecentLocationItem> list2, RecentLocationItem value2, int index, boolean selected2, boolean hasFocus) {
        if (list2 == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(37);
        }
    }

    private static void selectSearchResultsInEditor(@NotNull Editor editor, @NotNull Iterator<? extends TextRange> resultIterator) {
        if (editor == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(38);
        }
        if (resultIterator == null) {
            RecentLocationsRenderer.$$$reportNull$$$0(39);
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return;
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            TextRange findResult = resultIterator.next();
            int caretOffset = findResult.getEndOffset();
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible(editor, caretOffset);
            EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
            EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
            caretStates.add(new CaretState(editor.offsetToLogicalPosition(caretOffset), editor.offsetToLogicalPosition(selectionStartOffset), editor.offsetToLogicalPosition(selectionEndOffset)));
        }
        if (caretStates.isEmpty()) {
            return;
        }
        editor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 17: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RecentLocationsRenderer";
                break;
            }
            case 7: 
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RecentLocationsRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitleComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparatorLine";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setupEditorComponent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitleTextComponent";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileNameTextAttributes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreadcrumbsTextAttributes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTextAttributesWithBackground";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTextForegroundTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTitleComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupEditorComponent";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTitleTextComponent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fetchIcon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createFileNameTextAttributes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createBreadcrumbsTextAttributes";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultTextAttributesWithBackground";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTextForegroundTextAttributes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "selectSearchResultsInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

