/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowScrollable;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeToolWindowAction
extends AnAction
implements DumbAware,
FusAwareAction {
    private ToolWindow myLastWindow;
    private ToolWindowManager myLastManager;
    protected JLabel myScrollHelper;
    private ToolWindow myToolWindow;
    private boolean myListenerInstalled;

    protected ResizeToolWindowAction() {
    }

    protected ResizeToolWindowAction(String text2) {
        super(text2);
    }

    protected ResizeToolWindowAction(String text2, String description, Icon icon2) {
        super(text2, description, icon2);
    }

    protected ResizeToolWindowAction(@NotNull ToolWindow toolWindow, String originalAction, JComponent component2) {
        if (toolWindow == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(0);
        }
        this.myToolWindow = toolWindow;
        new ShadowAction(this, ActionManager.getInstance().getAction(originalAction), component2, toolWindow.getDisposable());
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        Component owner;
        Project project2;
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            this.setDisabled(e);
            return;
        }
        if (!this.myListenerInstalled) {
            this.myListenerInstalled = true;
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

                @Override
                public void projectClosed(@NotNull Project project2) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ResizeToolWindowAction.this.setDisabled(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ResizeToolWindowAction$1", "projectClosed"));
                }
            });
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            this.setDisabled(e);
            return;
        }
        Window windowAncestor = SwingUtilities.getWindowAncestor(owner);
        if (!(windowAncestor instanceof IdeFrame) || windowAncestor instanceof IdeFrame.Child) {
            this.setDisabled(e);
            return;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance(project2);
        ToolWindow window = this.getToolWindow(project2);
        if (window != null) {
            if (!(window.isAvailable() && window.isVisible() && window.getType() != ToolWindowType.FLOATING && window.getType() != ToolWindowType.WINDOWED && window.isActive())) {
                this.setDisabled(e);
                return;
            }
            this.update(e, window, mgr);
            if (e.getPresentation().isEnabled()) {
                this.myLastWindow = window;
                this.myLastManager = mgr;
            } else {
                this.setDisabled(e);
            }
        } else {
            this.setDisabled(e);
        }
    }

    @Nullable
    private ToolWindow getToolWindow(@NotNull Project project2) {
        if (project2 == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(2);
        }
        if (this.myToolWindow != null) {
            return this.myToolWindow;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance(project2);
        String id2 = manager.getActiveToolWindowId();
        if (id2 != null) {
            return manager.getToolWindow(id2);
        }
        return null;
    }

    private void setDisabled(@Nullable AnActionEvent e) {
        if (e != null) {
            e.getPresentation().setEnabled(false);
        }
        this.myLastWindow = null;
        this.myLastManager = null;
        this.myToolWindow = null;
    }

    protected abstract void update(AnActionEvent var1, ToolWindow var2, ToolWindowManager var3);

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(3);
        }
        this.actionPerformed(e, this.myLastWindow, this.myLastManager);
    }

    @Override
    public void addAdditionalUsageData(@NotNull AnActionEvent event, @NotNull FeatureUsageData data2) {
        ToolWindow toolWindow;
        Project project2;
        if (event == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(4);
        }
        if (data2 == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(5);
        }
        if ((project2 = event.getProject()) != null && (toolWindow = this.getToolWindow(project2)) != null) {
            data2.addData("toolwindow", toolWindow.getId());
        }
    }

    @Nullable
    private ToolWindowScrollable getScrollable(ToolWindow toolWindow, boolean isHorizontalStretchingOffered) {
        ToolWindowScrollable scrollable = null;
        for (Component eachComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); eachComponent != null && SwingUtilities.isDescendingFrom(eachComponent, toolWindow.getComponent()); eachComponent = eachComponent.getParent()) {
            if (!(eachComponent instanceof ToolWindowScrollable)) continue;
            ToolWindowScrollable eachScrollable = (ToolWindowScrollable)((Object)eachComponent);
            if (isHorizontalStretchingOffered) {
                if (!eachScrollable.isHorizontalScrollingNeeded()) continue;
                scrollable = eachScrollable;
                break;
            }
            if (!eachScrollable.isVerticalScrollingNeeded()) continue;
            scrollable = eachScrollable;
            break;
        }
        if (scrollable == null) {
            scrollable = new DefaultToolWindowScrollable();
        }
        if (isHorizontalStretchingOffered && scrollable.isHorizontalScrollingNeeded() || !isHorizontalStretchingOffered && scrollable.isVerticalScrollingNeeded()) {
            return scrollable;
        }
        return null;
    }

    protected abstract void actionPerformed(AnActionEvent var1, ToolWindow var2, ToolWindowManager var3);

    protected void stretch(ToolWindow wnd, boolean isHorizontalStretching, boolean isIncrementAction) {
        ToolWindowScrollable scrollable = this.getScrollable(wnd, isHorizontalStretching);
        if (scrollable == null) {
            return;
        }
        ToolWindowAnchor anchor2 = wnd.getAnchor();
        if (isHorizontalStretching && !anchor2.isHorizontal()) {
            ResizeToolWindowAction.incWidth(wnd, scrollable.getNextHorizontalScroll(), anchor2 == ToolWindowAnchor.LEFT == isIncrementAction);
        } else if (!isHorizontalStretching && anchor2.isHorizontal()) {
            ResizeToolWindowAction.incHeight(wnd, scrollable.getNextVerticalScroll(), anchor2 == ToolWindowAnchor.TOP != isIncrementAction);
        }
    }

    private static void incWidth(ToolWindow wnd, int value2, boolean isPositive) {
        ((ToolWindowEx)wnd).stretchWidth(isPositive ? value2 : -value2);
    }

    private static void incHeight(ToolWindow wnd, int value2, boolean isPositive) {
        ((ToolWindowEx)wnd).stretchHeight(isPositive ? value2 : -value2);
    }

    private Dimension getReferenceSize() {
        if (this.myScrollHelper == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.myScrollHelper = new JLabel("W");
            } else {
                return new Dimension(1, 1);
            }
        }
        return this.myScrollHelper.getPreferredSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalUsageData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class DefaultToolWindowScrollable
    implements ToolWindowScrollable {
        private DefaultToolWindowScrollable() {
        }

        @Override
        public boolean isHorizontalScrollingNeeded() {
            return true;
        }

        @Override
        public int getNextHorizontalScroll() {
            return ((ResizeToolWindowAction)ResizeToolWindowAction.this).getReferenceSize().width * Registry.intValue("ide.windowSystem.hScrollChars");
        }

        @Override
        public boolean isVerticalScrollingNeeded() {
            return true;
        }

        @Override
        public int getNextVerticalScroll() {
            return ((ResizeToolWindowAction)ResizeToolWindowAction.this).getReferenceSize().height * Registry.intValue("ide.windowSystem.vScrollChars");
        }
    }

    public static class Down
    extends ResizeToolWindowAction {
        public Down() {
        }

        public Down(String text2) {
            super(text2);
        }

        public Down(String text2, String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Down(ToolWindow toolWindow, JComponent c) {
            super(toolWindow, "ResizeToolWindowDown", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, false, false);
        }
    }

    public static class Up
    extends ResizeToolWindowAction {
        public Up() {
        }

        public Up(String text2) {
            super(text2);
        }

        public Up(String text2, String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Up(ToolWindow toolWindow, JComponent c) {
            super(toolWindow, "ResizeToolWindowUp", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, false, true);
        }
    }

    public static class Right
    extends ResizeToolWindowAction {
        public Right() {
        }

        public Right(String text2) {
            super(text2);
        }

        public Right(String text2, String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Right(ToolWindow toolWindow, JComponent c) {
            super(toolWindow, "ResizeToolWindowRight", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, true, true);
        }
    }

    public static class Left
    extends ResizeToolWindowAction {
        public Left() {
        }

        public Left(String text2) {
            super(text2);
        }

        public Left(String text2, String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Left(@NotNull ToolWindow toolWindow, JComponent c) {
            if (toolWindow == null) {
                Left.$$$reportNull$$$0(0);
            }
            super(toolWindow, "ResizeToolWindowLeft", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ResizeToolWindowAction$Left", "<init>"));
        }
    }
}

