/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            SaveAsDirectoryBasedFormatAction.$$$reportNull$$$0(0);
        }
        if (!SaveAsDirectoryBasedFormatAction.isConvertableProject(project2 = e.getProject()) || Messages.showOkCancelDialog(project2, IdeBundle.message("message.project.will.be.saved.and.reopened.in.new.directory.based.format", new Object[0]), IdeBundle.message("dialog.title.save.project.to.directory.based.format", new Object[0]), Messages.getWarningIcon()) != 0) {
            return;
        }
        IProjectStore store = ProjectKt.getStateStore(project2);
        String baseDir = PathUtilRt.getParentPath(store.getProjectFilePath());
        File ideaDir = new File(baseDir, ".idea");
        if (ideaDir.exists() && ideaDir.isDirectory() || SaveAsDirectoryBasedFormatAction.createDir(ideaDir)) {
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ideaDir);
            store.clearStorages();
            store.setPath(baseDir);
            ProjectManagerEx.getInstanceEx().closeAndDispose(project2);
            ProjectUtil.openProject(baseDir, null, false);
        } else {
            Messages.showErrorDialog(project2, String.format("Unable to create '.idea' directory (%s)", ideaDir), IdeBundle.message("dialog.title.error.saving.project", new Object[0]));
        }
    }

    private static boolean createDir(File ideaDir) {
        try {
            VfsUtil.createDirectories(ideaDir.getPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveAsDirectoryBasedFormatAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        e.getPresentation().setVisible(SaveAsDirectoryBasedFormatAction.isConvertableProject(project2));
    }

    private static boolean isConvertableProject(@Nullable Project project2) {
        return project2 != null && !project2.isDefault() && !ProjectKt.isDirectoryBased(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/SaveAsDirectoryBasedFormatAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

