/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    public SearchEverywherePsiRenderer() {
        this.setFocusBorderEnabled(false);
        this.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                Component right = this.getLayoutComponent("East");
                Component left = this.getLayoutComponent("West");
                if (right != null && left != null && left.getBounds().x + left.getBounds().width > right.getBounds().x) {
                    Rectangle bounds2 = right.getBounds();
                    int newX = left.getBounds().x + left.getBounds().width;
                    right.setBounds(newX, bounds2.y, bounds2.width - (newX - bounds2.x), bounds2.height);
                }
            }
        });
    }

    @Override
    public String getElementText(PsiElement element2) {
        VirtualFile file2;
        VirtualFile virtualFile2 = element2 instanceof PsiFile ? PsiUtilCore.getVirtualFile(element2) : (file2 = element2 instanceof VirtualFile ? (VirtualFile)((Object)element2) : null);
        if (file2 != null) {
            return VfsPresentationUtil.getPresentableNameForUI(element2.getProject(), file2);
        }
        String name = element2 instanceof PsiNamedElement ? ((PsiNamedElement)element2).getName() : null;
        return StringUtil.notNullize(name, "<unnamed>");
    }

    @Override
    @Nullable
    protected String getContainerText(PsiElement element2, String name) {
        return this.getContainerTextForLeftComponent(element2, name, -1, (FontMetrics)null);
    }

    @Override
    @Nullable
    protected String getContainerTextForLeftComponent(PsiElement element2, String name, int maxWidth, FontMetrics fm) {
        boolean in;
        String text2 = SymbolPresentationUtil.getSymbolContainerText(element2);
        if (text2 == null) {
            return null;
        }
        if (text2.startsWith("(") && text2.endsWith(")")) {
            text2 = text2.substring(1, text2.length() - 1);
        }
        if ((text2.contains("/") || text2.contains(File.separator)) && element2 instanceof PsiFileSystemItem) {
            Project project2 = element2.getProject();
            String basePath = Optional.ofNullable(project2.getBasePath()).map(FileUtil::toSystemDependentName).orElse(null);
            VirtualFile file2 = ((PsiFileSystemItem)element2).getVirtualFile();
            if (file2 != null) {
                text2 = FileUtil.toSystemDependentName(text2);
                String filePath2 = FileUtil.toSystemDependentName(file2.getPath());
                if (basePath != null && FileUtil.isAncestor(basePath, filePath2, true)) {
                    text2 = ObjectUtils.notNull(FileUtil.getRelativePath(basePath, text2, File.separatorChar), text2);
                } else {
                    String rootPath = Optional.ofNullable(GotoFileCellRenderer.getAnyRoot(file2, project2)).map(root -> FileUtil.toSystemDependentName(root.getPath())).filter(root -> basePath != null && FileUtil.isAncestor(basePath, root, true)).orElse(null);
                    String string = text2 = rootPath != null ? ObjectUtils.notNull(FileUtil.getRelativePath(rootPath, text2, File.separatorChar), text2) : FileUtil.getLocationRelativeToUserHome(text2);
                }
            }
        }
        if (in = text2.startsWith("in ")) {
            text2 = text2.substring(3);
        }
        String left = in ? "in " : "";
        String adjustedText = left + text2;
        if (maxWidth < 0) {
            return adjustedText;
        }
        int fullWidth = fm.stringWidth(adjustedText);
        if (fullWidth < maxWidth) {
            return adjustedText;
        }
        String separator = text2.contains("/") ? "/" : (SystemInfo.isWindows && text2.contains("\\") ? "\\" : (text2.contains(".") ? "." : (text2.contains("-") ? "-" : " ")));
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split(text2, separator));
        while (parts.size() > 1) {
            int index = parts.size() / 2 - 1;
            parts.remove(index);
            if (fm.stringWidth(StringUtil.join(parts, separator) + "...") >= maxWidth) continue;
            parts.add(index, "...");
            return left + StringUtil.join(parts, separator);
        }
        int adjustedWidth = Math.max(adjustedText.length() * maxWidth / fullWidth - 1, left.length() + 3);
        return StringUtil.trimMiddle(adjustedText, adjustedWidth);
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
        return GotoFileCellRenderer.doCustomizeNonPsiElementLeftRenderer(renderer, list2, value2, this.getNavigationItemAttributes(value2));
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value2);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

