/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ShowSettingsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ShowSettingsAction.class);

    public ShowSettingsAction() {
        super(CommonBundle.settingsAction(), CommonBundle.settingsActionDescription(), AllIcons.General.Settings);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSettingsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(!ActionPlaces.isMacSystemMenuAction(e));
        if (SystemInfo.isMac && ActionPlaces.isMainMenuOrActionSearch(e.getPlace())) {
            e.getPresentation().setVisible(false);
        }
        if (e.getPlace().equals("WelcomeScreen")) {
            e.getPresentation().setText(CommonBundle.settingsTitle());
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowSettingsAction.$$$reportNull$$$0(1);
        }
        ShowSettingsAction.perform((project2 = e.getProject()) != null ? project2 : ProjectManager.getInstance().getDefaultProject());
    }

    public static void perform(@NotNull Project project2) {
        if (project2 == null) {
            ShowSettingsAction.$$$reportNull$$$0(2);
        }
        if (LOG.isDebugEnabled()) {
            long startTime = System.nanoTime();
            SwingUtilities.invokeLater(() -> {
                long endTime = System.nanoTime();
                LOG.debug("Displaying settings dialog took " + (endTime - startTime) / 1000000L + " ms");
            });
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ShowSettingsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

