/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance(ShowSettingsUtilImpl.class);

    @NotNull
    private static Project getProject(@Nullable Project project2) {
        Project project3 = project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject();
        if (project3 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(0);
        }
        return project3;
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project2, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable toSelect2) {
        if (groups == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(1);
        }
        DialogWrapper dialogWrapper2 = SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project2), ShowSettingsUtilImpl.filterEmptyGroups(groups), toSelect2, null);
        if (dialogWrapper2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(2);
        }
        return dialogWrapper2;
    }

    public static ConfigurableGroup @NotNull [] getConfigurableGroups(@Nullable Project project2, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project2, withIdeSettings);
        ConfigurableGroup[] configurableGroupArray = new ConfigurableGroup[]{group};
        if (configurableGroupArray == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(3);
        }
        return configurableGroupArray;
    }

    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project2, withIdeSettings);
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        ShowSettingsUtilImpl.collect(list2, group.getConfigurables());
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void collect(List<? super Configurable> list2, Configurable ... configurables) {
        for (Configurable configurable2 : configurables) {
            list2.add(configurable2);
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)((Object)configurable2);
            ShowSettingsUtilImpl.collect(list2, composite.getConfigurables());
        }
    }

    @Override
    public void showSettingsDialog(@NotNull Project project2, ConfigurableGroup ... groups) {
        if (project2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(5);
        }
        if (groups == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(6);
        }
        try {
            ShowSettingsUtilImpl.getDialog(project2, Arrays.asList(groups), null).show();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    public <T extends Configurable> void showSettingsDialog(@Nullable Project project2, @NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(7);
        }
        this.showSettingsDialog(project2, configurableClass, null);
    }

    @Override
    public <T extends Configurable> void showSettingsDialog(@Nullable Project project2, @NotNull Class<T> configurableClass, @Nullable Consumer<? super T> additionalConfiguration) {
        if (configurableClass == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(8);
        }
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        this.showSettingsDialog(project2, (? super Configurable it) -> ConfigurableWrapper.cast(configurableClass, it) != null, (? super Configurable it) -> {
            if (additionalConfiguration != null) {
                Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, it);
                assert (toConfigure != null) : "Wrong configurable found: " + it.getClass();
                additionalConfiguration.accept(toConfigure);
            }
        });
    }

    @Override
    public void showSettingsDialog(@Nullable Project project2, final @NotNull Predicate<? super Configurable> predicate, @Nullable Consumer<? super Configurable> additionalConfiguration) {
        if (predicate == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(9);
        }
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Configurable config2 = new ConfigurableVisitor(){

            @Override
            protected boolean accept(@NotNull Configurable configurable2) {
                if (configurable2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return predicate.test(configurable2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl$1", "accept"));
            }
        }.find(groups);
        assert (config2 != null) : "Cannot find configurable for specified predicate";
        if (additionalConfiguration != null) {
            additionalConfiguration.accept(config2);
        }
        ShowSettingsUtilImpl.getDialog(project2, Arrays.asList(groups), config2).show();
    }

    @Override
    public void showSettingsDialog(@Nullable Project project2, @NotNull String nameToSelect) {
        ConfigurableGroup group;
        if (nameToSelect == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(10);
        }
        List<Object> groups = (group = ConfigurableExtensionPointUtil.getConfigurableGroup(project2, true)).getConfigurables().length == 0 ? Collections.emptyList() : Collections.singletonList(group);
        ShowSettingsUtilImpl.getDialog(project2, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(@NotNull String preselectedConfigurableDisplayName, @NotNull List<? extends ConfigurableGroup> groups) {
        if (preselectedConfigurableDisplayName == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(11);
        }
        if (groups == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(12);
        }
        for (ConfigurableGroup configurableGroup : groups) {
            for (Configurable configurable2 : SearchUtil.expandGroup(configurableGroup)) {
                if (!preselectedConfigurableDisplayName.equals(configurable2.getDisplayName())) continue;
                return configurable2;
            }
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project2, @Nullable String idToSelect, String filter2) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project2, true);
        if (group.getConfigurables().length == 0) {
            group = null;
        }
        Configurable configurableToSelect = idToSelect == null ? null : ConfigurableVisitor.findById(idToSelect, Collections.singletonList(group));
        SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project2), Collections.singletonList(group), configurableToSelect, filter2).show();
    }

    @Override
    public void showSettingsDialog(@NotNull Project project2, @Nullable Configurable toSelect2) {
        if (project2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(13);
        }
        List<ConfigurableGroup> groups = Collections.singletonList(ConfigurableExtensionPointUtil.getConfigurableGroup(project2, true));
        ShowSettingsUtilImpl.getDialog(project2, groups, toSelect2).show();
    }

    @NotNull
    private static List<ConfigurableGroup> filterEmptyGroups(@NotNull List<? extends ConfigurableGroup> group) {
        if (group == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(14);
        }
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup configurableGroup : group) {
            if (configurableGroup.getConfigurables().length <= 0) continue;
            groups.add(configurableGroup);
        }
        ArrayList<ConfigurableGroup> arrayList = groups;
        if (arrayList == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    public boolean editConfigurable(Project project2, @NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(16);
        }
        return this.editConfigurable(project2, ShowSettingsUtilImpl.createDimensionKey(configurable2), configurable2);
    }

    @Override
    public boolean editConfigurable(Project project2, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2) {
        if (dimensionServiceKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(17);
        }
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(18);
        }
        return this.editConfigurable(project2, dimensionServiceKey, configurable2, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(19);
        }
        return configurable2 instanceof Place.Navigator || configurable2 instanceof Composite || configurable2 instanceof TabbedConfigurable;
    }

    @Override
    public boolean editConfigurable(Project project2, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2, boolean showApplyButton) {
        if (dimensionServiceKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(20);
        }
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(21);
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable2, dimensionServiceKey, null, showApplyButton);
    }

    @Override
    public boolean editConfigurable(Project project2, @NotNull Configurable configurable2, Runnable advancedInitialization) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(22);
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    @Override
    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(23);
        }
        return this.editConfigurable(parent, configurable2, null);
    }

    @Override
    public boolean editConfigurable(@Nullable Component parent, @NotNull String displayName) {
        if (displayName == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(24);
        }
        return this.editConfigurable(parent, displayName, (Runnable)null);
    }

    @Override
    public boolean editConfigurable(@Nullable Component parent, @NotNull String displayName, @Nullable Runnable advancedInitialization) {
        ConfigurableGroup group;
        List<Object> groups;
        Configurable configurable2;
        if (displayName == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(25);
        }
        if ((configurable2 = ShowSettingsUtilImpl.findPreselectedByDisplayName(displayName, groups = (group = ConfigurableExtensionPointUtil.getConfigurableGroup(null, true)).getConfigurables().length == 0 ? Collections.emptyList() : Collections.singletonList(group))) == null) {
            LOG.error("Cannot find configurable for name [" + displayName + "]");
            return false;
        }
        return this.editConfigurable(parent, configurable2, advancedInitialization);
    }

    @Override
    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable2, @Nullable Runnable advancedInitialization) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(26);
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project2, @NotNull Configurable configurable2, @NotNull String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(27);
        }
        if (dimensionKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(28);
        }
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project2, dimensionKey, configurable2, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable2, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once(editor.getContentPane(), new Activatable(){

                @Override
                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(29);
        }
        String string = '#' + configurable2.getDisplayName().replace('\n', '_').replace(' ', '_');
        if (string == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Override
    public boolean editConfigurable(Component parent, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2) {
        if (dimensionServiceKey == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(31);
        }
        if (configurable2 == null) {
            ShowSettingsUtilImpl.$$$reportNull$$$0(32);
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable2, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ShowSettingsUtilImpl";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToSelect";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectedConfigurableDisplayName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 17: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionServiceKey";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ShowSettingsUtilImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyGroups";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createDimensionKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsDialog";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPreselectedByDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyGroups";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "editConfigurable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isWorthToShowApplyButton";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDimensionKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

