/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ToggleReadOnlyAttributeAction
extends AnAction
implements DumbAware {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleReadOnlyAttributeAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(files2.length > 0);
        if (files2.length > 0) {
            int ro = 0;
            int rw = 0;
            int f = 0;
            int d = 0;
            for (VirtualFile file2 : files2) {
                if (file2.isWritable()) {
                    ++rw;
                } else {
                    ++ro;
                }
                if (file2.isDirectory()) {
                    ++d;
                    continue;
                }
                ++f;
            }
            int finalRo = ro;
            int finalRw = rw;
            int finalF = f;
            int finalD = d;
            if (ro > 0 && rw > 0) {
                e.getPresentation().setText(ActionsBundle.messagePointer("action.ToggleReadOnlyAttribute.text", new Object[0]));
            } else if (f > 0 && d == 0) {
                e.getPresentation().setText(ActionsBundle.messagePointer("action.ToggleReadOnlyAttribute.files", finalRo, finalRw, finalF, finalD));
            } else if (f == 0 && d > 0) {
                e.getPresentation().setText(ActionsBundle.messagePointer("action.ToggleReadOnlyAttribute.dirs", finalRo, finalRw, finalF, finalD));
            } else {
                e.getPresentation().setText(ActionsBundle.messagePointer("action.ToggleReadOnlyAttribute.mixed", finalRo, finalRw, finalF, finalD));
            }
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            ToggleReadOnlyAttributeAction.$$$reportNull$$$0(1);
        }
        if ((files2 = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext())).length > 0) {
            WriteAction.run(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                try {
                    for (VirtualFile file2 : files2) {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute(file2, file2.isWritable());
                    }
                }
                catch (IOException x) {
                    Notifications.Bus.notify(new Notification("System Messages", CommonBundle.getErrorTitle(), x.getMessage(), NotificationType.ERROR), e.getProject());
                }
            });
        }
    }

    private static VirtualFile[] getFiles(DataContext context) {
        VirtualFile[] files2 = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        return files2 == null ? VirtualFile.EMPTY_ARRAY : (VirtualFile[])Stream.of(files2).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/ToggleReadOnlyAttributeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

