/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Supplier<? extends Iterable<? extends JComponent>> myProducer;

    @NotNull
    public static DefaultActionGroup createToggleToolbarGroup(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(1);
        }
        return new DefaultActionGroup(new OptionsGroup(toolWindow), ToggleToolbarAction.createToolWindowAction(toolWindow, PropertiesComponent.getInstance(project2)));
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id2, @NotNull PropertiesComponent properties, @NotNull Supplier<? extends Iterable<? extends JComponent>> components) {
        if (id2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(3);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(4);
        }
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(id2), components);
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow, final @NotNull PropertiesComponent properties) {
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(6);
        }
        toolWindow.addContentManagerListener(new ContentManagerListener(){

            @Override
            public void contentAdded(@NotNull ContentManagerEvent event) {
                ContentManager contentManager2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                JComponent component2 = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible(Collections.singletonList(component2), ToggleToolbarAction.isToolbarVisible(toolWindow, properties));
                ContentManager contentManager3 = contentManager2 = component2 instanceof DataProvider ? PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)((Object)component2)) : null;
                if (contentManager2 != null) {
                    contentManager2.addContentManagerListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/ToggleToolbarAction$1", "contentAdded"));
            }
        });
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow), () -> Collections.singletonList(toolWindow.getContentManager().getComponent()));
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties, @Nullable Boolean visible) {
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(8);
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow), properties, Collections.singletonList(toolWindow.getComponent()), state);
    }

    public static void setToolbarVisible(@NotNull String id2, @NotNull PropertiesComponent properties, @NotNull Iterable<? extends JComponent> components, @Nullable Boolean visible) {
        if (id2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(9);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(10);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(11);
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(id2, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id2), properties, components, state);
    }

    public static void setToolbarVisible(@NotNull Iterable<? extends JComponent> roots, boolean state) {
        if (roots == null) {
            ToggleToolbarAction.$$$reportNull$$$0(12);
        }
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(roots)) {
            JComponent c = toolbar.getComponent();
            c.setVisible(state);
            Container parent = c.getParent();
            if (!(parent instanceof EditorHeaderComponent)) continue;
            parent.setVisible(state);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull PropertiesComponent properties) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(14);
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(property));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties) {
        if (toolWindow == null) {
            ToggleToolbarAction.$$$reportNull$$$0(15);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(16);
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property, @NotNull Supplier<? extends Iterable<? extends JComponent>> producer) {
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(17);
        }
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(18);
        }
        if (producer == null) {
            ToggleToolbarAction.$$$reportNull$$$0(19);
        }
        super(ActionsBundle.messagePointer("action.ShowToolbar.text", new Object[0]));
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property;
        this.myProducer = producer;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(20);
        }
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars(this.myProducer.get()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(21);
        }
        return this.isSelected();
    }

    @Override
    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(22);
        }
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, this.myProducer.get(), state);
    }

    static void setToolbarVisibleImpl(@NotNull String property, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<? extends JComponent> components, boolean visible) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(23);
        }
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(24);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(25);
        }
        propertiesComponent.setValue(property, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties, @NotNull String property) {
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(26);
        }
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(27);
        }
        return properties.getBoolean(property, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        if (window == null) {
            ToggleToolbarAction.$$$reportNull$$$0(28);
        }
        return ToggleToolbarAction.getShowToolbarProperty("ToolWindow" + window.getStripeTitle());
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull String s) {
        if (s == null) {
            ToggleToolbarAction.$$$reportNull$$$0(29);
        }
        String string = s + ".ShowToolbar";
        if (string == null) {
            ToggleToolbarAction.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<? extends JComponent> roots) {
        JBIterable<ActionToolbar> jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots)).preOrderDfsTraversal().filter(ActionToolbar.class);
        if (jBIterable == null) {
            ToggleToolbarAction.$$$reportNull$$$0(31);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowToolbarProperty";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateToolbars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToggleToolbarGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisible";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isToolbarVisible";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisibleImpl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedImpl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getShowToolbarProperty";
                break;
            }
            case 30: 
            case 31: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OptionsGroup
    extends ActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        OptionsGroup(ToolWindow toolWindow) {
            super(IdeBundle.message("group.view.options", new Object[0]), true);
            this.myToolWindow = toolWindow;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OptionsGroup.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(!ActionGroupUtil.isGroupEmpty(this, e, LaterInvocator.isInModalContext()));
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            JComponent contentComponent;
            ContentManager contentManager2 = this.myToolWindow.getContentManager();
            Content selectedContent = contentManager2.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent != null ? selectedContent.getComponent() : null;
            if (contentComponent == null || e == null) {
                if (EMPTY_ARRAY == null) {
                    OptionsGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            SmartList<AnAction> result2 = new SmartList<AnAction>();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(Collections.singletonList(contentComponent))) {
                JComponent c = toolbar.getComponent();
                if (c.isVisible() || !c.isValid()) continue;
                if (!result2.isEmpty() && !(ContainerUtil.getLastItem(result2) instanceof Separator)) {
                    result2.add(Separator.getInstance());
                }
                List<AnAction> actions = toolbar.getActions();
                for (AnAction action2 : actions) {
                    if (action2 instanceof ToggleAction && !result2.contains(action2) && ActionGroupUtil.isActionEnabledAndVisible(action2, e, LaterInvocator.isInModalContext())) {
                        result2.add(action2);
                        continue;
                    }
                    if (!(action2 instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem(result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean popup2 = ContainerUtil.count(result2, it -> !(it instanceof Separator)) > 3;
            this.setPopup(popup2);
            if (!popup2 && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                OptionsGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

