/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor
implements WeightedSearchEverywhereContributor<Object> {
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);
    private static final Key<Map<String, String>> SE_SELECTED_SCOPES = Key.create("SE_SELECTED_SCOPES");
    private static final Pattern ourPatternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    protected final Project myProject;
    protected boolean myEverywhere;
    protected ScopeDescriptor myScopeDescriptor;
    private final GlobalSearchScope myEverywhereScope;
    private final GlobalSearchScope myProjectScope;
    protected final PsiElement myPsiContext;
    protected final List<ScopeDescriptor> myScopeDescriptors;

    protected AbstractGotoSEContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(0);
        }
        this.myScopeDescriptors = new ArrayList<ScopeDescriptor>();
        this.myProject = event.getRequiredData(CommonDataKeys.PROJECT);
        this.myPsiContext = GotoActionBase.getPsiContext(event);
        this.myEverywhereScope = GlobalSearchScope.everythingScope(this.myProject);
        ScopeChooserCombo.processScopes(this.myProject, event.getDataContext(), 17, new CommonProcessors.CollectProcessor<ScopeDescriptor>(this.myScopeDescriptors));
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope(this.myProject);
        if (this.myEverywhereScope.equals(projectScope)) {
            ScopeDescriptor secondScope = JBIterable.from(this.myScopeDescriptors).filter(o -> !o.scopeEquals(this.myEverywhereScope) && !o.scopeEquals(null)).first();
            projectScope = secondScope != null ? (GlobalSearchScope)secondScope.getScope() : this.myEverywhereScope;
        }
        this.myProjectScope = projectScope;
        this.myScopeDescriptor = this.getInitialSelectedScope();
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return DumbService.isDumb(this.myProject) ? "Results might be incomplete. The project is being indexed." : null;
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return true;
    }

    @NotNull
    protected List<AnAction> doGetActions(@NotNull String everywhereText, @Nullable PersistentSearchEverywhereContributorFilter<?> filter2, final @NotNull Runnable onChanged) {
        if (everywhereText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(2);
        }
        if (onChanged == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(3);
        }
        if (this.myProject == null || filter2 == null) {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        if (Registry.is("search.everywhere.show.scopes")) {
            result2.add(new ScopeChooserAction(){
                final boolean canToggleEverywhere;
                {
                    this.canToggleEverywhere = !AbstractGotoSEContributor.this.myEverywhereScope.equals(AbstractGotoSEContributor.this.myProjectScope);
                }

                @Override
                void onScopeSelected(@NotNull ScopeDescriptor o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AbstractGotoSEContributor.this.setSelectedScope(o);
                    onChanged.run();
                }

                @Override
                @NotNull
                ScopeDescriptor getSelectedScope() {
                    ScopeDescriptor scopeDescriptor = AbstractGotoSEContributor.this.myScopeDescriptor;
                    if (scopeDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return scopeDescriptor;
                }

                @Override
                void onProjectScopeToggled() {
                    this.setEverywhere(!AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myEverywhereScope));
                }

                @Override
                boolean processScopes(@NotNull Processor<? super ScopeDescriptor> processor2) {
                    if (processor2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return ContainerUtil.process(AbstractGotoSEContributor.this.myScopeDescriptors, processor2);
                }

                @Override
                public boolean isEverywhere() {
                    return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myEverywhereScope);
                }

                @Override
                public void setEverywhere(boolean everywhere) {
                    AbstractGotoSEContributor.this.setSelectedScope(new ScopeDescriptor(everywhere ? AbstractGotoSEContributor.this.myEverywhereScope : AbstractGotoSEContributor.this.myProjectScope));
                    onChanged.run();
                }

                @Override
                public boolean canToggleEverywhere() {
                    if (!this.canToggleEverywhere) {
                        return false;
                    }
                    return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myEverywhereScope) || AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myProjectScope);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "o";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "processor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSelectedScope";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "onScopeSelected";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "processScopes";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        } else {
            result2.add(new CheckBoxSearchEverywhereToggleAction(everywhereText){

                @Override
                public boolean isEverywhere() {
                    return AbstractGotoSEContributor.this.myEverywhere;
                }

                @Override
                public void setEverywhere(boolean state) {
                    AbstractGotoSEContributor.this.myEverywhere = state;
                    onChanged.run();
                }
            });
        }
        result2.add(new SearchEverywhereUI.FiltersAction(filter2, onChanged));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private ScopeDescriptor getInitialSelectedScope() {
        String selectedScope;
        String string = selectedScope = this.myProject == null ? null : AbstractGotoSEContributor.getSelectedScopes(this.myProject).get(this.getClass().getSimpleName());
        if (Registry.is("search.everywhere.show.scopes") && Registry.is("search.everywhere.sticky.scopes") && StringUtil.isNotEmpty(selectedScope)) {
            for (ScopeDescriptor descriptor2 : this.myScopeDescriptors) {
                if (!selectedScope.equals(descriptor2.getDisplayName()) || descriptor2.scopeEquals(null)) continue;
                ScopeDescriptor scopeDescriptor = descriptor2;
                if (scopeDescriptor == null) {
                    AbstractGotoSEContributor.$$$reportNull$$$0(6);
                }
                return scopeDescriptor;
            }
        }
        return new ScopeDescriptor(this.myProjectScope);
    }

    private void setSelectedScope(@NotNull ScopeDescriptor o) {
        if (o == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(7);
        }
        this.myScopeDescriptor = o;
        AbstractGotoSEContributor.getSelectedScopes(this.myProject).put(this.getClass().getSimpleName(), o.scopeEquals(this.myEverywhereScope) || o.scopeEquals(this.myProjectScope) ? null : o.getDisplayName());
    }

    @NotNull
    private static Map<String, String> getSelectedScopes(@NotNull Project project2) {
        Map<String, String> map2;
        if (project2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(8);
        }
        if ((map2 = SE_SELECTED_SCOPES.get(project2)) == null) {
            map2 = new HashMap<String, String>(3);
            SE_SELECTED_SCOPES.set(project2, map2);
        }
        Map<String, String> map3 = map2;
        if (map3 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(9);
        }
        return map3;
    }

    @Override
    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(10);
        }
        if (progressIndicator2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(12);
        }
        if (this.myProject == null) {
            return;
        }
        if (!this.isEmptyPatternSupported() && pattern.isEmpty()) {
            return;
        }
        Runnable fetchRunnable = () -> {
            if (!this.isDumbAware() && DumbService.isDumb(this.myProject)) {
                return;
            }
            FilteringGotoByModel<?> model = this.createModel(this.myProject);
            if (progressIndicator2.isCanceled()) {
                return;
            }
            PsiElement context = this.myPsiContext != null && this.myPsiContext.isValid() ? this.myPsiContext : null;
            ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(this.myProject, model, context);
            try {
                boolean everywhere;
                ChooseByNameItemProvider provider = popup2.getProvider();
                GlobalSearchScope scope = Registry.is("search.everywhere.show.scopes") ? (GlobalSearchScope)Objects.requireNonNull(this.myScopeDescriptor.getScope()) : null;
                boolean bl = everywhere = scope == null ? this.myEverywhere : scope.isSearchInLibraries();
                if (scope != null && provider instanceof ChooseByNameInScopeItemProvider) {
                    FindSymbolParameters parameters = FindSymbolParameters.wrap(pattern, scope);
                    ((ChooseByNameInScopeItemProvider)provider).filterElementsWithWeights(popup2, parameters, progressIndicator2, item -> this.processElement(progressIndicator2, consumer, model, item.getItem(), item.getWeight()));
                } else if (provider instanceof ChooseByNameWeightedItemProvider) {
                    ((ChooseByNameWeightedItemProvider)provider).filterElementsWithWeights(popup2, pattern, everywhere, progressIndicator2, item -> this.processElement(progressIndicator2, consumer, model, item.getItem(), item.getWeight()));
                } else {
                    provider.filterElements(popup2, pattern, everywhere, progressIndicator2, element2 -> this.processElement(progressIndicator2, consumer, model, element2, this.getElementPriority(element2, pattern)));
                }
            }
            finally {
                Disposer.dispose(popup2);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() && application.isDispatchThread()) {
            fetchRunnable.run();
        } else {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(fetchRunnable, progressIndicator2);
        }
    }

    private boolean processElement(@NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer, FilteringGotoByModel<?> model, Object element2, int degree) {
        if (progressIndicator2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(14);
        }
        if (progressIndicator2.isCanceled()) {
            return false;
        }
        if (element2 == null) {
            LOG.error("Null returned from " + model + " in " + this);
            return true;
        }
        return consumer.process(new FoundItemDescriptor<Object>(element2, degree));
    }

    @NotNull
    protected abstract FilteringGotoByModel<?> createModel(@NotNull Project var1);

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(15);
        }
        if (StringUtil.containsAnyChar(pattern, ":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            String string = AbstractGotoSEContributor.applyPatternFilter(pattern, ourPatternToDetectLinesAndColumns);
            if (string == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(17);
        }
        return string;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    @Override
    public boolean showInFindResults() {
        return true;
    }

    @Override
    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
        if (selected2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(18);
        }
        if (searchText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(19);
        }
        if (selected2 instanceof PsiElement) {
            if (!((PsiElement)selected2).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            PsiElement psiElement = this.preparePsi((PsiElement)selected2, modifiers, searchText);
            Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
            if (extNavigatable != null && extNavigatable.canNavigate()) {
                extNavigatable.navigate(true);
                return true;
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        } else {
            EditSourceUtil.navigate((NavigationItem)selected2, true, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return true;
    }

    @Override
    public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
        if (element2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(20);
        }
        if (dataId == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(21);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (element2 instanceof PsiElement) {
                return element2;
            }
            if (element2 instanceof DataProvider) {
                return ((DataProvider)element2).getData(dataId);
            }
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element2 instanceof PsiElement) {
            return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element2);
        }
        return null;
    }

    @Override
    public boolean isMultiSelectionSupported() {
        return true;
    }

    @Override
    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.createModel(this.myProject));
    }

    @Override
    @NotNull
    public ListCellRenderer<Object> getElementsRenderer() {
        return new SERenderer();
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(22);
        }
        if (searchPattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(23);
        }
        return 50;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile(psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(psi.getProject(), file2, (Integer)position.first, (Integer)position.second);
            return descriptor2.setUseCurrentWindow(AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text2) {
        int line = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 2);
        int column = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 3);
        if (line == -1 && column != -1) {
            line = 0;
        }
        return new Pair<Integer, Integer>(line, column);
    }

    private static int getLineAndColumnRegexpGroup(String text2, int groupNumber) {
        Matcher matcher = ourPatternToDetectLinesAndColumns.matcher(text2);
        if (matcher.matches()) {
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected static boolean openInCurrentWindow(int modifiers) {
        return (modifiers & 1) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "everywhereText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSelectedScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScopes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedScopes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fetchWeightedElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class ScopeChooserAction
    extends ActionGroup
    implements CustomComponentAction,
    DumbAware,
    SearchEverywhereToggleAction {
        static final char CHOOSE = 'O';
        static final char TOGGLE = 'P';
        static final String TOGGLE_ACTION_NAME = "toggleProjectScope";

        ScopeChooserAction() {
        }

        abstract void onScopeSelected(@NotNull ScopeDescriptor var1);

        @NotNull
        abstract ScopeDescriptor getSelectedScope();

        abstract void onProjectScopeToggled();

        abstract boolean processScopes(@NotNull Processor<? super ScopeDescriptor> var1);

        @Override
        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                ScopeChooserAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public boolean isPopup() {
            return true;
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (EMPTY_ARRAY == null) {
                ScopeChooserAction.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                ScopeChooserAction.$$$reportNull$$$0(2);
            }
            if (place == null) {
                ScopeChooserAction.$$$reportNull$$$0(3);
            }
            final ActionButtonWithText component2 = new ActionButtonWithText(this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            ComponentUtil.putClientProperty(component2, MnemonicHelper.MNEMONIC_CHECKER, keyCode -> KeyEvent.getExtendedKeyCodeForChar(80) == keyCode || KeyEvent.getExtendedKeyCodeForChar(79) == keyCode);
            MnemonicHelper.registerMnemonicAction(component2, 79);
            InputMap map2 = component2.getInputMap(2);
            int mask = MnemonicHelper.getFocusAcceleratorKeyMask();
            map2.put(KeyStroke.getKeyStroke(80, mask, false), TOGGLE_ACTION_NAME);
            component2.getActionMap().put(TOGGLE_ACTION_NAME, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataContext dataContext = DataManager.getInstance().getDataContext(component2);
                    KeyEvent inputEvent = new KeyEvent(component2, 401, e.getWhen(), MnemonicHelper.getFocusAcceleratorKeyMask(), KeyEvent.getExtendedKeyCodeForChar(80), 'P');
                    AnActionEvent event = AnActionEvent.createFromAnAction(this, inputEvent, "toolbar", dataContext);
                    ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                    actionManager.fireBeforeActionPerformed(this, dataContext, event);
                    this.onProjectScopeToggled();
                    actionManager.fireAfterActionPerformed(this, dataContext, event);
                }
            });
            ActionButtonWithText actionButtonWithText = component2;
            if (actionButtonWithText == null) {
                ScopeChooserAction.$$$reportNull$$$0(4);
            }
            return actionButtonWithText;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScopeChooserAction.$$$reportNull$$$0(5);
            }
            ScopeDescriptor selection = this.getSelectedScope();
            String name = StringUtil.trimMiddle(selection.getDisplayName(), 30);
            String text2 = StringUtil.escapeMnemonics(name).replaceFirst("(?i)([PO])", "_$1");
            e.getPresentation().setText(text2);
            e.getPresentation().setIcon(OffsetIcon.getOriginalIcon((Icon)selection.getIcon()));
            String shortcutText = KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(79, MnemonicHelper.getFocusAcceleratorKeyMask(), true));
            String shortcutText2 = KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(80, MnemonicHelper.getFocusAcceleratorKeyMask(), true));
            e.getPresentation().setDescription("Choose scope (" + shortcutText + ")<p/>Toggle scope (" + shortcutText2 + ")");
            JComponent button2 = e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
            if (button2 != null) {
                button2.setBackground(selection.getColor());
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            JComponent button2;
            if (e == null) {
                ScopeChooserAction.$$$reportNull$$$0(6);
            }
            if ((button2 = e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY)) == null || !button2.isValid()) {
                return;
            }
            ListCellRenderer<ScopeDescriptor> renderer = new ListCellRenderer<ScopeDescriptor>(){
                final ListCellRenderer<ScopeDescriptor> delegate = ScopeChooserCombo.createDefaultRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value2, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component2 = this.delegate.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                    if (component2 instanceof JComponent && !(component2 instanceof JSeparator) && !(component2 instanceof TitledSeparator)) {
                        ((JComponent)component2).setBorder(JBUI.Borders.empty(2, 8));
                    }
                    return component2;
                }
            };
            ArrayList items = new ArrayList();
            JBList fakeList = new JBList();
            this.processScopes(o -> {
                Component c = renderer.getListCellRendererComponent(fakeList, (ScopeDescriptor)o, -1, false, false);
                if (c instanceof JSeparator || c instanceof TitledSeparator || !o.scopeEquals(null) && o.getScope() instanceof GlobalSearchScope) {
                    items.add(o);
                }
                return true;
            });
            BaseListPopupStep<ScopeDescriptor> step = new BaseListPopupStep<ScopeDescriptor>("", items){

                @Override
                @Nullable
                public PopupStep onChosen(ScopeDescriptor selectedValue, boolean finalChoice) {
                    this.onScopeSelected(selectedValue);
                    ActionToolbar toolbar = UIUtil.uiParents(button2, true).filter(ActionToolbar.class).first();
                    if (toolbar != null) {
                        toolbar.updateActionsImmediately();
                    }
                    return FINAL_CHOICE;
                }

                @Override
                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @Override
                @NotNull
                public String getTextFor(ScopeDescriptor value2) {
                    return value2.getScope() instanceof GlobalSearchScope ? value2.getDisplayName() : "";
                }

                @Override
                public boolean isSelectable(ScopeDescriptor value2) {
                    return value2.getScope() instanceof GlobalSearchScope;
                }
            };
            ScopeDescriptor selection = this.getSelectedScope();
            step.setDefaultOptionIndex(ContainerUtil.indexOf(items, o -> Comparing.equal(o.getDisplayName(), selection.getDisplayName())));
            ListPopupImpl popup2 = new ListPopupImpl(e.getProject(), step);
            popup2.setMaxRowCount(10);
            popup2.getList().setCellRenderer(renderer);
            popup2.showUnderneathOf(button2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class SERenderer
    extends SearchEverywherePsiRenderer {
        protected SERenderer() {
        }

        @Override
        public String getElementText(PsiElement element2) {
            if (element2 instanceof NavigationItem) {
                return Optional.ofNullable(((NavigationItem)((Object)element2)).getPresentation()).map(presentation -> presentation.getPresentableText()).orElse(super.getElementText(element2));
            }
            return super.getElementText(element2);
        }
    }
}

