/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.GotoClassAction;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private static final Pattern ourPatternToDetectAnonymousClasses = Pattern.compile("([.\\w]+)((\\$[\\d]+)*(\\$)?)");
    private static final Pattern ourPatternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    private final PersistentSearchEverywhereContributorFilter<Language> myFilter;

    public ClassSearchEverywhereContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        super(event);
        this.myFilter = ClassSearchEverywhereContributor.createLanguageFilter(event.getRequiredData(CommonDataKeys.PROJECT));
    }

    @Override
    @NotNull
    public String getGroupName() {
        String string = GotoClassPresentationUpdater.getTabTitlePluralized();
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullGroupName() {
        String string = String.join((CharSequence)"/", GotoClassPresentationUpdater.getActionTitlePluralized());
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String includeNonProjectItemsText() {
        String string = IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public int getSortWeight() {
        return 100;
    }

    @NotNull
    protected FilteringGotoByModel<Language> createModel(@NotNull Project project2) {
        if (project2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        GotoClassModel2 model = new GotoClassModel2(project2);
        if (this.myFilter != null) {
            model.setFilterItems(this.myFilter.getSelectedElements());
        }
        GotoClassModel2 gotoClassModel2 = model;
        if (gotoClassModel2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        return gotoClassModel2;
    }

    @Override
    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        if (onChanged == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        List<AnAction> list2 = this.doGetActions(this.includeNonProjectItemsText(), this.myFilter, onChanged);
        if (list2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        if (pattern.indexOf(35) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectMembers);
        }
        if (pattern.indexOf(36) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectAnonymousClasses);
        }
        String string = super.filterControlSymbols(pattern);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        if (searchPattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        return super.getElementPriority(element2, searchPattern) + 5;
    }

    @Override
    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        String path2 = ClassSearchEverywhereContributor.pathToAnonymousClass(searchText);
        if (path2 != null) {
            psiElement = GotoClassAction.getElement(psiElement, path2);
        }
        return super.preparePsi(psiElement, modifiers, searchText);
    }

    @Override
    @Nullable
    protected Navigatable createExtendedNavigatable(final PsiElement psi, String searchText, final int modifiers) {
        Navigatable delegate;
        Navigatable res2 = super.createExtendedNavigatable(psi, searchText, modifiers);
        if (res2 != null) {
            return res2;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile(psi);
        String memberName = ClassSearchEverywhereContributor.getMemberName(searchText);
        if (file2 != null && memberName != null && (delegate = GotoClassAction.findMember(memberName, searchText, psi, file2)) != null) {
            return new Navigatable(){

                @Override
                public void navigate(boolean requestFocus) {
                    NavigationUtil.activateFileWithPsiElement(psi, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
                    delegate.navigate(true);
                }

                @Override
                public boolean canNavigate() {
                    return delegate.canNavigate();
                }

                @Override
                public boolean canNavigateToSource() {
                    return delegate.canNavigateToSource();
                }
            };
        }
        return null;
    }

    private static String pathToAnonymousClass(String searchedText) {
        return ClassSearchEverywhereContributor.pathToAnonymousClass(ourPatternToDetectAnonymousClasses.matcher(searchedText));
    }

    @Nullable
    public static String pathToAnonymousClass(Matcher matcher) {
        String path2;
        if (matcher.matches() && (path2 = matcher.group(2)) != null) {
            if ((path2 = path2.trim()).endsWith("$") && path2.length() >= 2) {
                path2 = path2.substring(0, path2.length() - 2);
            }
            if (!path2.isEmpty()) {
                return path2;
            }
        }
        return null;
    }

    private static String getMemberName(String searchedText) {
        int index = searchedText.lastIndexOf(35);
        if (index == -1) {
            return null;
        }
        String name = searchedText.substring(index + 1).trim();
        return StringUtil.isEmpty(name) ? null : name;
    }

    @NotNull
    static PersistentSearchEverywhereContributorFilter<Language> createLanguageFilter(@NotNull Project project2) {
        if (project2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        List items = Language.getRegisteredLanguages().stream().filter(lang2 -> lang2 != Language.ANY && !(lang2 instanceof DependentLanguage)).sorted(LanguageUtil.LANGUAGE_COMPARATOR).collect(Collectors.toList());
        GotoClassSymbolConfiguration persistentConfig = GotoClassSymbolConfiguration.getInstance(project2);
        return new PersistentSearchEverywhereContributorFilter<Language>(items, persistentConfig, Language::getDisplayName, language2 -> {
            LanguageFileType fileType = language2.getAssociatedFileType();
            return fileType != null ? fileType.getIcon() : null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullGroupName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "includeNonProjectItemsText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @Override
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new ClassSearchEverywhereContributor(initEvent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initEvent", "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

