/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.bigPopup.ShowFilterAction;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.MultiThreadSearcher;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SEListSelectionTracker;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.ThrottlingListenerWrapper;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchFieldStatisticsCollector;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.ide.util.gotoByName.SearchEverywhereConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereUI
extends BigPopupUI
implements DataProvider,
QuickSearchComponent {
    private static final Logger LOG = Logger.getInstance(SearchEverywhereUI.class);
    public static final String SEARCH_EVERYWHERE_SEARCH_FILED_KEY = "search-everywhere-textfield";
    public static final int SINGLE_CONTRIBUTOR_ELEMENTS_LIMIT = 30;
    public static final int MULTIPLE_CONTRIBUTORS_ELEMENTS_LIMIT = 15;
    public static final int THROTTLING_TIMEOUT = 100;
    private static final SimpleTextAttributes SMALL_LABEL_ATTRS = new SimpleTextAttributes(128, JBUI.CurrentTheme.BigPopup.listTitleLabelForeground());
    private final List<? extends SearchEverywhereContributor<?>> myShownContributors;
    private SearchListModel myListModel;
    private SETab mySelectedTab;
    private final List<SETab> myTabs;
    private final Function<String, String> myShortcutSupplier;
    private boolean myEverywhereAutoSet;
    private String myNotFoundString;
    private JBPopup myHint;
    private final SESearcher mySearcher;
    private final ThrottlingListenerWrapper myBufferedListener;
    private ProgressIndicator mySearchProgressIndicator;
    private final SEListSelectionTracker mySelectionTracker;
    private final PersistentSearchEverywhereContributorFilter<String> myContributorsFilter;
    private ActionToolbar myToolbar;
    private final MyAdvertisement myAdvertisement;
    private final ListCellRenderer<Object> myCommandRenderer;
    private final ListCellRenderer<Object> myMoreRenderer;
    private final GroupTitleRenderer myGroupTitleRenderer;
    private final SearchListener mySearchListener;
    private final SearchEverywhereContributor<Object> myStubCommandContributor;
    private final ExtendableTextComponent.Extension hintExtension;

    public SearchEverywhereUI(@NotNull Project project2, @NotNull List<? extends SearchEverywhereContributor<?>> contributors) {
        if (project2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(0);
        }
        if (contributors == null) {
            SearchEverywhereUI.$$$reportNull$$$0(1);
        }
        this(project2, contributors, s -> null);
    }

    public SearchEverywhereUI(@NotNull Project project2, @NotNull List<? extends SearchEverywhereContributor<?>> contributors, @NotNull Function<String, String> shortcutSupplier) {
        if (project2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(2);
        }
        if (contributors == null) {
            SearchEverywhereUI.$$$reportNull$$$0(3);
        }
        if (shortcutSupplier == null) {
            SearchEverywhereUI.$$$reportNull$$$0(4);
        }
        super(project2);
        this.myTabs = new ArrayList<SETab>();
        this.myEverywhereAutoSet = true;
        this.myAdvertisement = new MyAdvertisement();
        this.myCommandRenderer = new ColoredListCellRenderer<Object>(){

            @Override
            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                this.setPaintFocusBorder(false);
                this.setIcon(EmptyIcon.ICON_16);
                this.setFont(list2.getFont());
                SearchEverywhereCommandInfo command = (SearchEverywhereCommandInfo)value2;
                this.append(command.getCommandWithPrefix() + " ", new SimpleTextAttributes(0, list2.getForeground()));
                this.append(command.getDefinition(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                this.setBackground(UIUtil.getListBackground(selected2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$8", "customizeCellRenderer"));
            }
        };
        this.myMoreRenderer = new ColoredListCellRenderer<Object>(){

            @Override
            protected int getMinHeight() {
                return -1;
            }

            @Override
            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (value2 != SearchListModel.MORE_ELEMENT) {
                    throw new AssertionError(value2);
                }
                this.setFont(UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL)));
                this.append(IdeBundle.message("search.everywhere.points.more", new Object[0]), SMALL_LABEL_ATTRS);
                this.setIpad(JBInsets.create(1, 7));
                this.setMyBorder(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$9", "customizeCellRenderer"));
            }
        };
        this.myGroupTitleRenderer = new GroupTitleRenderer();
        this.mySearchListener = new SearchListener();
        this.myStubCommandContributor = new SearchEverywhereContributor<Object>(){

            @Override
            @NotNull
            public String getSearchProviderId() {
                return "CommandsContributor";
            }

            @Override
            @NotNull
            public String getGroupName() {
                String string = IdeBundle.message("searcheverywhere.commands.tab.name", new Object[0]);
                if (string == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public int getSortWeight() {
                return 10;
            }

            @Override
            public boolean showInFindResults() {
                return false;
            }

            @Override
            public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super Object> consumer) {
                if (pattern == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (progressIndicator2 == null) {
                    10.$$$reportNull$$$0(2);
                }
                if (consumer == null) {
                    10.$$$reportNull$$$0(3);
                }
            }

            @Override
            public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
                if (selected2 == null) {
                    10.$$$reportNull$$$0(4);
                }
                if (searchText == null) {
                    10.$$$reportNull$$$0(5);
                }
                SearchEverywhereUI.this.mySearchField.setText(((SearchEverywhereCommandInfo)selected2).getCommandWithPrefix() + " ");
                SearchEverywhereUI.this.featureTriggered("commandCompleted", null);
                return false;
            }

            @Override
            @NotNull
            public ListCellRenderer<? super Object> getElementsRenderer() {
                ListCellRenderer listCellRenderer2 = SearchEverywhereUI.this.myCommandRenderer;
                if (listCellRenderer2 == null) {
                    10.$$$reportNull$$$0(6);
                }
                return listCellRenderer2;
            }

            @Override
            @Nullable
            public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
                if (element2 == null) {
                    10.$$$reportNull$$$0(7);
                }
                if (dataId == null) {
                    10.$$$reportNull$$$0(8);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progressIndicator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selected";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchText";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGroupName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$10";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementsRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "fetchElements";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "processSelectedItem";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getDataForItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.hintExtension = new ExtendableTextComponent.Extension(){
            private final TextIcon icon;
            {
                String message = IdeBundle.message("searcheverywhere.textfield.hint", SearchTopHitProvider.getTopHitAccelerator());
                Color color = JBUI.CurrentTheme.BigPopup.searchFieldGrayForeground();
                this.icon = new TextIcon(message, color, null, 0);
                this.icon.setFont(RelativeFont.SMALL.derive(SearchEverywhereUI.this.getFont()));
            }

            @Override
            public Icon getIcon(boolean hovered) {
                return this.icon;
            }
        };
        List<SEResultsEqualityProvider> equalityProviders = SEResultsEqualityProvider.getProviders();
        this.myBufferedListener = new ThrottlingListenerWrapper(100, this.mySearchListener, Runnable::run);
        this.mySearcher = new MultiThreadSearcher(this.myBufferedListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders);
        this.myShownContributors = contributors;
        this.myShortcutSupplier = shortcutSupplier;
        Map namesMap = ContainerUtil.map2Map(contributors, c -> Pair.create(c.getSearchProviderId(), c.getFullGroupName()));
        this.myContributorsFilter = new PersistentSearchEverywhereContributorFilter<String>(ContainerUtil.map(contributors, c -> c.getSearchProviderId()), SearchEverywhereConfiguration.getInstance(project2), namesMap::get, c -> null);
        this.init();
        this.initSearchActions();
        this.myResultsList.setSelectionMode(2);
        this.myResultsList.addListSelectionListener(e -> {
            boolean multiSelection;
            int[] selectedIndices = this.myResultsList.getSelectedIndices();
            if (selectedIndices.length > 1 && !(multiSelection = Arrays.stream(selectedIndices).allMatch(i -> this.myListModel.getContributorForIndex(i).isMultiSelectionSupported()))) {
                int index = this.myResultsList.getLeadSelectionIndex();
                this.myResultsList.setSelectedIndex(index);
            }
        });
        this.mySelectionTracker = new SEListSelectionTracker(this.myResultsList, this.myListModel);
        this.myResultsList.addListSelectionListener(this.mySelectionTracker);
        Disposer.register(this, SearchFieldStatisticsCollector.createAndStart(this.mySearchField, this.myProject));
    }

    @NotNull
    protected CompositeCellRenderer createCellRenderer() {
        return new CompositeCellRenderer();
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        this.myListModel = new SearchListModel();
        this.addListDataListener(this.myListModel);
        return new JBList<Object>(this.myListModel);
    }

    public void toggleEverywhereFilter() {
        this.myEverywhereAutoSet = false;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(!this.mySelectedTab.everywhereAction.isEverywhere());
        this.myToolbar.updateActionsImmediately();
    }

    private void setEverywhereAuto(boolean everywhere) {
        this.myEverywhereAutoSet = true;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(everywhere);
        this.myToolbar.updateActionsImmediately();
    }

    private boolean isEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return true;
        }
        return this.mySelectedTab.everywhereAction.isEverywhere();
    }

    private boolean canToggleEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return false;
        }
        return this.mySelectedTab.everywhereAction.canToggleEverywhere();
    }

    public void switchToContributor(@NotNull String contributorID) {
        if (contributorID == null) {
            SearchEverywhereUI.$$$reportNull$$$0(5);
        }
        SETab selectedTab = this.myTabs.stream().filter(tab -> tab.getID().equals(contributorID)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Contributor %s is not supported", contributorID)));
        this.switchToTab(selectedTab);
    }

    private void switchToNextTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab nextTab = currentIndex == this.myTabs.size() - 1 ? this.myTabs.get(0) : this.myTabs.get(currentIndex + 1);
        this.switchToTab(nextTab);
    }

    private void switchToPrevTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab prevTab = currentIndex == 0 ? this.myTabs.get(this.myTabs.size() - 1) : this.myTabs.get(currentIndex - 1);
        this.switchToTab(prevTab);
    }

    private void switchToTab(SETab tab) {
        boolean prevTabIsAll = this.mySelectedTab != null && this.isAllTabSelected();
        this.mySelectedTab = tab;
        boolean nextTabIsAll = this.isAllTabSelected();
        if (this.myEverywhereAutoSet && this.isEverywhere() && this.canToggleEverywhere()) {
            this.setEverywhereAuto(false);
        }
        this.rebuildSearchFieldExtensions();
        if (prevTabIsAll != nextTabIsAll) {
            this.myResultsList.setCellRenderer(this.myResultsList.getCellRenderer());
        }
        if (this.myToolbar != null) {
            this.myToolbar.updateActionsImmediately();
        }
        this.repaint();
        this.rebuildList();
    }

    private void rebuildSearchFieldExtensions() {
        if (this.mySearchField != null) {
            Boolean commandsSupported = this.mySelectedTab.getContributor().map(contributor -> !contributor.getSupportedCommands().isEmpty()).orElse(true);
            if (commandsSupported.booleanValue()) {
                this.mySearchField.addExtension(this.hintExtension);
            } else {
                this.mySearchField.removeExtension(this.hintExtension);
            }
            this.mySearchField.removeExtension(this.myAdvertisement);
            if (!commandsSupported.booleanValue()) {
                this.mySelectedTab.getContributor().map(c -> c.getAdvertisement()).ifPresent(s -> this.mySearchField.addExtension(this.myAdvertisement.withText((String)s)));
            }
        }
    }

    public String getSelectedContributorID() {
        return this.mySelectedTab.getID();
    }

    @Nullable
    public Object getSelectionIdentity() {
        Object value2 = this.myResultsList.getSelectedValue();
        return value2 == null ? null : Integer.valueOf(Objects.hashCode(value2));
    }

    @Override
    public void dispose() {
        this.stopSearching();
        this.myListModel.clear();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SearchEverywhereUI.$$$reportNull$$$0(6);
        }
        IntStream indicesStream = Arrays.stream(this.myResultsList.getSelectedIndices()).filter(i -> !this.myListModel.isMoreElement(i));
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
            return this.getSearchPattern();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List elements2 = indicesStream.mapToObj(i -> {
                SearchEverywhereContributor<Object> contributor = this.myListModel.getContributorForIndex(i);
                Object item = this.myListModel.getElementAt(i);
                Object psi = contributor.getDataForItem(item, CommonDataKeys.PSI_ELEMENT.getName());
                return (PsiElement)psi;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return PsiUtilCore.toPsiElementArray(elements2);
        }
        return indicesStream.mapToObj(i -> {
            SearchEverywhereContributor<Object> contributor = this.myListModel.getContributorForIndex(i);
            Object item = this.myListModel.getElementAt(i);
            return contributor.getDataForItem(item, dataId);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void registerHint(@NotNull JBPopup h) {
        if (h == null) {
            SearchEverywhereUI.$$$reportNull$$$0(7);
        }
        if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
            this.myHint.cancel();
        }
        this.myHint = h;
    }

    @Override
    public void unregisterHint() {
        this.myHint = null;
    }

    private void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
    }

    private void updateHint(Object element2) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = this.myHint.getUserData(PopupUpdateProcessor.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element2);
        }
    }

    private boolean isAllTabSelected() {
        return "SearchEverywhereContributor.All".equals(this.getSelectedContributorID());
    }

    @Override
    @NotNull
    protected JPanel createSettingsPanel() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction(new ActionGroup(){

            @Override
            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                if (e == null || SearchEverywhereUI.this.mySelectedTab == null) {
                    if (EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }
                AnAction[] anActionArray = ((SearchEverywhereUI)SearchEverywhereUI.this).mySelectedTab.actions.toArray(EMPTY_ARRAY);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$1", "getChildren"));
            }
        });
        actionGroup.addAction(new ShowInFindToolWindowAction());
        this.myToolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", actionGroup, true);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.updateActionsImmediately();
        JComponent toolbarComponent = this.myToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder(JBUI.Borders.empty(2, 18, 2, 9));
        JPanel jPanel = (JPanel)toolbarComponent;
        if (jPanel == null) {
            SearchEverywhereUI.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected String getInitialHint() {
        String string = IdeBundle.message("searcheverywhere.history.shortcuts.hint", KeymapUtil.getKeystrokeText(SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText(SearchTextField.SHOW_HISTORY_KEYSTROKE));
        if (string == null) {
            SearchEverywhereUI.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getAccessibleName() {
        String string = IdeBundle.message("searcheverywhere.accessible.name", new Object[0]);
        if (string == null) {
            SearchEverywhereUI.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        BigPopupUI.SearchField res2 = new BigPopupUI.SearchField(){

            @Override
            @NotNull
            protected ExtendableTextComponent.Extension getLeftExtension() {
                return new ExtendableTextComponent.Extension(){

                    @Override
                    public Icon getIcon(boolean hovered) {
                        return AllIcons.Actions.Search;
                    }

                    @Override
                    public boolean isIconBeforeText() {
                        return true;
                    }

                    @Override
                    public int getIconGap() {
                        return JBUIScale.scale(10);
                    }
                };
            }
        };
        res2.putClientProperty(SEARCH_EVERYWHERE_SEARCH_FILED_KEY, true);
        BigPopupUI.SearchField searchField = res2;
        if (searchField == null) {
            SearchEverywhereUI.$$$reportNull$$$0(11);
        }
        return searchField;
    }

    @Override
    protected void installScrollingActions() {
        ScrollingUtil.installMoveUpAction(this.myResultsList, this.getSearchField());
        ScrollingUtil.installMoveDownAction(this.myResultsList, this.getSearchField());
    }

    @Override
    @NotNull
    protected JPanel createTopLeftPanel() {
        JPanel contributorsPanel = new JPanel(new FlowLayout(0, 0, 0));
        contributorsPanel.setOpaque(false);
        SETab allTab = new SETab(null);
        contributorsPanel.add(allTab);
        this.myTabs.add(allTab);
        this.myShownContributors.stream().filter(SearchEverywhereContributor::isShownInSeparateTab).forEach(contributor -> {
            SETab tab = new SETab((SearchEverywhereContributor<?>)contributor);
            contributorsPanel.add(tab);
            this.myTabs.add(tab);
        });
        JPanel jPanel = contributorsPanel;
        if (jPanel == null) {
            SearchEverywhereUI.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    private void rebuildList() {
        String typedCommand;
        List<SearchEverywhereCommandInfo> commands;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopSearching();
        this.myResultsList.setEmptyText(IdeBundle.message("label.choosebyname.searching", new Object[0]));
        String rawPattern = this.getSearchPattern();
        this.updateViewType(rawPattern.isEmpty() ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
        String namePattern = this.mySelectedTab.getContributor().map(contributor -> contributor.filterControlSymbols(rawPattern)).orElse(rawPattern);
        MinusculeMatcher matcher = NameUtil.buildMatcherWithFallback("*" + rawPattern, "*" + namePattern, NameUtil.MatchingCaseSensitivity.NONE);
        MatcherHolder.associateMatcher(this.myResultsList, matcher);
        HashMap<SearchEverywhereContributor, Integer> contributorsMap = new HashMap<SearchEverywhereContributor, Integer>();
        Optional<SearchEverywhereContributor<?>> selectedContributor = this.mySelectedTab.getContributor();
        if (selectedContributor.isPresent()) {
            contributorsMap.put(selectedContributor.get(), 30);
        } else {
            contributorsMap.putAll(this.getAllTabContributors().stream().collect(Collectors.toMap(c -> c, c -> 15)));
        }
        List contributors = DumbService.getInstance(this.myProject).filterByDumbAwareness(contributorsMap.keySet());
        if (contributors.isEmpty() && DumbService.isDumb(this.myProject)) {
            this.myResultsList.setEmptyText(IdeBundle.message("searcheverywhere.indexing.mode.not.supported", this.mySelectedTab.getText(), ApplicationNamesInfo.getInstance().getFullProductName()));
            this.myListModel.clear();
            return;
        }
        if (contributors.size() != contributorsMap.size()) {
            this.myResultsList.setEmptyText(IdeBundle.message("searcheverywhere.indexing.incomplete.results", this.mySelectedTab.getText(), ApplicationNamesInfo.getInstance().getFullProductName()));
        }
        this.myListModel.expireResults();
        contributors.forEach(contributor -> this.myListModel.setHasMore((SearchEverywhereContributor<?>)contributor, false));
        String commandPrefix = SearchTopHitProvider.getTopHitAccelerator();
        if (rawPattern.startsWith(commandPrefix) && !(commands = SearchEverywhereUI.getCommandsForCompletion(contributors, typedCommand = rawPattern.split(" ")[0].substring(commandPrefix.length()))).isEmpty()) {
            if (rawPattern.contains(" ")) {
                contributorsMap.keySet().retainAll(commands.stream().map(SearchEverywhereCommandInfo::getContributor).collect(Collectors.toSet()));
            } else {
                this.myListModel.clear();
                List<SearchEverywhereFoundElementInfo> lst = ContainerUtil.map(commands, command -> new SearchEverywhereFoundElementInfo(command, 0, this.myStubCommandContributor));
                this.myListModel.addElements(lst);
                ScrollingUtil.ensureSelectionExists(this.myResultsList);
            }
        }
        this.mySearchProgressIndicator = this.mySearcher.search(contributorsMap, rawPattern);
    }

    private void initSearchActions() {
        MouseAdapter listMouseListener = new MouseAdapter(){
            private int currentDescriptionIndex = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchEverywhereUI.this.onMouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = SearchEverywhereUI.this.myResultsList.locationToIndex(e.getPoint());
                this.indexChanged(index);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int index = SearchEverywhereUI.this.myResultsList.getSelectedIndex();
                this.indexChanged(index);
            }

            private void indexChanged(int index) {
                if (index != this.currentDescriptionIndex) {
                    this.currentDescriptionIndex = index;
                    SearchEverywhereUI.this.showDescriptionForIndex(index);
                }
            }
        };
        this.myResultsList.addMouseMotionListener(listMouseListener);
        this.myResultsList.addMouseListener(listMouseListener);
        ScrollingUtil.redirectExpandSelection(this.myResultsList, this.mySearchField);
        Consumer<AnActionEvent> nextTabAction = e -> {
            this.switchToNextTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        Consumer<AnActionEvent> prevTabAction = e -> {
            this.switchToPrevTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        this.registerAction("SearchEverywhere.CompleteCommand", () -> new CompleteCommandAction());
        this.registerAction("SearchEverywhere.NextTab", nextTabAction);
        this.registerAction("SearchEverywhere.PrevTab", prevTabAction);
        this.registerAction("NextTab", nextTabAction);
        this.registerAction("PreviousTab", prevTabAction);
        this.registerAction("Switcher", (? super AnActionEvent e) -> {
            if (e.getInputEvent().isShiftDown()) {
                this.switchToPrevTab();
            } else {
                this.switchToNextTab();
            }
            this.triggerTabSwitched((AnActionEvent)e);
        });
        this.registerAction("SearchEverywhere.NavigateToNextGroup", (? super AnActionEvent e) -> {
            this.fetchGroups(true);
            FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(null).addInputEvent(e);
            this.featureTriggered("navigateThroughGroups", data2);
        });
        this.registerAction("SearchEverywhere.NavigateToPrevGroup", (? super AnActionEvent e) -> {
            this.fetchGroups(false);
            FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(null).addInputEvent(e);
            this.featureTriggered("navigateThroughGroups", data2);
        });
        this.registerSelectItemAction();
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> this.closePopup()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), this);
        this.mySearchField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                String newSearchString = SearchEverywhereUI.this.getSearchPattern();
                if (SearchEverywhereUI.this.myNotFoundString != null) {
                    boolean newPatternContainsPrevious;
                    boolean bl = newPatternContainsPrevious = SearchEverywhereUI.this.myNotFoundString.length() > 1 && newSearchString.contains(SearchEverywhereUI.this.myNotFoundString);
                    if (SearchEverywhereUI.this.myEverywhereAutoSet && SearchEverywhereUI.this.isEverywhere() && SearchEverywhereUI.this.canToggleEverywhere() && !newPatternContainsPrevious) {
                        SearchEverywhereUI.this.myNotFoundString = null;
                        SearchEverywhereUI.this.setEverywhereAuto(false);
                        return;
                    }
                }
                SearchEverywhereUI.this.rebuildList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$4", "textChanged"));
            }
        });
        this.myResultsList.addListSelectionListener(e -> {
            Object selectedValue = this.myResultsList.getSelectedValue();
            if (selectedValue != null && this.myHint != null && this.myHint.isVisible()) {
                this.updateHint(selectedValue);
            }
            this.showDescriptionForIndex(this.myResultsList.getSelectedIndex());
        });
        MessageBusConnection projectBusConnection = this.myProject.getMessageBus().connect(this);
        projectBusConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    SearchEverywhereUI.this.rebuildSearchFieldExtensions();
                    SearchEverywhereUI.this.rebuildList();
                });
            }
        });
        projectBusConnection.subscribe(AnActionListener.TOPIC, new AnActionListener(){

            @Override
            public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (action2 == ((SearchEverywhereUI)SearchEverywhereUI.this).mySelectedTab.everywhereAction && event.getInputEvent() != null) {
                    SearchEverywhereUI.this.myEverywhereAutoSet = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$6";
                objectArray[2] = "afterActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register(pw, () -> this.myResultsList.repaint()));
        this.mySearchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (!SearchEverywhereUI.this.isHintComponent(oppositeComponent) && !UIUtil.haveCommonOwner(SearchEverywhereUI.this, oppositeComponent)) {
                    SearchEverywhereUI.this.closePopup();
                }
            }
        });
    }

    private void showDescriptionForIndex(int index) {
        SearchEverywhereContributor<Object> contributor;
        Object data2;
        if (index >= 0 && !this.myListModel.isMoreElement(index) && (data2 = (contributor = this.myListModel.getContributorForIndex(index)).getDataForItem(this.myListModel.getElementAt(index), SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.getName())) instanceof String) {
            ActionMenu.showDescriptionInStatusBar(true, this.myResultsList, (String)data2);
        }
    }

    private void registerAction(String actionID, Supplier<? extends AnAction> actionSupplier) {
        Optional.ofNullable(ActionManager.getInstance().getAction(actionID)).map(a -> a.getShortcutSet()).ifPresent(shortcuts -> ((AnAction)actionSupplier.get()).registerCustomShortcutSet((ShortcutSet)shortcuts, this, this));
    }

    private void registerAction(String actionID, Consumer<? super AnActionEvent> action2) {
        this.registerAction(actionID, () -> DumbAwareAction.create(action2));
    }

    private void registerSelectItemAction() {
        int[] allowedModifiers = new int[]{0, 1, 2, 4, 8};
        ShortcutSet selectShortcuts = ActionManager.getInstance().getAction("SearchEverywhere.SelectItem").getShortcutSet();
        Collection keyboardShortcuts = Arrays.stream(selectShortcuts.getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut).map(shortcut -> (KeyboardShortcut)shortcut).collect(Collectors.toList());
        for (int modifiers : allowedModifiers) {
            ArrayList<KeyboardShortcut> newShortcuts = new ArrayList<KeyboardShortcut>();
            for (KeyboardShortcut shortcut2 : keyboardShortcuts) {
                KeyStroke originalStroke;
                boolean hasSecondStroke = shortcut2.getSecondKeyStroke() != null;
                KeyStroke keyStroke = originalStroke = hasSecondStroke ? shortcut2.getSecondKeyStroke() : shortcut2.getFirstKeyStroke();
                if ((originalStroke.getModifiers() & modifiers) != 0) continue;
                KeyStroke newStroke = KeyStroke.getKeyStroke(originalStroke.getKeyCode(), originalStroke.getModifiers() | modifiers);
                newShortcuts.add(hasSecondStroke ? new KeyboardShortcut(shortcut2.getFirstKeyStroke(), newStroke) : new KeyboardShortcut(newStroke, null));
            }
            if (newShortcuts.isEmpty()) continue;
            CustomShortcutSet newShortcutSet = new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY));
            DumbAwareAction.create(event -> {
                int[] indices = this.myResultsList.getSelectedIndices();
                this.elementsSelected(indices, modifiers);
            }).registerCustomShortcutSet(newShortcutSet, this, this);
        }
    }

    private void triggerTabSwitched(AnActionEvent e) {
        String id2 = this.mySelectedTab.getContributor().map(SearchEverywhereUsageTriggerCollector::getReportableContributorID).orElse("SearchEverywhereContributor.All");
        FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(id2).addInputEvent(e);
        this.featureTriggered("tabSwitched", data2);
    }

    private void fetchGroups(boolean down) {
        int index = this.myResultsList.getSelectedIndex();
        while ((index += down ? 1 : -1) >= 0 && index < this.myListModel.getSize() && !this.myListModel.isGroupFirstItem(index) && !this.myListModel.isMoreElement(index)) {
        }
        if (index >= 0 && index < this.myListModel.getSize()) {
            this.myResultsList.setSelectedIndex(index);
            ScrollingUtil.ensureIndexIsVisible(this.myResultsList, index, 0);
        }
    }

    private Optional<SearchEverywhereCommandInfo> getSelectedCommand(String typedCommand) {
        int index = this.myResultsList.getSelectedIndex();
        if (index < 0) {
            return Optional.empty();
        }
        SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index);
        if (contributor != this.myStubCommandContributor) {
            return Optional.empty();
        }
        SearchEverywhereCommandInfo selectedCommand = (SearchEverywhereCommandInfo)this.myListModel.getElementAt(index);
        return selectedCommand.getCommand().contains(typedCommand) ? Optional.of(selectedCommand) : Optional.empty();
    }

    @NotNull
    private static List<SearchEverywhereCommandInfo> getCommandsForCompletion(Collection<? extends SearchEverywhereContributor<?>> contributors, String enteredCommandPart) {
        Comparator cmdComparator = (cmd1, cmd2) -> {
            String cmdName1 = cmd1.getCommand();
            String cmdName2 = cmd2.getCommand();
            if (!enteredCommandPart.isEmpty()) {
                if (cmdName1.startsWith(enteredCommandPart) && !cmdName2.startsWith(enteredCommandPart)) {
                    return -1;
                }
                if (!cmdName1.startsWith(enteredCommandPart) && cmdName2.startsWith(enteredCommandPart)) {
                    return 1;
                }
            }
            return String.CASE_INSENSITIVE_ORDER.compare(cmdName1, cmd2.getCommand());
        };
        List<SearchEverywhereCommandInfo> list2 = contributors.stream().flatMap(contributor -> contributor.getSupportedCommands().stream()).filter(command -> command.getCommand().contains(enteredCommandPart)).sorted(cmdComparator).collect(Collectors.toList());
        if (list2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        boolean multiSelectMode;
        if (e == null) {
            SearchEverywhereUI.$$$reportNull$$$0(14);
        }
        boolean bl = multiSelectMode = e.isShiftDown() || UIUtil.isControlKeyDown(e);
        if (e.getButton() == 1 && !multiSelectMode) {
            e.consume();
            int i = this.myResultsList.locationToIndex(e.getPoint());
            if (i > -1) {
                this.myResultsList.setSelectedIndex(i);
                this.elementsSelected(new int[]{i}, e.getModifiers());
            }
        }
    }

    private boolean isHintComponent(Component component2) {
        if (this.myHint != null && !this.myHint.isDisposed() && component2 != null) {
            return SwingUtilities.isDescendingFrom(component2, this.myHint.getContent());
        }
        return false;
    }

    private void elementsSelected(int[] indexes, int modifiers) {
        if (indexes.length == 1 && this.myListModel.isMoreElement(indexes[0])) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(indexes[0]);
            this.showMoreElements(contributor);
            return;
        }
        indexes = Arrays.stream(indexes).filter(i -> !this.myListModel.isMoreElement(i)).toArray();
        String searchText = this.getSearchPattern();
        if (searchText.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && searchText.contains(" ")) {
            this.featureTriggered("commandUsed", null);
        }
        boolean closePopup = false;
        for (int i2 : indexes) {
            SearchEverywhereContributor<Object> contributor = this.myListModel.getContributorForIndex(i2);
            Object value2 = this.myListModel.getElementAt(i2);
            String selectedTabContributorID = this.mySelectedTab.getContributor().map(SearchEverywhereUsageTriggerCollector::getReportableContributorID).orElse("SearchEverywhereContributor.All");
            String reportableContributorID = SearchEverywhereUsageTriggerCollector.getReportableContributorID(contributor);
            FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(reportableContributorID, selectedTabContributorID, i2);
            if (value2 instanceof PsiElement) {
                data2.addLanguage(((PsiElement)value2).getLanguage());
            }
            this.featureTriggered("contributorItemChosen", data2);
            closePopup |= contributor.processSelectedItem(value2, modifiers, searchText);
        }
        if (closePopup) {
            this.closePopup();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.myResultsList.repaint());
        }
    }

    private void showMoreElements(SearchEverywhereContributor contributor) {
        this.featureTriggered("moreItemChosen", null);
        Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> found2 = this.myListModel.getFoundElementsMap();
        int limit = this.myListModel.getItemsForContributor(contributor) + (this.mySelectedTab.getContributor().isPresent() ? 30 : 15);
        this.mySearchProgressIndicator = this.mySearcher.findMoreItems(found2, this.getSearchPattern(), contributor, limit);
    }

    private void stopSearching() {
        if (this.mySearchProgressIndicator != null && !this.mySearchProgressIndicator.isCanceled()) {
            this.mySearchProgressIndicator.cancel();
        }
        if (this.myBufferedListener != null) {
            this.myBufferedListener.clearBuffer();
        }
    }

    private void closePopup() {
        ActionMenu.showDescriptionInStatusBar(true, this.myResultsList, null);
        this.stopSearching();
        this.searchFinishedHandler.run();
    }

    @NotNull
    private List<SearchEverywhereContributor<?>> getAllTabContributors() {
        List<SearchEverywhereContributor<?>> list2 = ContainerUtil.filter(this.myShownContributors, contributor -> this.myContributorsFilter.isSelected(contributor.getSearchProviderId()));
        if (list2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    private Collection<SearchEverywhereContributor<?>> getContributorsForCurrentTab() {
        Collection<SearchEverywhereContributor<?>> collection = this.isAllTabSelected() ? this.getAllTabContributors() : Collections.singleton(this.mySelectedTab.getContributor().get());
        if (collection == null) {
            SearchEverywhereUI.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public Future<List<Object>> findElementsForPattern(String pattern) {
        CompletableFuture<List<Object>> future2 = new CompletableFuture<List<Object>>();
        this.mySearchListener.setTestCallback(list2 -> {
            future2.complete((List<Object>)list2);
            this.mySearchListener.setTestCallback(null);
        });
        this.mySearchField.setText(pattern);
        return future2;
    }

    private String getNotFoundText() {
        return this.mySelectedTab.getContributor().map(c -> IdeBundle.message("searcheverywhere.nothing.found.for.contributor.anywhere", c.getFullGroupName().toLowerCase(Locale.ROOT))).orElse(IdeBundle.message("searcheverywhere.nothing.found.for.all.anywhere", new Object[0]));
    }

    private void featureTriggered(@NotNull String featureID, @Nullable FeatureUsageData data2) {
        if (featureID == null) {
            SearchEverywhereUI.$$$reportNull$$$0(17);
        }
        if (data2 != null) {
            SearchEverywhereUsageTriggerCollector.trigger(this.myProject, featureID, data2);
        } else {
            SearchEverywhereUsageTriggerCollector.trigger(this.myProject, featureID);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorID";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialHint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLeftPanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsForCompletion";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTabContributors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContributorsForCurrentTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "switchToContributor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerHint";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "featureTriggered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SearchListener
    implements SESearcher.Listener {
        private Consumer<List<Object>> testCallback;

        private SearchListener() {
        }

        @Override
        public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            Object prevSelection;
            if (list2 == null) {
                SearchListener.$$$reportNull$$$0(0);
            }
            boolean wasEmpty = SearchEverywhereUI.this.myListModel.listElements.isEmpty();
            SearchEverywhereUI.this.mySelectionTracker.lock();
            SearchEverywhereUI.this.myListModel.addElements(list2);
            SearchEverywhereUI.this.mySelectionTracker.unlock();
            SearchEverywhereUI.this.mySelectionTracker.restoreSelection();
            if (wasEmpty && !SearchEverywhereUI.this.myListModel.listElements.isEmpty() && (prevSelection = ((SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereUI.this.myProject)).getPrevSelection(SearchEverywhereUI.this.getSelectedContributorID())) instanceof Integer) {
                for (SearchEverywhereFoundElementInfo info : SearchEverywhereUI.this.myListModel.listElements) {
                    if (Objects.hashCode(info.element) != (Integer)prevSelection) continue;
                    SearchEverywhereUI.this.myResultsList.setSelectedValue(info.element, true);
                    break;
                }
            }
        }

        @Override
        public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            if (list2 == null) {
                SearchListener.$$$reportNull$$$0(1);
            }
            list2.forEach(info -> SearchEverywhereUI.this.myListModel.removeElement(info.getElement(), info.getContributor()));
        }

        @Override
        public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
            if (hasMoreContributors == null) {
                SearchListener.$$$reportNull$$$0(2);
            }
            if (SearchEverywhereUI.this.myResultsList.isEmpty() || SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                if (SearchEverywhereUI.this.myEverywhereAutoSet && !SearchEverywhereUI.this.isEverywhere() && SearchEverywhereUI.this.canToggleEverywhere() && !SearchEverywhereUI.this.getSearchPattern().isEmpty()) {
                    SearchEverywhereUI.this.setEverywhereAuto(true);
                    SearchEverywhereUI.this.myNotFoundString = SearchEverywhereUI.this.getSearchPattern();
                    return;
                }
                SearchEverywhereUI.this.hideHint();
                if (SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                    SearchEverywhereUI.this.myListModel.clear();
                }
            }
            SearchEverywhereUI.this.myResultsList.setEmptyText(SearchEverywhereUI.this.getSearchPattern().isEmpty() ? "" : SearchEverywhereUI.this.getNotFoundText());
            hasMoreContributors.forEach(SearchEverywhereUI.this.myListModel::setHasMore);
            SearchEverywhereUI.this.mySelectionTracker.resetSelectionIfNeeded();
            if (this.testCallback != null) {
                this.testCallback.consume(SearchEverywhereUI.this.myListModel.getItems());
            }
        }

        void setTestCallback(@Nullable Consumer<List<Object>> callback2) {
            this.testCallback = callback2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasMoreContributors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CompleteCommandAction
    extends DumbAwareAction {
        private CompleteCommandAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(0);
            }
            if (this.completeCommand()) {
                FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(null).addInputEvent(e);
                SearchEverywhereUI.this.featureTriggered("commandCompleted", data2);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getCompleteCommand().isPresent());
        }

        private boolean completeCommand() {
            Optional<SearchEverywhereCommandInfo> suggestedCommand = this.getCompleteCommand();
            if (suggestedCommand.isPresent()) {
                SearchEverywhereUI.this.mySearchField.setText(suggestedCommand.get().getCommandWithPrefix() + " ");
                return true;
            }
            return false;
        }

        private Optional<SearchEverywhereCommandInfo> getCompleteCommand() {
            String commandPrefix;
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            if (pattern.startsWith(commandPrefix = SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
                String typedCommand = pattern.substring(commandPrefix.length());
                SearchEverywhereCommandInfo command = SearchEverywhereUI.this.getSelectedCommand(typedCommand).orElseGet(() -> {
                    List completions = SearchEverywhereUI.getCommandsForCompletion(SearchEverywhereUI.this.getContributorsForCurrentTab(), typedCommand);
                    return completions.isEmpty() ? null : (SearchEverywhereCommandInfo)completions.get(0);
                });
                return Optional.ofNullable(command);
            }
            return Optional.empty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CompleteCommandAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FiltersAction
    extends ShowFilterAction {
        final PersistentSearchEverywhereContributorFilter<?> filter;
        final Runnable rebuildRunnable;

        FiltersAction(@NotNull PersistentSearchEverywhereContributorFilter<?> filter2, @NotNull Runnable rebuildRunnable) {
            if (filter2 == null) {
                FiltersAction.$$$reportNull$$$0(0);
            }
            if (rebuildRunnable == null) {
                FiltersAction.$$$reportNull$$$0(1);
            }
            this.filter = filter2;
            this.rebuildRunnable = rebuildRunnable;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        protected boolean isActive() {
            return this.filter.getAllElements().size() != this.filter.getSelectedElements().size();
        }

        @Override
        protected ElementsChooser<?> createChooser() {
            return FiltersAction.createChooser(this.filter, this.rebuildRunnable);
        }

        private static <T> ElementsChooser<T> createChooser(final @NotNull PersistentSearchEverywhereContributorFilter<T> filter2, @NotNull Runnable rebuildRunnable) {
            if (filter2 == null) {
                FiltersAction.$$$reportNull$$$0(2);
            }
            if (rebuildRunnable == null) {
                FiltersAction.$$$reportNull$$$0(3);
            }
            ElementsChooser res2 = new ElementsChooser<T>(filter2.getAllElements(), false){

                @Override
                protected String getItemText(@NotNull T value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return filter2.getElementText(value2);
                }

                @Override
                @Nullable
                protected Icon getItemIcon(@NotNull T value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return filter2.getElementIcon(value2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$FiltersAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getItemText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getItemIcon";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            res2.markElements(filter2.getSelectedElements());
            ElementsChooser.ElementsMarkListener<Object> listener2 = (element2, isMarked) -> {
                filter2.setSelected(element2, isMarked);
                rebuildRunnable.run();
            };
            res2.addElementsMarkListener(listener2);
            return res2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rebuildRunnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$FiltersAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createChooser";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowInFindToolWindowAction
    extends DumbAwareAction {
        ShowInFindToolWindowAction() {
            super(IdeBundle.messagePointer("show.in.find.window.button.name", new Object[0]), IdeBundle.messagePointer("show.in.find.window.button.description", new Object[0]), AllIcons.General.Pin_tab);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(0);
            }
            SearchEverywhereUI.this.stopSearching();
            List<SearchEverywhereContributor> contributors = SearchEverywhereUI.this.getContributorsForCurrentTab();
            contributors = ContainerUtil.filter(contributors, SearchEverywhereContributor::showInFindResults);
            if (contributors.isEmpty()) {
                return;
            }
            final String searchText = SearchEverywhereUI.this.getSearchPattern();
            String contributorsString = contributors.stream().map(SearchEverywhereContributor::getGroupName).collect(Collectors.joining(", "));
            final UsageViewPresentation presentation = new UsageViewPresentation();
            String tabCaptionText = IdeBundle.message("searcheverywhere.found.matches.title", searchText, contributorsString);
            presentation.setCodeUsagesString(tabCaptionText);
            presentation.setUsagesInGeneratedCodeString(IdeBundle.message("searcheverywhere.found.matches.generated.code.title", searchText, contributorsString));
            presentation.setTargetsNodeText(IdeBundle.message("searcheverywhere.found.targets.title", searchText, contributorsString));
            presentation.setTabName(tabCaptionText);
            presentation.setTabText(tabCaptionText);
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            final LinkedHashSet targets2 = new LinkedHashSet();
            final Collection cached = contributors.stream().flatMap(contributor -> SearchEverywhereUI.this.myListModel.getFoundItems((SearchEverywhereContributor)contributor).stream()).collect(Collectors.toSet());
            this.fillUsages(cached, usages, targets2);
            final List<SearchEverywhereContributor> contributorsForAdditionalSearch = ContainerUtil.filter(contributors, contributor -> SearchEverywhereUI.this.myListModel.hasMoreElements((SearchEverywhereContributor)contributor));
            SearchEverywhereUI.this.closePopup();
            if (!contributorsForAdditionalSearch.isEmpty()) {
                ProgressManager.getInstance().run(new Task.Modal(SearchEverywhereUI.this.myProject, tabCaptionText, true){
                    private final ProgressIndicator progressIndicator;
                    {
                        super(arg0, arg1, arg2);
                        this.progressIndicator = new ProgressIndicatorBase();
                    }

                    @Override
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.progressIndicator.start();
                        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(this.progressIndicator);
                        ArrayList<Object> foundElements = new ArrayList<Object>();
                        int alreadyFoundCount = cached.size();
                        for (SearchEverywhereContributor contributor : contributorsForAdditionalSearch) {
                            if (this.progressIndicator.isCanceled()) break;
                            try {
                                this.fetch(contributor, foundElements, alreadyFoundCount, tooManyUsagesStatus);
                            }
                            catch (ProcessCanceledException processCanceledException) {}
                        }
                        ShowInFindToolWindowAction.this.fillUsages(foundElements, usages, targets2);
                    }

                    <Item> void fetch(SearchEverywhereContributor<Item> contributor, Collection<Object> foundElements, int alreadyFoundCount, TooManyUsagesStatus tooManyUsagesStatus) {
                        contributor.fetchElements(searchText, this.progressIndicator, o -> {
                            if (this.progressIndicator.isCanceled()) {
                                return false;
                            }
                            if (cached.contains(o)) {
                                return true;
                            }
                            foundElements.add(o);
                            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                            if (foundElements.size() + alreadyFoundCount >= 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                int usageCount = foundElements.size() + alreadyFoundCount;
                                UsageViewManagerImpl.showTooManyUsagesWarningLater(this.getProject(), tooManyUsagesStatus, this.progressIndicator, presentation, usageCount, null);
                                return !this.progressIndicator.isCanceled();
                            }
                            return true;
                        });
                    }

                    @Override
                    public void onCancel() {
                        this.progressIndicator.cancel();
                    }

                    @Override
                    public void onSuccess() {
                        ShowInFindToolWindowAction.this.showInFindWindow(targets2, usages, presentation);
                    }

                    @Override
                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.progressIndicator.cancel();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                this.showInFindWindow(targets2, usages, presentation);
            }
        }

        private void fillUsages(Collection<Object> foundElements, Collection<? super Usage> usages, Collection<? super PsiElement> targets2) {
            ReadAction.run(() -> foundElements.stream().filter(o -> o instanceof PsiElement).forEach(o -> {
                PsiElement element2 = (PsiElement)o;
                if (element2.getTextRange() != null) {
                    UsageInfo usageInfo = new UsageInfo(element2);
                    usages.add(new UsageInfo2UsageAdapter(usageInfo));
                } else {
                    targets2.add(element2);
                }
            }));
        }

        private void showInFindWindow(Collection<? extends PsiElement> targets2, Collection<Usage> usages, UsageViewPresentation presentation) {
            UsageTarget[] targetsArray = targets2.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets2));
            Usage[] usagesArray = usages.toArray(Usage.EMPTY_ARRAY);
            UsageViewManager.getInstance(SearchEverywhereUI.this.myProject).showUsages(targetsArray, usagesArray, presentation);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(1);
            }
            SearchEverywhereContributor<?> contributor = SearchEverywhereUI.this.mySelectedTab == null ? null : ((SearchEverywhereUI)SearchEverywhereUI.this).mySelectedTab.contributor;
            e.getPresentation().setEnabled(contributor == null || contributor.showInFindResults());
            e.getPresentation().setIcon(ToolWindowManagerEx.getInstanceEx(SearchEverywhereUI.this.myProject).getLocationIcon("Find", AllIcons.General.Pin_tab));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SearchListModel
    extends AbstractListModel<Object> {
        static final Object MORE_ELEMENT = new Object();
        private final List<SearchEverywhereFoundElementInfo> listElements = new ArrayList<SearchEverywhereFoundElementInfo>();
        private boolean resultsExpired = false;

        public boolean isResultsExpired() {
            return this.resultsExpired;
        }

        public void expireResults() {
            this.resultsExpired = true;
        }

        @Override
        public int getSize() {
            return this.listElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.listElements.get(index).getElement();
        }

        public List<Object> getItems() {
            return new ArrayList<Object>(this.values());
        }

        public Collection<Object> getFoundItems(SearchEverywhereContributor contributor) {
            return this.listElements.stream().filter(info -> info.getContributor() == contributor && info.getElement() != MORE_ELEMENT).map(info -> info.getElement()).collect(Collectors.toList());
        }

        public boolean hasMoreElements(SearchEverywhereContributor contributor) {
            return this.listElements.stream().anyMatch(info -> info.getElement() == MORE_ELEMENT && info.getContributor() == contributor);
        }

        public void addElements(List<? extends SearchEverywhereFoundElementInfo> items) {
            if (items.isEmpty()) {
                return;
            }
            HashMap<SearchEverywhereContributor, List> itemsMap = new HashMap<SearchEverywhereContributor, List>();
            items.forEach(info -> {
                List list2 = itemsMap.computeIfAbsent(info.getContributor(), contributor -> new ArrayList());
                list2.add(info);
            });
            itemsMap.forEach((contributor, list2) -> Collections.sort(list2, Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed()));
            if (this.resultsExpired) {
                this.retainContributors(itemsMap.keySet());
                this.clearMoreItems();
                itemsMap.forEach((contributor, list2) -> {
                    Object[] oldItems = ArrayUtil.toObjectArray(this.getFoundItems((SearchEverywhereContributor)contributor));
                    Object[] newItems = list2.stream().map(SearchEverywhereFoundElementInfo::getElement).toArray();
                    try {
                        Diff.Change change = Diff.buildChanges(oldItems, newItems);
                        this.applyChange(change, (SearchEverywhereContributor<?>)contributor, (List<SearchEverywhereFoundElementInfo>)list2);
                    }
                    catch (FilesTooBigForDiffException e) {
                        LOG.error("Cannot calculate diff for updated search results");
                    }
                });
                this.resultsExpired = false;
            } else {
                itemsMap.forEach((contributor, list2) -> {
                    int startIndex = this.contributors().indexOf(contributor);
                    int insertionIndex = this.getInsertionPoint((SearchEverywhereContributor)contributor);
                    int endIndex = insertionIndex + list2.size() - 1;
                    this.listElements.addAll(insertionIndex, (Collection<SearchEverywhereFoundElementInfo>)list2);
                    this.fireIntervalAdded(this, insertionIndex, endIndex);
                    if (startIndex >= 0) {
                        this.listElements.subList(startIndex, endIndex + 1).sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed());
                        this.fireContentsChanged(this, startIndex, endIndex);
                    }
                });
            }
        }

        private void retainContributors(Collection<SearchEverywhereContributor<?>> retainContributors) {
            Iterator<SearchEverywhereFoundElementInfo> iterator2 = this.listElements.iterator();
            int startInterval = 0;
            int endInterval = -1;
            while (iterator2.hasNext()) {
                SearchEverywhereFoundElementInfo item = iterator2.next();
                if (retainContributors.contains(item.getContributor())) {
                    if (startInterval <= endInterval) {
                        this.fireIntervalRemoved(this, startInterval, endInterval);
                        startInterval = endInterval + 2;
                    } else {
                        ++startInterval;
                    }
                } else {
                    iterator2.remove();
                }
                ++endInterval;
            }
            if (startInterval <= endInterval) {
                this.fireIntervalRemoved(this, startInterval, endInterval);
            }
        }

        private void clearMoreItems() {
            ListIterator<SearchEverywhereFoundElementInfo> iterator2 = this.listElements.listIterator();
            while (iterator2.hasNext()) {
                int index = iterator2.nextIndex();
                if (iterator2.next().getElement() != MORE_ELEMENT) continue;
                iterator2.remove();
                this.fireContentsChanged(this, index, index);
            }
        }

        private void applyChange(Diff.Change change, SearchEverywhereContributor<?> contributor, List<SearchEverywhereFoundElementInfo> newItems) {
            int firstItemIndex = this.contributors().indexOf(contributor);
            if (firstItemIndex < 0) {
                firstItemIndex = this.getInsertionPoint(contributor);
            }
            for (Diff.Change ch : SearchListModel.toRevertedList(change)) {
                if (ch.deleted > 0) {
                    for (int i = ch.deleted - 1; i >= 0; --i) {
                        int index = firstItemIndex + ch.line0 + i;
                        this.listElements.remove(index);
                    }
                    this.fireIntervalRemoved(this, firstItemIndex + ch.line0, firstItemIndex + ch.line0 + ch.deleted - 1);
                }
                if (ch.inserted <= 0) continue;
                List<SearchEverywhereFoundElementInfo> addedItems = newItems.subList(ch.line1, ch.line1 + ch.inserted);
                this.listElements.addAll(firstItemIndex + ch.line0, addedItems);
                this.fireIntervalAdded(this, firstItemIndex + ch.line0, firstItemIndex + ch.line0 + ch.inserted - 1);
            }
        }

        private static List<Diff.Change> toRevertedList(Diff.Change change) {
            ArrayList<Diff.Change> res2 = new ArrayList<Diff.Change>();
            while (change != null) {
                res2.add(0, change);
                change = change.link;
            }
            return res2;
        }

        public void removeElement(@NotNull Object item, SearchEverywhereContributor contributor) {
            int index;
            if (item == null) {
                SearchListModel.$$$reportNull$$$0(0);
            }
            if ((index = this.contributors().indexOf(contributor)) < 0) {
                return;
            }
            while (index < this.listElements.size() && this.listElements.get(index).getContributor() == contributor) {
                if (item.equals(this.listElements.get(index).getElement())) {
                    this.listElements.remove(index);
                    this.fireIntervalRemoved(this, index, index);
                    return;
                }
                ++index;
            }
        }

        public void setHasMore(SearchEverywhereContributor<?> contributor, boolean newVal) {
            int index = this.contributors().lastIndexOf(contributor);
            if (index < 0) {
                return;
            }
            boolean alreadyHas = this.isMoreElement(index);
            if (alreadyHas && !newVal) {
                this.listElements.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
            if (!alreadyHas && newVal) {
                this.listElements.add(++index, new SearchEverywhereFoundElementInfo(MORE_ELEMENT, 0, contributor));
                this.fireIntervalAdded(this, index, index);
            }
        }

        public void clear() {
            int index = this.listElements.size() - 1;
            this.listElements.clear();
            if (index >= 0) {
                this.fireIntervalRemoved(this, 0, index);
            }
        }

        public boolean contains(Object val) {
            return this.values().contains(val);
        }

        public boolean isMoreElement(int index) {
            return this.listElements.get(index).getElement() == MORE_ELEMENT;
        }

        public <Item> SearchEverywhereContributor<Item> getContributorForIndex(int index) {
            return this.listElements.get(index).getContributor();
        }

        public boolean isGroupFirstItem(int index) {
            return index == 0 || this.listElements.get(index).getContributor() != this.listElements.get(index - 1).getContributor();
        }

        public int getItemsForContributor(SearchEverywhereContributor<?> contributor) {
            List<SearchEverywhereContributor> contributorsList = this.contributors();
            int first = contributorsList.indexOf(contributor);
            int last = contributorsList.lastIndexOf(contributor);
            if (this.isMoreElement(last)) {
                --last;
            }
            return last - first + 1;
        }

        public Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> getFoundElementsMap() {
            return this.listElements.stream().filter(info -> info.element != MORE_ELEMENT).collect(Collectors.groupingBy(o -> o.getContributor(), Collectors.toCollection(ArrayList::new)));
        }

        @NotNull
        private List<SearchEverywhereContributor> contributors() {
            List list2 = Lists.transform(this.listElements, info -> info.getContributor());
            if (list2 == null) {
                SearchListModel.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        private List<Object> values() {
            List list2 = Lists.transform(this.listElements, info -> info.getElement());
            if (list2 == null) {
                SearchListModel.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private int getInsertionPoint(SearchEverywhereContributor contributor) {
            if (this.listElements.isEmpty()) {
                return 0;
            }
            List<SearchEverywhereContributor> list2 = this.contributors();
            int index = list2.lastIndexOf(contributor);
            if (index >= 0) {
                return this.isMoreElement(index) ? index : index + 1;
            }
            index = Collections.binarySearch(list2, contributor, Comparator.comparingInt(SearchEverywhereContributor::getSortWeight));
            return -index - 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contributors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElement";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GroupTitleRenderer
    extends CellRendererPanel {
        final SimpleColoredComponent titleLabel = new SimpleColoredComponent();

        GroupTitleRenderer() {
            this.setLayout(new BorderLayout());
            SeparatorComponent separatorComponent = new SeparatorComponent(this.titleLabel.getPreferredSize().height / 2, JBUI.CurrentTheme.BigPopup.listSeparatorColor(), null);
            Object topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel(5, 0).addToCenter(separatorComponent).addToLeft(this.titleLabel).withBorder(JBUI.Borders.empty(1, 7))).withBackground(UIUtil.getListBackground());
            this.add((Component)topPanel, "North");
        }

        public GroupTitleRenderer withDisplayedData(String title, Component itemContent) {
            this.titleLabel.clear();
            this.titleLabel.append(title, SMALL_LABEL_ATTRS);
            Component prevContent = ((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            if (prevContent != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            return this;
        }
    }

    private class CompositeCellRenderer
    implements ListCellRenderer<Object> {
        private CompositeCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Border border;
            if (value2 == SearchListModel.MORE_ELEMENT) {
                Component component2 = SearchEverywhereUI.this.myMoreRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                component2.setPreferredSize(UIUtil.updateListRowHeight(component2.getPreferredSize()));
                return component2;
            }
            SearchEverywhereContributor contributor = SearchEverywhereUI.this.myListModel.getContributorForIndex(index);
            Component component3 = SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            if (component3 == null) {
                component3 = contributor.getElementsRenderer().getListCellRendererComponent(list2, value2, index, isSelected, true);
            }
            if (component3 instanceof JComponent && (border = ((JComponent)component3).getBorder()) != GotoActionModel.GotoActionListCellRenderer.TOGGLE_BUTTON_BORDER) {
                ((JComponent)component3).setBorder(JBUI.Borders.empty(1, 2));
            }
            AppUIUtil.targetToDevice(component3, list2);
            component3.setPreferredSize(UIUtil.updateListRowHeight(component3.getPreferredSize()));
            if (SearchEverywhereUI.this.isAllTabSelected() && SearchEverywhereUI.this.myListModel.isGroupFirstItem(index)) {
                component3 = SearchEverywhereUI.this.myGroupTitleRenderer.withDisplayedData(contributor.getFullGroupName(), component3);
            }
            return component3;
        }
    }

    private class SETab
    extends JLabel {
        final SearchEverywhereContributor<?> contributor;
        final List<AnAction> actions;
        final SearchEverywhereToggleAction everywhereAction;

        SETab(SearchEverywhereContributor<?> contributor) {
            super(contributor == null ? IdeBundle.message("searcheverywhere.allelements.tab.name", new Object[0]) : contributor.getGroupName());
            this.contributor = contributor;
            this.updateTooltip();
            final Runnable onChanged = () -> {
                SearchEverywhereUI.this.myToolbar.updateActionsImmediately();
                SearchEverywhereUI.this.rebuildList();
            };
            if (contributor == null) {
                String actionText = IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
                this.actions = Arrays.asList(new CheckBoxSearchEverywhereToggleAction(actionText){
                    final SearchEverywhereManagerImpl seManager;
                    {
                        super(text2);
                        this.seManager = (SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereUI.this.myProject);
                    }

                    @Override
                    public boolean isEverywhere() {
                        return this.seManager.isEverywhere();
                    }

                    @Override
                    public void setEverywhere(boolean state) {
                        this.seManager.setEverywhere(state);
                        SearchEverywhereUI.this.myTabs.stream().filter(tab -> tab != SETab.this).forEach(tab -> tab.everywhereAction.setEverywhere(state));
                        onChanged.run();
                    }
                }, new FiltersAction(SearchEverywhereUI.this.myContributorsFilter, onChanged));
            } else {
                this.actions = new ArrayList<AnAction>(contributor.getActions(onChanged));
            }
            this.everywhereAction = (SearchEverywhereToggleAction)((Object)ContainerUtil.find(this.actions, o -> o instanceof SearchEverywhereToggleAction));
            Insets insets = JBUI.CurrentTheme.BigPopup.tabInsets();
            this.setBorder(JBUI.Borders.empty(insets.top, insets.left, insets.bottom, insets.right));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchEverywhereUI.this.switchToTab(SETab.this);
                    String reportableID = SETab.this.getContributor().map(SearchEverywhereUsageTriggerCollector::getReportableContributorID).orElse("SearchEverywhereContributor.All");
                    FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(reportableID).addInputEvent(e);
                    SearchEverywhereUI.this.featureTriggered("tabSwitched", data2);
                }
            });
        }

        private void updateTooltip() {
            String shortcut = (String)SearchEverywhereUI.this.myShortcutSupplier.apply(this.getID());
            if (shortcut != null) {
                this.setToolTipText(shortcut);
            }
        }

        public String getID() {
            return this.getContributor().map(SearchEverywhereContributor::getSearchProviderId).orElse("SearchEverywhereContributor.All");
        }

        public Optional<SearchEverywhereContributor<?>> getContributor() {
            return Optional.ofNullable(this.contributor);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUIScale.scale(29);
            return size;
        }

        @Override
        public boolean isOpaque() {
            return SearchEverywhereUI.this.mySelectedTab == this;
        }

        @Override
        public Color getBackground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.BigPopup.selectedTabColor() : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.BigPopup.selectedTabTextColor() : super.getForeground();
        }
    }

    private final class MyAdvertisement
    implements ExtendableTextComponent.Extension {
        private final TextIcon icon = new TextIcon(this.message, JBUI.CurrentTheme.BigPopup.searchFieldGrayForeground(), null, 0);
        String message = "";

        private MyAdvertisement() {
            this.icon.setFont(RelativeFont.SMALL.derive(SearchEverywhereUI.this.getFont()));
        }

        MyAdvertisement withText(@NotNull String text2) {
            if (text2 == null) {
                MyAdvertisement.$$$reportNull$$$0(0);
            }
            this.icon.setText(text2);
            return this;
        }

        @Override
        public Icon getIcon(boolean hovered) {
            return this.icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$MyAdvertisement", "withText"));
        }
    }
}

