/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.dnd.DragSource;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Bookmark
implements Navigatable,
Comparable<Bookmark> {
    static final Icon DEFAULT_ICON = new MyCheckedIcon();
    private OpenFileDescriptor myTarget;
    private Reference<RangeHighlighterEx> myHighlighterRef;
    private int myLine;
    private String myUrl;
    @NotNull
    private String myDescription;
    private char myMnemonic;
    int index;

    @ApiStatus.Internal
    public Bookmark(@NotNull String url, int line, @NotNull String description) {
        if (url == null) {
            Bookmark.$$$reportNull$$$0(0);
        }
        if (description == null) {
            Bookmark.$$$reportNull$$$0(1);
        }
        this.myUrl = url;
        this.myLine = line;
        this.myDescription = description;
    }

    Bookmark(@NotNull Project project2, @NotNull VirtualFile file2, int line, @NotNull String description) {
        if (project2 == null) {
            Bookmark.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            Bookmark.$$$reportNull$$$0(3);
        }
        if (description == null) {
            Bookmark.$$$reportNull$$$0(4);
        }
        this.myDescription = description;
        this.initTarget(project2, file2, line);
    }

    @Nullable
    OpenFileDescriptor init(@NotNull Project project2) {
        if (project2 == null) {
            Bookmark.$$$reportNull$$$0(5);
        }
        if (this.myTarget != null) {
            throw new IllegalStateException("Bookmark is already initialized (file=" + this.myTarget + ")");
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        if (file2 == null) {
            return null;
        }
        this.myUrl = null;
        this.initTarget(project2, file2, this.myLine);
        this.myLine = -1;
        return this.myTarget;
    }

    private void initTarget(@NotNull Project project2, @NotNull VirtualFile file2, int line) {
        if (project2 == null) {
            Bookmark.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            Bookmark.$$$reportNull$$$0(7);
        }
        this.myTarget = new OpenFileDescriptor(project2, file2, line, -1, true);
        this.addHighlighter();
    }

    @NotNull
    public static Font getBookmarkFont() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        if (font == null) {
            Bookmark.$$$reportNull$$$0(8);
        }
        return font;
    }

    @Override
    public int compareTo(@NotNull Bookmark o) {
        int i;
        if (o == null) {
            Bookmark.$$$reportNull$$$0(9);
        }
        int n = this.myMnemonic != '\u0000' ? (o.myMnemonic != '\u0000' ? this.myMnemonic - o.myMnemonic : -1) : (i = o.myMnemonic != '\u0000' ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = this.myTarget.getProject().getName().compareTo(o.myTarget.getProject().getName());
        if (i != 0) {
            return i;
        }
        i = this.myTarget.getFile().getName().compareTo(o.getFile().getName());
        if (i != 0) {
            return i;
        }
        return this.getTarget().compareTo(o.getTarget());
    }

    void updateHighlighter() {
        this.release();
        this.addHighlighter();
    }

    private void addHighlighter() {
        Document document = this.getCachedDocument();
        if (document != null) {
            this.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true));
        }
    }

    public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markup) {
        RangeHighlighterEx highlighter;
        int line;
        if (markup == null) {
            Bookmark.$$$reportNull$$$0(10);
        }
        if ((line = this.getLine()) >= 0) {
            highlighter = markup.addPersistentLineHighlighter(line, 5001, null);
            if (highlighter != null) {
                highlighter.setGutterIconRenderer(new MyGutterIconRenderer(this));
                TextAttributes textAttributes = ObjectUtils.notNull(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BOOKMARKS_ATTRIBUTES), new TextAttributes());
                Color stripeColor = ObjectUtils.notNull(textAttributes.getErrorStripeColor(), new JBColor(0, 0xDBDBDB));
                highlighter.setErrorStripeMarkColor(stripeColor);
                highlighter.setErrorStripeTooltip(this.getBookmarkTooltip());
                TextAttributes attributes = highlighter.getTextAttributes();
                if (attributes == null) {
                    attributes = new TextAttributes();
                }
                attributes.setBackgroundColor(textAttributes.getBackgroundColor());
                attributes.setForegroundColor(textAttributes.getForegroundColor());
                highlighter.setTextAttributes(attributes);
            }
        } else {
            highlighter = null;
        }
        this.myHighlighterRef = highlighter == null ? null : new WeakReference<RangeHighlighterEx>(highlighter);
        return highlighter;
    }

    @Deprecated
    @Nullable
    public Document getDocument() {
        return this.getCachedDocument();
    }

    Document getCachedDocument() {
        return FileDocumentManager.getInstance().getCachedDocument(this.getFile());
    }

    public void release() {
        int line = this.getLine();
        if (line < 0) {
            return;
        }
        Document document = this.getCachedDocument();
        if (document == null) {
            return;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true);
        Document markupDocument = markup.getDocument();
        if (markupDocument.getLineCount() <= line) {
            return;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null) {
            this.myHighlighterRef = null;
            highlighter.dispose();
        }
    }

    private RangeHighlighterEx findMyHighlighter() {
        Document document = this.getCachedDocument();
        if (document == null) {
            return null;
        }
        RangeHighlighterEx result2 = SoftReference.dereference(this.myHighlighterRef);
        if (result2 != null) {
            return result2;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true);
        Document markupDocument = markup.getDocument();
        boolean startOffset = false;
        int endOffset = markupDocument.getTextLength();
        Ref found2 = new Ref();
        markup.processRangeHighlightersOverlappingWith(0, endOffset, highlighter -> {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer instanceof MyGutterIconRenderer && ((MyGutterIconRenderer)renderer).myBookmark == this) {
                found2.set(highlighter);
                return false;
            }
            return true;
        });
        result2 = (RangeHighlighterEx)found2.get();
        this.myHighlighterRef = result2 == null ? null : new WeakReference<RangeHighlighterEx>(result2);
        return result2;
    }

    public Icon getIcon() {
        return this.myMnemonic == '\u0000' ? DEFAULT_ICON : MnemonicIcon.getIcon(this.myMnemonic);
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            Bookmark.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            Bookmark.$$$reportNull$$$0(12);
        }
        this.myDescription = description;
    }

    public char getMnemonic() {
        return this.myMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.myMnemonic = Character.toUpperCase(mnemonic);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myTarget.getFile();
        if (virtualFile2 == null) {
            Bookmark.$$$reportNull$$$0(13);
        }
        return virtualFile2;
    }

    @Nullable
    String nullizeEmptyDescription() {
        return StringUtil.nullize(this.myDescription);
    }

    public boolean isValid() {
        if (!this.getFile().isValid()) {
            return false;
        }
        if (this.getLine() == -1) {
            return true;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        return highlighter != null && highlighter.isValid();
    }

    @Override
    public boolean canNavigate() {
        return this.getTarget().canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getTarget().canNavigateToSource();
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.getTarget().navigate(requestFocus);
    }

    public int getLine() {
        int targetLine = this.myTarget.getLine();
        if (targetLine == -1) {
            return -1;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null && highlighter.isValid()) {
            Document document = highlighter.getDocument();
            return document.getLineNumber(highlighter.getStartOffset());
        }
        RangeMarker marker = this.myTarget.getRangeMarker();
        if (marker != null && marker.isValid()) {
            Document document = marker.getDocument();
            return document.getLineNumber(marker.getStartOffset());
        }
        return targetLine;
    }

    @NotNull
    private OpenFileDescriptor getTarget() {
        int line = this.getLine();
        if (line != this.myTarget.getLine()) {
            this.myTarget = new OpenFileDescriptor(this.myTarget.getProject(), this.myTarget.getFile(), line, -1, true);
        }
        OpenFileDescriptor openFileDescriptor = this.myTarget;
        if (openFileDescriptor == null) {
            Bookmark.$$$reportNull$$$0(14);
        }
        return openFileDescriptor;
    }

    public String toString() {
        String description;
        StringBuilder result2 = new StringBuilder(this.myTarget == null ? this.myUrl : this.getQualifiedName());
        String text2 = this.nullizeEmptyDescription();
        String string = description = text2 == null ? null : StringUtil.escapeXmlEntities(text2);
        if (description != null) {
            result2.append(": ").append(description);
        }
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getQualifiedName() {
        String presentableUrl = this.myTarget.getFile().getPresentableUrl();
        if (this.myTarget.getFile().isDirectory()) {
            String string = presentableUrl;
            if (string == null) {
                Bookmark.$$$reportNull$$$0(15);
            }
            return string;
        }
        PsiFile psiFile = PsiManager.getInstance(this.myTarget.getProject()).findFile(this.myTarget.getFile());
        if (psiFile == null) {
            String string = presentableUrl;
            if (string == null) {
                Bookmark.$$$reportNull$$$0(16);
            }
            return string;
        }
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            ItemPresentation presentation;
            Object element2;
            StructureViewModel model = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(null);
            try {
                element2 = model.getCurrentEditorElement();
            }
            finally {
                Disposer.dispose(model);
            }
            if (element2 instanceof NavigationItem && (presentation = ((NavigationItem)element2).getPresentation()) != null) {
                presentableUrl = ((NavigationItem)element2).getName() + " " + presentation.getLocationString();
            }
        }
        String string = IdeBundle.message("bookmark.file.X.line.Y", presentableUrl, this.getLine() + 1);
        if (string == null) {
            Bookmark.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private String getBookmarkTooltip() {
        String shortcutText;
        String text2;
        String description;
        StringBuilder result2 = new StringBuilder("Bookmark");
        if (this.myMnemonic != '\u0000') {
            result2.append(" ").append(this.myMnemonic);
        }
        String string = description = (text2 = this.nullizeEmptyDescription()) == null ? null : StringUtil.escapeXmlEntities(text2);
        if (description != null) {
            result2.append(": ").append(description);
        }
        StringBuilder shortcutDescription = new StringBuilder();
        if (this.myMnemonic != '\u0000') {
            String navigateShortcutText;
            shortcutText = KeymapUtil.getFirstKeyboardShortcutText("ToggleBookmark" + this.myMnemonic);
            if (shortcutText.length() > 0) {
                shortcutDescription.append(shortcutText).append(" to toggle");
            }
            if ((navigateShortcutText = KeymapUtil.getFirstKeyboardShortcutText("GotoBookmark" + this.myMnemonic)).length() > 0) {
                if (shortcutDescription.length() > 0) {
                    shortcutDescription.append(", ");
                }
                shortcutDescription.append(navigateShortcutText).append(" to jump to");
            }
        }
        if (shortcutDescription.length() == 0 && (shortcutText = KeymapUtil.getFirstKeyboardShortcutText("ToggleBookmark")).length() > 0) {
            shortcutDescription.append(shortcutText).append(" to toggle");
        }
        if (shortcutDescription.length() > 0) {
            result2.append(" (").append((CharSequence)shortcutDescription).append(")");
        }
        String string2 = result2.toString();
        if (string2 == null) {
            Bookmark.$$$reportNull$$$0(18);
        }
        return string2;
    }

    private static boolean darkBackground() {
        Color gutterBackground = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        return ColorUtil.isDark(gutterBackground);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/Bookmark";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/Bookmark";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarkFont";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarkTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initTarget";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Bookmark myBookmark;

        MyGutterIconRenderer(@NotNull Bookmark bookmark) {
            if (bookmark == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            this.myBookmark = bookmark;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.myBookmark.getIcon();
            if (icon2 == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return icon2;
        }

        @Override
        @NotNull
        public String getTooltipText() {
            String string = this.myBookmark.getBookmarkTooltip();
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public GutterDraggableObject getDraggableObject() {
            return new GutterDraggableObject(){

                @Override
                public boolean copy(int line, VirtualFile file2, int actionId) {
                    myBookmark.myTarget = new OpenFileDescriptor(myBookmark.myTarget.getProject(), file2, line, -1, true);
                    myBookmark.updateHighlighter();
                    return true;
                }

                @Override
                public Cursor getCursor(int line, int actionId) {
                    return DragSource.DefaultMoveDrop;
                }
            };
        }

        @Override
        @NotNull
        public String getAccessibleName() {
            String string = "icon: bookmark " + this.myBookmark.myMnemonic;
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer && Comparing.equal(this.getTooltipText(), ((MyGutterIconRenderer)obj).getTooltipText()) && Comparing.equal(this.getIcon(), ((MyGutterIconRenderer)obj).getIcon());
        }

        @Override
        public int hashCode() {
            return this.getIcon().hashCode();
        }

        @Override
        @Nullable
        public ActionGroup getPopupMenuActions() {
            return (ActionGroup)ActionManager.getInstance().getAction("popup@BookmarkContextMenu");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bookmark";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyCheckedIcon
    extends JBCachingScalableIcon<MyCheckedIcon>
    implements RetrievableIcon {
        private MyCheckedIcon() {
        }

        @Override
        @NotNull
        public Icon retrieveIcon() {
            Icon icon2 = IconUtil.scale((Icon)PlatformIcons.CHECK_ICON, null, (float)this.getScale());
            if (icon2 == null) {
                MyCheckedIcon.$$$reportNull$$$0(0);
            }
            return icon2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            IconUtil.scale((Icon)PlatformIcons.CHECK_ICON, (Component)c, (float)this.getScale()).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.scale(PlatformIcons.CHECK_ICON.getIconWidth());
        }

        private int scale(int width) {
            return (int)Math.ceil(this.scaleVal((double)width, ScaleType.OBJ_SCALE));
        }

        @Override
        public int getIconHeight() {
            return this.scale(PlatformIcons.CHECK_ICON.getIconHeight());
        }

        @Override
        @NotNull
        public MyCheckedIcon copy() {
            return new MyCheckedIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark$MyCheckedIcon", "retrieveIcon"));
        }
    }

    static class MnemonicIcon
    extends JBCachingScalableIcon<MnemonicIcon> {
        private static final MnemonicIcon[] cache = new MnemonicIcon[36];
        private final char myMnemonic;

        @Override
        @NotNull
        public MnemonicIcon copy() {
            return new MnemonicIcon(this.myMnemonic);
        }

        @NotNull
        static MnemonicIcon getIcon(char mnemonic) {
            int index = mnemonic - 48;
            if (index > 9) {
                index -= 7;
            }
            if (index < 0 || index > cache.length - 1) {
                return new MnemonicIcon(mnemonic);
            }
            if (cache[index] == null) {
                MnemonicIcon.cache[index] = new MnemonicIcon(mnemonic);
            }
            MnemonicIcon mnemonicIcon = cache[index];
            if (mnemonicIcon == null) {
                MnemonicIcon.$$$reportNull$$$0(0);
            }
            return mnemonicIcon;
        }

        private MnemonicIcon(char mnemonic) {
            this.myMnemonic = mnemonic;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            g.setColor(new JBColor(() -> !Bookmark.darkBackground() ? new Color(0xFFFFCC) : new Color(6770995)));
            g.fillRect(x, y, width, height);
            g.setColor(JBColor.GRAY);
            g.drawRect(x, y, width, height);
            g.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground());
            UISettings.setupAntialiasing(g);
            float startingFontSize = 40.0f;
            Font font = Bookmark.getBookmarkFont().deriveFont(startingFontSize);
            FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
            double height40 = font.createGlyphVector(fontRenderContext, new char[]{'A'}).getVisualBounds().getHeight();
            font = font.deriveFont((float)((double)(startingFontSize * (float)height) / height40 * 0.7));
            GlyphVector gv = font.createGlyphVector(fontRenderContext, new char[]{this.myMnemonic});
            Rectangle2D bounds2 = gv.getVisualBounds();
            ((Graphics2D)g).drawGlyphVector(gv, (float)((double)x + ((double)width - bounds2.getWidth()) / 2.0 - bounds2.getX()), (float)((double)y + ((double)height - bounds2.getHeight()) / 2.0 - bounds2.getY()));
        }

        @Override
        public int getIconWidth() {
            return this.scale(DEFAULT_ICON.getIconWidth());
        }

        private int scale(int width) {
            return (int)Math.ceil(this.scaleVal((double)width, ScaleType.OBJ_SCALE));
        }

        @Override
        public int getIconHeight() {
            return this.scale(DEFAULT_ICON.getIconHeight());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MnemonicIcon that = (MnemonicIcon)o;
            return this.myMnemonic == that.myMnemonic;
        }

        public int hashCode() {
            return this.myMnemonic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark$MnemonicIcon", "getIcon"));
        }
    }
}

