/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BookmarkItem
extends ItemWrapper
implements Comparable<BookmarkItem> {
    private final Bookmark myBookmark;

    public BookmarkItem(Bookmark bookmark) {
        this.myBookmark = bookmark;
    }

    public Bookmark getBookmark() {
        return this.myBookmark;
    }

    @Override
    public void setupRenderer(ColoredListCellRenderer renderer, Project project2, boolean selected2) {
        BookmarkItem.setupRenderer(renderer, project2, this.myBookmark, selected2);
    }

    public static void setupRenderer(SimpleColoredComponent renderer, Project project2, Bookmark bookmark, boolean selected2) {
        String description;
        VirtualFile file2 = bookmark.getFile();
        if (!file2.isValid()) {
            return;
        }
        PsiFileSystemItem fileOrDir = PsiUtilCore.findFileSystemItem(project2, file2);
        if (fileOrDir != null) {
            renderer.setIcon(fileOrDir.getIcon(0));
        }
        if (!StringUtilRt.isEmptyOrSpaces(description = bookmark.getDescription())) {
            renderer.append(description + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true);
        }
        FileStatus fileStatus = FileStatusManager.getInstance(project2).getStatus(file2);
        TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
        renderer.append(file2.getName(), SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes), true);
        if (bookmark.getLine() >= 0) {
            renderer.append(":", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
            renderer.append(String.valueOf(bookmark.getLine() + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
        }
        renderer.append(" (" + VfsUtilCore.getRelativeLocation(file2, project2.getBaseDir()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (!selected2) {
            Color color;
            FileColorManager colorManager = FileColorManager.getInstance(project2);
            if (fileOrDir instanceof PsiFile && (color = colorManager.getRendererBackground((PsiFile)fileOrDir)) != null) {
                renderer.setBackground(color);
            }
        }
    }

    @Override
    public void setupRenderer(ColoredTreeCellRenderer renderer, Project project2, boolean selected2) {
        BookmarkItem.setupRenderer(renderer, project2, this.myBookmark, selected2);
    }

    @Override
    public void updateAccessoryView(JComponent component2) {
        JLabel label2 = (JLabel)component2;
        char mnemonic = this.myBookmark.getMnemonic();
        if (mnemonic != '\u0000') {
            label2.setText(Character.toString(mnemonic) + '.');
        } else {
            label2.setText("");
        }
    }

    @Override
    public String speedSearchText() {
        return this.myBookmark.getFile().getName() + " " + this.myBookmark.getDescription();
    }

    @Override
    public String footerText() {
        return this.myBookmark.getFile().getPresentableUrl();
    }

    @Override
    protected void doUpdateDetailView(DetailView panel2, boolean editorOnly) {
        panel2.navigateInPreviewEditor(DetailView.PreviewEditorState.create(this.myBookmark.getFile(), this.myBookmark.getLine()));
    }

    @Override
    public boolean allowedToRemove() {
        return true;
    }

    @Override
    public void removed(Project project2) {
        BookmarkManager.getInstance(project2).removeBookmark(this.getBookmark());
    }

    @Override
    public int compareTo(BookmarkItem o) {
        return this.myBookmark.compareTo(o.myBookmark);
    }
}

