/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

class EditBookmarkDescriptionAction
extends DumbAwareAction {
    private final Project myProject;
    private final JList<? extends BookmarkItem> myList;
    private JBPopup myPopup;

    EditBookmarkDescriptionAction(Project project2, JList<? extends BookmarkItem> list2) {
        super(IdeBundle.message("action.bookmark.edit.description", new Object[0]), IdeBundle.message("action.bookmark.edit.description.description", new Object[0]), AllIcons.Actions.Edit);
        this.setEnabledInModalContext(true);
        this.myProject = project2;
        this.myList = list2;
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(SystemInfo.isMac ? "meta ENTER" : "control ENTER")), list2);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditBookmarkDescriptionAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.myPopup != null && this.myPopup.isVisible() && BookmarksAction.getSelectedBookmarks(this.myList).size() == 1);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditBookmarkDescriptionAction.$$$reportNull$$$0(1);
        }
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Bookmark bookmark = BookmarksAction.getSelectedBookmarks(this.myList).get(0);
        this.myPopup.setUiVisible(false);
        BookmarkManager.getInstance(this.myProject).editDescription(bookmark, this.myList);
        if (this.myPopup != null && !this.myPopup.isDisposed()) {
            this.myPopup.setUiVisible(true);
            this.myPopup.setSize(this.myPopup.getContent().getPreferredSize());
        }
    }

    public void setPopup(JBPopup popup2) {
        this.myPopup = popup2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/bookmarks/actions/EditBookmarkDescriptionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

