/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GotoBookmarkActionBase
extends EditorAction {
    protected GotoBookmarkActionBase(final boolean next) {
        super(new EditorActionHandler(){

            @Override
            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.navigateToBookmark(dataContext, editor);
            }

            @Override
            public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (caret == null) {
                    1.$$$reportNull$$$0(2);
                }
                return this.getBookmarkToGo(dataContext, editor) != null;
            }

            private void navigateToBookmark(DataContext dataContext, @NotNull Editor editor) {
                Bookmark bookmark;
                if (editor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((bookmark = this.getBookmarkToGo(dataContext, editor)) == null) {
                    return;
                }
                int line = bookmark.getLine();
                if (line >= editor.getDocument().getLineCount()) {
                    return;
                }
                if (line < 0) {
                    line = 0;
                }
                LogicalPosition pos = new LogicalPosition(line, 0);
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().removeSecondaryCarets();
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getScrollingModel().scrollTo(new LogicalPosition(line, 0), ScrollType.CENTER);
            }

            @Nullable
            private Bookmark getBookmarkToGo(DataContext dataContext, @NotNull Editor editor) {
                Project project2;
                if (editor == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((project2 = CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                    return null;
                }
                return BookmarkManager.getInstance(project2).findLineBookmark(editor, true, next);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caret";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/bookmarks/actions/GotoBookmarkActionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doExecute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabledForCaret";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "navigateToBookmark";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getBookmarkToGo";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

