/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateLauncherScriptAction;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardInteractionType;
import com.intellij.ide.customize.CustomizeIDEWizardInteractions;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CustomizeLauncherScriptStep
extends AbstractCustomizeWizardStep {
    private final JCheckBox myCreateScriptCheckBox = new JCheckBox(ActionsBundle.message("action.CreateLauncherScript.description", new Object[0]));
    private final JTextField myScriptPathTextField = new JTextField();

    public static boolean isAvailable() {
        return System.getProperty("idea.skip.launcher.script.step") == null && CreateLauncherScriptAction.isAvailable();
    }

    public CustomizeLauncherScriptStep() {
        this.setLayout(new BorderLayout());
        this.myCreateScriptCheckBox.setOpaque(false);
        this.myCreateScriptCheckBox.setSelected(false);
        this.myCreateScriptCheckBox.addChangeListener(e -> this.myScriptPathTextField.setEnabled(this.myCreateScriptCheckBox.isSelected()));
        this.myScriptPathTextField.setEnabled(false);
        this.myScriptPathTextField.setText(CreateLauncherScriptAction.defaultScriptPath());
        JPanel content2 = new JPanel(CustomizeLauncherScriptStep.createSmallBorderLayout());
        content2.setBorder(CustomizeLauncherScriptStep.createSmallEmptyBorder());
        JPanel controls = new JPanel(new GridBagLayout());
        controls.setOpaque(false);
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultWeightX(1.0);
        controls.add((Component)this.myCreateScriptCheckBox, gbc.nextLine());
        gbc.nextLine();
        gbc.insets.top = UIUtil.PANEL_REGULAR_INSETS.top;
        gbc.insets.left = UIUtil.PANEL_REGULAR_INSETS.left;
        controls.add((Component)new JLabel(IdeBundle.message("label.please.specify.the.path.where.the.script.should.be.created", new Object[0])), gbc);
        controls.add((Component)this.myScriptPathTextField, gbc.nextLine());
        content2.add((Component)controls, "North");
        this.add((Component)content2, "Center");
    }

    @Override
    public boolean beforeOkAction() {
        if (this.myCreateScriptCheckBox.isSelected()) {
            CustomizeIDEWizardInteractions.INSTANCE.record(CustomizeIDEWizardInteractionType.LauncherScriptCreated);
            try {
                CreateLauncherScriptAction.createLauncherScript(this.myScriptPathTextField.getText());
            }
            catch (Exception e) {
                Messages.showErrorDialog(ExceptionUtil.getNonEmptyMessage(e, "Internal error"), IdeBundle.message("dialog.title.launcher.script.creation.failed", new Object[0]));
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getTitle() {
        return IdeBundle.message("step.title.launcher.script", new Object[0]);
    }

    @Override
    protected String getHTMLHeader() {
        return IdeBundle.message("label.create.launcher.script", new Object[0]);
    }

    @Override
    protected String getHTMLFooter() {
        return IdeBundle.message("label.launcher.script.can.be.created.later.via.tools.create.command.line.launcher", new Object[0]);
    }
}

