/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.customize.PluginGroups;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class IdSet {
    private static final List<String> BLACK_LIST = Arrays.asList("Support", "support", "Integration", "integration");
    String myTitle;
    List<PluginId> myIds;

    IdSet(PluginGroups pluginGroups, String description) {
        int i = description.indexOf(":");
        if (i > 0) {
            this.myTitle = description.substring(0, i);
            description = description.substring(i + 1);
        }
        this.myIds = ContainerUtil.map(description.split(","), it -> PluginId.getId(it));
        this.myIds = ContainerUtil.filter(this.myIds, id2 -> pluginGroups.findPlugin((PluginId)id2) != null);
        if (this.myIds.size() > 1 && this.myTitle == null) {
            throw new IllegalArgumentException("There is no common title for " + this.myIds.size() + " ids: " + description);
        }
        if (this.myTitle == null && this.myIds.size() > 0) {
            this.myTitle = pluginGroups.findPlugin(this.myIds.get(0)).getName();
        }
        if (this.myIds.isEmpty() && this.myTitle != null) {
            this.myTitle = null;
        }
        if (this.myTitle != null) {
            for (String skipWord : BLACK_LIST) {
                this.myTitle = this.myTitle.replaceAll(skipWord, "");
            }
            this.myTitle = this.myTitle.replaceAll("  ", " ").trim();
        }
    }

    public String toString() {
        return this.myTitle + ": " + (this.myIds != null ? this.myIds.size() : 0);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public List<PluginId> getIds() {
        return this.myIds;
    }
}

