/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.Icon;

public enum DirDiffOperation {
    COPY_TO,
    COPY_FROM,
    MERGE,
    EQUAL,
    NONE,
    DELETE;


    public Icon getIcon() {
        switch (this) {
            case COPY_TO: {
                return AllIcons.Vcs.Arrow_right;
            }
            case COPY_FROM: {
                return AllIcons.Vcs.Arrow_left;
            }
            case MERGE: {
                return AllIcons.Vcs.Not_equal;
            }
            case EQUAL: {
                return AllIcons.Vcs.Equal;
            }
            case DELETE: {
                return AllIcons.Vcs.Remove;
            }
        }
        return JBUI.scale(EmptyIcon.create(16));
    }

    public Color getTextColor() {
        switch (this) {
            case COPY_TO: 
            case COPY_FROM: {
                return FileStatus.ADDED.getColor();
            }
            case MERGE: {
                return FileStatus.MODIFIED.getColor();
            }
            case DELETE: {
                return FileStatus.DELETED.getColor();
            }
        }
        return JBColor.foreground();
    }
}

