/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileDiffElement
extends DiffElement<VirtualFile> {
    private final VirtualFile myFile;

    public VirtualFileDiffElement(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
    }

    @Override
    public String getPath() {
        return this.myFile.getPresentableUrl();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getPresentablePath() {
        return this.getPath();
    }

    @Override
    public long getSize() {
        return this.myFile.getLength();
    }

    @Override
    public long getTimeStamp() {
        return this.myFile.getTimeStamp();
    }

    @Override
    public boolean isContainer() {
        return this.myFile.isDirectory();
    }

    @Override
    @Nullable
    public Navigatable getNavigatable(@Nullable Project project2) {
        if (project2 == null || project2.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(project2, this.myFile);
    }

    public VirtualFileDiffElement[] getChildren() {
        if (this.myFile.is(VFileProperty.SYMLINK)) {
            return new VirtualFileDiffElement[0];
        }
        VirtualFile[] files2 = this.myFile.getChildren();
        ArrayList<VirtualFileDiffElement> elements2 = new ArrayList<VirtualFileDiffElement>();
        for (VirtualFile file2 : files2) {
            if (FileTypeManager.getInstance().isFileIgnored(file2) || !file2.isValid()) continue;
            elements2.add(new VirtualFileDiffElement(file2));
        }
        return elements2.toArray(new VirtualFileDiffElement[0]);
    }

    @Override
    public byte @Nullable [] getContent() throws IOException {
        return ReadAction.compute(() -> this.myFile.contentsToByteArray());
    }

    @Override
    @Nullable
    public InputStream getContentStream() throws IOException {
        return DiffUtil.getFileInputStream(this.myFile);
    }

    @Override
    public VirtualFile getValue() {
        return this.myFile;
    }

    @Override
    public Icon getIcon() {
        return this.isContainer() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile);
    }

    @Override
    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project2) {
        return () -> {
            FileChooserDescriptor descriptor2 = this.getChooserDescriptor();
            VirtualFile[] result2 = FileChooser.chooseFiles(descriptor2, project2, this.getValue());
            return result2.length == 1 ? VirtualFileDiffElement.createElement(result2[0]) : null;
        };
    }

    @NotNull
    public static VirtualFileDiffElement createElement(VirtualFile file2) {
        VirtualFile jar;
        if (file2.getFileType() instanceof ArchiveFileType && file2.getFileSystem() != JarFileSystem.getInstance() && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null) {
            return new VirtualFileDiffElement(jar);
        }
        return new VirtualFileDiffElement(file2);
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, false){

            @Override
            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return file2.isDirectory() || file2.getFileType() instanceof ArchiveFileType;
            }
        };
    }

    @Override
    public boolean isOperationsEnabled() {
        return this.myFile.getFileSystem() instanceof LocalFileSystem;
    }

    @Override
    @NotNull
    public Charset getCharset() {
        Charset charset = this.myFile.getCharset();
        if (charset == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(2);
        }
        return charset;
    }

    @Override
    public FileType getFileType() {
        return this.myFile.getFileType();
    }

    public VirtualFileDiffElement copyTo(DiffElement<VirtualFile> container2, String relativePath) {
        try {
            File src = new File(this.myFile.getPath());
            File trg = new File(container2.getValue().getPath() + relativePath + src.getName());
            FileUtil.copy(src, trg);
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(trg);
            if (virtualFile2 != null) {
                return new VirtualFileDiffElement(virtualFile2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean delete() {
        try {
            this.myFile.delete(this);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void refresh(boolean userInitiated) {
        VirtualFileDiffElement.refreshFile(userInitiated, this.myFile);
    }

    public static void refreshFile(boolean userInitiated, VirtualFile virtualFile2) {
        if (userInitiated) {
            ArrayList<Document> docsToSave = new ArrayList<Document>();
            FileDocumentManager manager = FileDocumentManager.getInstance();
            for (Document document : manager.getUnsavedDocuments()) {
                VirtualFile file2 = manager.getFile(document);
                if (file2 == null || !VfsUtilCore.isAncestor(virtualFile2, file2, false)) continue;
                docsToSave.add(document);
            }
            if (!docsToSave.isEmpty()) {
                WriteAction.runAndWait(() -> {
                    for (Document document : docsToSave) {
                        manager.saveDocument(document);
                    }
                });
            }
            ModalityState modalityState = ProgressManager.getInstance().getProgressIndicator().getModalityState();
            VfsUtil.markDirty(true, true, virtualFile2);
            RefreshQueue.getInstance().refresh(false, true, null, modalityState, virtualFile2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/diff/VirtualFileDiffElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/diff/VirtualFileDiffElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

