/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropActionHandler;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDSupportBuilder;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDSupport
implements DnDTarget,
DnDSource,
DnDDropHandler.WithResult,
Disposable {
    private final JComponent myComponent;
    private final Function<? super DnDActionInfo, ? extends DnDDragStartBean> myBeanProvider;
    private final Function<? super DnDActionInfo, ? extends DnDImage> myImageProvider;
    @Nullable
    private final DnDDropHandler.WithResult myHandler;
    @Nullable
    private final DnDTargetChecker myChecker;
    private final Runnable myDropEndedCallback;
    private final DnDDropActionHandler myDropActionHandler;
    private final Runnable myCleanUpCallback;
    private final boolean myAsTarget;
    private final boolean myAsSource;

    private DnDSupport(JComponent component2, Function<? super DnDActionInfo, ? extends DnDDragStartBean> beanProvider, Function<? super DnDActionInfo, ? extends DnDImage> imageProvider, DnDDropHandler.WithResult handler2, DnDTargetChecker checker, Runnable dropEndedCallback, Disposable parent, DnDDropActionHandler dropActionHandler, Runnable cleanUpCallback, boolean asTarget, boolean asSource, boolean asNativeTarget) {
        this.myComponent = component2;
        this.myBeanProvider = beanProvider;
        this.myImageProvider = imageProvider;
        this.myHandler = handler2;
        this.myChecker = checker;
        this.myDropEndedCallback = dropEndedCallback;
        this.myDropActionHandler = dropActionHandler;
        this.myCleanUpCallback = cleanUpCallback;
        this.myAsTarget = asTarget;
        this.myAsSource = asSource;
        if (this.myAsTarget) {
            DnDManager.getInstance().registerTarget(asNativeTarget ? new DnDNativeTargetWrapper(this) : this, this.myComponent);
        }
        if (this.myAsSource) {
            DnDManager.getInstance().registerSource(this, this.myComponent);
        }
        if (parent != null) {
            Disposer.register(parent, this);
        }
    }

    @Override
    public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
        return this.myBeanProvider != null && this.myAsSource && this.myBeanProvider.fun(new DnDActionInfo(action2, dragOrigin)) != null;
    }

    @Override
    public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
        return this.myBeanProvider.fun(new DnDActionInfo(action2, dragOrigin));
    }

    @Override
    public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin) {
        DnDImage image;
        if (this.myImageProvider != null && (image = this.myImageProvider.fun(new DnDActionInfo(action2, dragOrigin))) != null) {
            Point point = image.getPoint();
            return Pair.create(image.getImage(), point == null ? dragOrigin : point);
        }
        return null;
    }

    @Override
    public void dragDropEnd() {
        if (this.myDropEndedCallback != null) {
            this.myDropEndedCallback.run();
        }
    }

    @Override
    public void dropActionChanged(int gestureModifiers) {
        if (this.myDropActionHandler != null) {
            this.myDropActionHandler.dropActionChanged(gestureModifiers);
        }
    }

    @Override
    public boolean update(DnDEvent event) {
        if (this.myChecker == null) {
            event.setDropPossible(true);
            return false;
        }
        return this.myChecker.update(event);
    }

    @Override
    public boolean possiblyDrop(DnDEvent aEvent) {
        return this.myHandler == null || this.myHandler.possiblyDrop(aEvent);
    }

    @Override
    public void cleanUpOnLeave() {
        if (this.myCleanUpCallback != null) {
            this.myCleanUpCallback.run();
        }
    }

    @Override
    public void dispose() {
        if (this.myAsSource) {
            DnDManager.getInstance().unregisterSource(this, this.myComponent);
        }
        if (this.myAsTarget) {
            DnDManager.getInstance().unregisterTarget(this, this.myComponent);
        }
    }

    @NotNull
    public static DnDSupportBuilder createBuilder(@NotNull JComponent component2) {
        if (component2 == null) {
            DnDSupport.$$$reportNull$$$0(0);
        }
        final JComponent myComponent = component2;
        final Ref<Boolean> asTarget = Ref.create(true);
        final Ref<Boolean> asSource = Ref.create(true);
        final Ref<Boolean> asNativeTarget = Ref.create(false);
        final Ref<Object> imageProvider = Ref.create(null);
        final Ref<Object> beanProvider = Ref.create(null);
        final Ref<Object> dropEnded = Ref.create(null);
        final Ref<Object> disposable2 = Ref.create(null);
        final Ref<Object> dropHandler = Ref.create(null);
        final Ref<Object> targetChecker = Ref.create(null);
        final Ref<Object> dropActionHandler = Ref.create(null);
        final Ref<Object> cleanUp = Ref.create(null);
        return new DnDSupportBuilder(){

            @Override
            public DnDSupportBuilder disableAsTarget() {
                asTarget.set(false);
                return this;
            }

            @Override
            public DnDSupportBuilder disableAsSource() {
                asSource.set(false);
                return this;
            }

            @Override
            public DnDSupportBuilder enableAsNativeTarget() {
                asNativeTarget.set(true);
                return this;
            }

            @Override
            public DnDSupportBuilder setImageProvider(Function<DnDActionInfo, DnDImage> fun) {
                imageProvider.set(fun);
                return this;
            }

            @Override
            public DnDSupportBuilder setBeanProvider(Function<DnDActionInfo, DnDDragStartBean> fun) {
                beanProvider.set(fun);
                return this;
            }

            @Override
            public DnDSupportBuilder setDropHandler(DnDDropHandler handler2) {
                dropHandler.set(e -> {
                    handler2.drop(e);
                    return true;
                });
                return this;
            }

            @Override
            public DnDSupportBuilder setDropHandlerWithResult(DnDDropHandler.WithResult handler2) {
                dropHandler.set(handler2);
                return this;
            }

            @Override
            public DnDSupportBuilder setTargetChecker(DnDTargetChecker checker) {
                targetChecker.set(checker);
                return this;
            }

            @Override
            public DnDSupportBuilder setDropActionHandler(DnDDropActionHandler handler2) {
                dropActionHandler.set(handler2);
                return this;
            }

            @Override
            public DnDSupportBuilder setDisposableParent(Disposable parent) {
                disposable2.set(parent);
                return this;
            }

            @Override
            public DnDSupportBuilder setCleanUpOnLeaveCallback(Runnable callback2) {
                cleanUp.set(callback2);
                return this;
            }

            @Override
            public DnDSupportBuilder setDropEndedCallback(Runnable callback2) {
                dropEnded.set(callback2);
                return this;
            }

            @Override
            public void install() {
                new DnDSupport(myComponent, (Function)beanProvider.get(), (Function)imageProvider.get(), (DnDDropHandler.WithResult)dropHandler.get(), (DnDTargetChecker)targetChecker.get(), (Runnable)dropEnded.get(), (Disposable)disposable2.get(), (DnDDropActionHandler)dropActionHandler.get(), (Runnable)cleanUp.get(), (Boolean)asTarget.get(), (Boolean)asSource.get(), (Boolean)asNativeTarget.get());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/dnd/DnDSupport", "createBuilder"));
    }

    private static class DnDNativeTargetWrapper
    implements DnDNativeTarget,
    DnDDropHandler.WithResult {
        @NotNull
        private final DnDSupport myTarget;

        private DnDNativeTargetWrapper(@NotNull DnDSupport target2) {
            if (target2 == null) {
                DnDNativeTargetWrapper.$$$reportNull$$$0(0);
            }
            this.myTarget = target2;
        }

        @Override
        public void cleanUpOnLeave() {
            this.myTarget.cleanUpOnLeave();
        }

        @Override
        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            this.myTarget.updateDraggedImage(image, dropPoint, imageOffset);
        }

        @Override
        public boolean possiblyDrop(DnDEvent event) {
            return this.myTarget.possiblyDrop(event);
        }

        @Override
        public boolean update(DnDEvent event) {
            return this.myTarget.update(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ide/dnd/DnDSupport$DnDNativeTargetWrapper", "<init>"));
        }
    }
}

