/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class SmoothAutoScroller {
    @ApiStatus.Experimental
    public static final Key<Boolean> ENABLED = Key.create("SmoothAutoScroller enabled");

    @ApiStatus.Experimental
    @NotNull
    public static DropTargetListener getSharedListener() {
        DropTargetListener dropTargetListener = ScrollListener.SHARED;
        if (dropTargetListener == null) {
            SmoothAutoScroller.$$$reportNull$$$0(0);
        }
        return dropTargetListener;
    }

    @ApiStatus.Experimental
    public static void installDropTargetAsNecessary(@NotNull JComponent component2) {
        if (component2 == null) {
            SmoothAutoScroller.$$$reportNull$$$0(1);
        }
        if (component2 instanceof Autoscroll) {
            return;
        }
        component2.putClientProperty(ENABLED, true);
        component2.setAutoscrolls(false);
        DropTarget target2 = component2.getDropTarget();
        if (target2 == null && !GraphicsEnvironment.isHeadless()) {
            component2.setDropTarget(new DropTarget(component2, 0x40000003, DragListener.SHARED));
        }
    }

    private static JComponent getComponent(DropTargetDragEvent event) {
        JComponent component2;
        if (event == null) {
            return null;
        }
        Component source = event.getDropTargetContext().getComponent();
        JComponent jComponent = component2 = source instanceof JComponent ? (JComponent)source : null;
        if (component2 == null) {
            return null;
        }
        if (component2 instanceof Autoscroll) {
            return null;
        }
        if (component2.getAutoscrolls()) {
            return null;
        }
        if (!component2.isShowing()) {
            return null;
        }
        return UIUtil.isClientPropertyTrue(component2, ENABLED) ? component2 : null;
    }

    private static int getDelta(int count, int margin, int value2, int min, int max) {
        int offset;
        if (value2 < (min += (offset = Math.min(count * margin, (max - min) / 2)))) {
            double delta = (double)(min - value2) / (double)margin;
            return (double)count < delta ? 0 : -((int)Math.floor(delta * delta));
        }
        if (value2 > (max -= offset)) {
            double delta = (double)(value2 - max) / (double)margin;
            return (double)count < delta ? 0 : (int)Math.floor(delta * delta);
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/SmoothAutoScroller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/SmoothAutoScroller";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installDropTargetAsNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ScrollListener
    implements DropTargetListener {
        private static final Logger LOG = Logger.getInstance(SmoothAutoScroller.class);
        private static final DropTargetListener SHARED = new ScrollListener();
        private DropTargetDragEvent event;
        private final Point screen = new Point();
        private final Timer timer = TimerUtil.createNamedTimer("SmoothAutoScroller timer", 10, e -> {
            if (!this.validate(this.event)) {
                this.update(null);
            }
        });

        private ScrollListener() {
            LOG.debug("SmoothAutoScroller created");
        }

        private void update(DropTargetDragEvent event) {
            JComponent component2 = SmoothAutoScroller.getComponent(event);
            if (component2 != null) {
                Point location2 = new Point(event.getLocation());
                SwingUtilities.convertPointToScreen(location2, component2);
                Window window = UIUtil.getWindow(component2);
                if (window != null) {
                    window.toFront();
                }
                this.screen.setLocation(location2);
                this.event = event;
                if (!this.timer.isRunning()) {
                    LOG.debug("SmoothAutoScroller started");
                    this.timer.start();
                }
            } else {
                this.event = null;
                if (this.timer.isRunning()) {
                    LOG.debug("SmoothAutoScroller stopped");
                    this.timer.stop();
                }
            }
        }

        private boolean validate(DropTargetDragEvent event) {
            DropTarget target2;
            JComponent component2 = SmoothAutoScroller.getComponent(event);
            if (component2 == null) {
                return false;
            }
            Point location2 = new Point(this.screen);
            SwingUtilities.convertPointFromScreen(location2, component2);
            Rectangle bounds2 = component2.getVisibleRect();
            if (!bounds2.contains(location2.x, location2.y)) {
                return false;
            }
            int margin = (int)(5.0f * JBUIScale.sysScale(component2));
            int deltaX = SmoothAutoScroller.getDelta(3, margin, location2.x, bounds2.x, bounds2.x + bounds2.width);
            int deltaY = SmoothAutoScroller.getDelta(5, margin, location2.y, bounds2.y, bounds2.y + bounds2.height);
            if (deltaX != 0 || deltaY != 0) {
                LOG.debug("SmoothAutoScroller delta X:", deltaX, " Y:", deltaY);
                bounds2.x += deltaX;
                bounds2.y += deltaY;
                SwingUtilities.convertPointToScreen(location2, component2);
                component2.scrollRectToVisible(bounds2);
                SwingUtilities.convertPointFromScreen(location2, component2);
            }
            if ((target2 = component2.getDropTarget()) != null && !location2.equals(event.getLocation())) {
                LOG.debug("SmoothAutoScroller simulates dragOver");
                target2.dragOver(new DropTargetDragEvent(event.getDropTargetContext(), location2, event.getDropAction(), event.getSourceActions()));
            }
            return true;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            this.update(event);
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            this.update(event);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            this.update(event);
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            this.update(null);
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            this.update(null);
        }
    }

    private static final class DragListener
    implements DropTargetListener {
        public static final int ACTION = 0x40000003;
        private static final DropTargetListener SHARED = new DragListener();
        private final DropTargetListener listener;

        private DragListener() {
            try {
                this.listener = (DropTargetListener)ReflectionUtil.getDeclaredMethod(TransferHandler.class, "getDropTargetListener", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                throw new InternalError("Unexpected JDK: " + SystemInfo.JAVA_VERSION, exception);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            SmoothAutoScroller.getSharedListener().dragEnter(event);
            ReflectionUtil.setField(this.listener.getClass(), this.listener, Object.class, "state", null);
            ReflectionUtil.setField(this.listener.getClass(), this.listener, Component.class, "component", event.getDropTargetContext().getComponent());
            this.listener.dropActionChanged(event);
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            SmoothAutoScroller.getSharedListener().dragOver(event);
            this.listener.dropActionChanged(event);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            SmoothAutoScroller.getSharedListener().dropActionChanged(event);
            this.listener.dropActionChanged(event);
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            SmoothAutoScroller.getSharedListener().dragExit(event);
            this.listener.dragExit(event);
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            SmoothAutoScroller.getSharedListener().drop(event);
            this.listener.drop(event);
        }
    }
}

