/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.CallingBackColoredTreeCellRenderer;
import com.intellij.ide.errorTreeView.EditableMessageElement;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeEditor
extends AbstractCellEditor
implements TreeCellEditor,
MouseMotionListener {
    private final MyWrapperEditor myWrapperEditor;
    private final CallingBackColoredTreeCellRenderer myColoredTreeCellRenderer;
    private final CellEditorDelegate myRightCellRenderer;
    private final JTree myTree;

    public static void install(Tree tree) {
        NewErrorTreeEditor treeEditor = new NewErrorTreeEditor(tree);
        tree.setCellEditor(treeEditor);
        tree.addMouseMotionListener(treeEditor);
        tree.setEditable(true);
    }

    private NewErrorTreeEditor(JTree tree) {
        this.myTree = tree;
        this.myRightCellRenderer = new CellEditorDelegate();
        this.myColoredTreeCellRenderer = new CallingBackColoredTreeCellRenderer();
        this.myWrapperEditor = new MyWrapperEditor(this.myColoredTreeCellRenderer, this.myRightCellRenderer);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        Object node;
        if (e instanceof MouseEvent) {
            Point point = ((MouseEvent)e).getPoint();
            TreePath location2 = this.myTree.getClosestPathForLocation(point.x, point.y);
            node = location2.getLastPathComponent();
        } else {
            node = this.myTree.getLastSelectedPathComponent();
        }
        ErrorTreeElement element2 = NewErrorTreeEditor.getElement(node);
        return element2 instanceof EditableMessageElement;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row) {
        ErrorTreeElement element2 = NewErrorTreeEditor.getElement(value2);
        if (element2 instanceof EditableMessageElement) {
            EditableMessageElement editableMessageElement = (EditableMessageElement)((Object)element2);
            CustomizeColoredTreeCellRenderer leftSelfRenderer = editableMessageElement.getLeftSelfRenderer();
            TreeCellEditor rightSelfEditor = editableMessageElement.getRightSelfEditor();
            this.myColoredTreeCellRenderer.setCurrentCallback(leftSelfRenderer);
            this.myRightCellRenderer.setCurrentCallback(rightSelfEditor);
            return this.myWrapperEditor.getTreeCellEditorComponent(tree, value2, selected2, expanded, leaf, row);
        }
        return this.myTree.getCellRenderer().getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, true);
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ErrorTreeElement element2;
        TreePath treePath;
        JTree tree = (JTree)e.getSource();
        int selRow = tree.getRowForLocation(e.getX(), e.getY());
        if (selRow != -1 && (treePath = tree.getPathForRow(selRow)) != null && treePath != tree.getEditingPath() && (element2 = NewErrorTreeEditor.getElement(treePath.getLastPathComponent())) instanceof EditableMessageElement && ((EditableMessageElement)((Object)element2)).startEditingOnMouseMove()) {
            if (!tree.isRowSelected(selRow)) {
                tree.setSelectionRow(selRow);
            }
            tree.startEditingAtPath(treePath);
        }
    }

    @Nullable
    private static ErrorTreeElement getElement(@Nullable Object value2) {
        if (!(value2 instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
        if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
            return null;
        }
        return ((ErrorTreeNodeDescriptor)userObject).getElement();
    }

    private static class CellEditorDelegate
    extends AbstractCellEditor
    implements TreeCellEditor {
        private TreeCellEditor myCurrentCallback;

        private CellEditorDelegate() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row) {
            return this.myCurrentCallback.getTreeCellEditorComponent(tree, value2, selected2, expanded, leaf, row);
        }

        public void setCurrentCallback(TreeCellEditor currentCallback) {
            this.myCurrentCallback = currentCallback;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private static class MyWrapperEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeCellRenderer myLeft;
        private final TreeCellEditor myRight;
        private final JPanel myPanel;

        public TreeCellRenderer getLeft() {
            return this.myLeft;
        }

        public TreeCellEditor getRight() {
            return this.myRight;
        }

        MyWrapperEditor(TreeCellRenderer left, TreeCellEditor right) {
            this.myLeft = left;
            this.myRight = right;
            this.myPanel = new JPanel(new BorderLayout());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row) {
            this.myPanel.removeAll();
            this.myPanel.add(this.myLeft.getTreeCellRendererComponent(tree, value2, false, expanded, leaf, row, true), "West");
            this.myPanel.add(this.myRight.getTreeCellEditorComponent(tree, value2, selected2, expanded, leaf, row), "East");
            if (UIUtil.isFullRowSelectionLAF()) {
                this.myPanel.setBackground(selected2 ? UIUtil.getTreeSelectionBackground() : null);
            } else if (WideSelectionTreeUI.isWideSelection(tree)) {
                if (selected2) {
                    this.myPanel.setBackground(UIUtil.getTreeSelectionBackground());
                }
            } else if (selected2) {
                this.myPanel.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.myPanel.setBackground(null);
            }
            if (value2 instanceof LoadingNode) {
                this.myPanel.setForeground(JBColor.GRAY);
            } else {
                this.myPanel.setForeground(RenderingUtil.getForeground(tree));
            }
            if (WideSelectionTreeUI.isWideSelection(tree)) {
                this.myPanel.setOpaque(false);
            }
            return this.myPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

