/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FavoriteTreeNodeDescriptor
extends PresentableNodeDescriptor<AbstractTreeNode<?>> {
    private final AbstractTreeNode<?> myElement;
    public static final FavoriteTreeNodeDescriptor[] EMPTY_ARRAY = new FavoriteTreeNodeDescriptor[0];

    public FavoriteTreeNodeDescriptor(@NotNull Project project2, NodeDescriptor parentDescriptor, AbstractTreeNode element2) {
        if (project2 == null) {
            FavoriteTreeNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(project2, parentDescriptor);
        this.myElement = element2;
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            FavoriteTreeNodeDescriptor.$$$reportNull$$$0(1);
        }
        this.myElement.update();
        presentation.copyFrom((PresentationData)this.myElement.getPresentation());
    }

    @Nullable
    public String getLocation() {
        return FavoriteTreeNodeDescriptor.getLocation(this.myElement, this.myProject);
    }

    @Nullable
    public static String getLocation(@NotNull AbstractTreeNode<?> element2, @NotNull Project project2) {
        FavoriteNodeProvider[] nodeProviders;
        Object nodeElement;
        if (element2 == null) {
            FavoriteTreeNodeDescriptor.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            FavoriteTreeNodeDescriptor.$$$reportNull$$$0(3);
        }
        if ((nodeElement = element2.getValue()) instanceof SmartPsiElementPointer) {
            nodeElement = ((SmartPsiElementPointer)nodeElement).getElement();
        }
        if (nodeElement instanceof PsiElement) {
            if (nodeElement instanceof PsiDirectory) {
                return VfsUtilCore.getRelativeLocation(((PsiDirectory)nodeElement).getVirtualFile(), project2.getBaseDir());
            }
            if (nodeElement instanceof PsiFile) {
                PsiFile containingFile = (PsiFile)nodeElement;
                return VfsUtilCore.getRelativeLocation(containingFile.getVirtualFile(), project2.getBaseDir());
            }
        }
        if (nodeElement instanceof LibraryGroupElement) {
            return ((LibraryGroupElement)nodeElement).getModule().getName();
        }
        if (nodeElement instanceof NamedLibraryElement) {
            NamedLibraryElement namedLibraryElement = (NamedLibraryElement)nodeElement;
            Module module2 = namedLibraryElement.getModule();
            return (module2 != null ? module2.getName() : "") + ":" + namedLibraryElement.getOrderEntry().getPresentableName();
        }
        if (nodeElement instanceof File) {
            return VfsUtilCore.getRelativeLocation(VfsUtil.findFileByIoFile((File)nodeElement, false), project2.getBaseDir());
        }
        for (FavoriteNodeProvider provider : nodeProviders = FavoriteNodeProvider.EP_NAME.getExtensions(project2)) {
            String location2 = provider.getElementLocation(nodeElement);
            if (location2 == null) continue;
            return location2;
        }
        return null;
    }

    @Override
    public AbstractTreeNode getElement() {
        return this.myElement;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FavoriteTreeNodeDescriptor)) {
            return false;
        }
        return ((FavoriteTreeNodeDescriptor)object).getElement().equals(this.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @Nullable
    public FavoriteTreeNodeDescriptor getFavoritesRoot() {
        FavoriteTreeNodeDescriptor descriptor2 = this;
        while (descriptor2 != null && descriptor2.getParentDescriptor() instanceof FavoriteTreeNodeDescriptor) {
            FavoriteTreeNodeDescriptor parent = (FavoriteTreeNodeDescriptor)descriptor2.getParentDescriptor();
            if (parent != null && parent.getParentDescriptor() == null) {
                return descriptor2;
            }
            descriptor2 = parent;
        }
        return descriptor2;
    }

    @Override
    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return this.myElement.getChildToHighlightAt(index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoriteTreeNodeDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

