/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FavoritesListNode
extends AbstractTreeNode<String> {
    private static final Logger LOGGER = Logger.getInstance(FavoritesListNode.class);
    private final Project myProject;
    private final String myDescription;

    public FavoritesListNode(Project project2, @NotNull String listName, String description) {
        if (listName == null) {
            FavoritesListNode.$$$reportNull$$$0(0);
        }
        super(project2, listName);
        this.myProject = project2;
        this.myName = listName;
        this.myDescription = description;
    }

    public FavoritesListNode(Project project2, @NotNull String listName) {
        if (listName == null) {
            FavoritesListNode.$$$reportNull$$$0(1);
        }
        this(project2, listName, null);
    }

    public FavoritesListProvider getProvider() {
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        return FavoritesListNode.getFavoritesRoots(this.myProject, this.myName, this);
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            FavoritesListNode.$$$reportNull$$$0(2);
        }
        presentation.setIcon(AllIcons.Toolwindows.ToolWindowFavorites);
        presentation.setPresentableText(this.myName);
        presentation.setLocationString(this.myDescription);
    }

    @NotNull
    public static Collection<AbstractTreeNode<?>> getFavoritesRoots(Project project2, String listName, FavoritesListNode listNode) {
        List<TreeItem<Pair<AbstractUrl, String>>> pairs = FavoritesManager.getInstance(project2).getFavoritesListRootUrls(listName);
        if (pairs.isEmpty()) {
            List<AbstractTreeNode<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                FavoritesListNode.$$$reportNull$$$0(3);
            }
            return list2;
        }
        return FavoritesListNode.createFavoriteRoots(project2, pairs, listNode);
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> createFavoriteRoots(Project project2, @NotNull Collection<? extends TreeItem<Pair<AbstractUrl, String>>> urls, AbstractTreeNode<?> me) {
        if (urls == null) {
            FavoritesListNode.$$$reportNull$$$0(4);
        }
        ArrayList result2 = new ArrayList();
        FavoritesListNode.processUrls(project2, urls, result2, me);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            FavoritesListNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void processUrls(Project project2, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> urls, Collection<? super AbstractTreeNode<?>> result2, AbstractTreeNode<?> me) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : urls) {
            AbstractUrl abstractUrl = treeItem.getData().getFirst();
            Object[] path2 = abstractUrl.createPath(project2);
            if (path2 == null || path2.length < 1 || path2[0] == null) continue;
            try {
                List<TreeItem<Pair<AbstractUrl, String>>> children2;
                ClassLoader loader;
                if (abstractUrl instanceof AbstractUrlFavoriteAdapter) {
                    FavoriteNodeProvider provider = ((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider();
                    loader = provider.getClass().getClassLoader();
                } else {
                    loader = FavoritesListNode.class.getClassLoader();
                }
                String className = treeItem.getData().getSecond();
                Class<?> nodeClass = loader.loadClass(className);
                AbstractTreeNode<?> node = ProjectViewNode.createTreeNode(nodeClass, project2, path2[path2.length - 1], FavoritesManager.getInstance(project2).getViewSettings());
                node.setParent(me);
                node.setIndex(result2.size());
                result2.add(node);
                if (!(node instanceof ProjectViewNodeWithChildrenList) || (children2 = treeItem.getChildren()) == null || children2.isEmpty()) continue;
                ArrayList childList = new ArrayList();
                FavoritesListNode.processUrls(project2, children2, childList, node);
                for (AbstractTreeNode treeNode : childList) {
                    ((ProjectViewNodeWithChildrenList)node).addChild(treeNode);
                }
            }
            catch (Exception e) {
                LOGGER.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesListNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesListNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoritesRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFavoriteRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFavoriteRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

