/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeUtil {
    public static FavoriteTreeNodeDescriptor @NotNull [] getSelectedNodeDescriptors(DnDAwareTree tree) {
        TreePath[] path2 = tree.getSelectionPaths();
        if (path2 == null) {
            if (FavoriteTreeNodeDescriptor.EMPTY_ARRAY == null) {
                FavoritesTreeUtil.$$$reportNull$$$0(0);
            }
            return FavoriteTreeNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<FavoriteTreeNodeDescriptor> result2 = new ArrayList<FavoriteTreeNodeDescriptor>();
        for (TreePath treePath : path2) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof FavoriteTreeNodeDescriptor)) continue;
            FavoriteTreeNodeDescriptor treeNodeDescriptor = (FavoriteTreeNodeDescriptor)userObject;
            result2.add(treeNodeDescriptor);
        }
        FavoriteTreeNodeDescriptor[] favoriteTreeNodeDescriptorArray = result2.toArray(FavoriteTreeNodeDescriptor.EMPTY_ARRAY);
        if (favoriteTreeNodeDescriptorArray == null) {
            FavoritesTreeUtil.$$$reportNull$$$0(1);
        }
        return favoriteTreeNodeDescriptorArray;
    }

    public static List<AbstractTreeNode<?>> getLogicalPathToSelected(Tree tree) {
        ArrayList result2 = new ArrayList();
        TreePath selectionPath = tree.getSelectionPath();
        return FavoritesTreeUtil.getLogicalPathTo(result2, selectionPath);
    }

    public static List<Integer> getLogicalIndexPathTo(TreePath selectionPath) {
        Object uo;
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        Object component2 = selectionPath.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component2).getUserObject()) instanceof FavoriteTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoriteTreeNodeDescriptor)uo).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode.getIndex());
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    public static List<AbstractTreeNode<?>> getLogicalPathTo(List<AbstractTreeNode<?>> result2, TreePath selectionPath) {
        Object uo;
        Object component2 = selectionPath.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component2).getUserObject()) instanceof FavoriteTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoriteTreeNodeDescriptor)uo).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode);
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static FavoritesListNode extractParentList(FavoriteTreeNodeDescriptor descriptor2) {
        for (AbstractTreeNode current2 = descriptor2.getElement(); current2 != null; current2 = current2.getParent()) {
            if (!(current2 instanceof FavoritesListNode)) continue;
            return (FavoritesListNode)current2;
        }
        return null;
    }

    static FavoritesListProvider getProvider(@NotNull FavoritesManager manager, @NotNull FavoriteTreeNodeDescriptor descriptor2) {
        AbstractTreeNode treeNode;
        if (manager == null) {
            FavoritesTreeUtil.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            FavoritesTreeUtil.$$$reportNull$$$0(3);
        }
        for (treeNode = descriptor2.getElement(); treeNode != null && !(treeNode instanceof FavoritesListNode); treeNode = treeNode.getParent()) {
        }
        if (treeNode != null) {
            String name = (String)((FavoritesListNode)treeNode).getValue();
            return manager.getListProvider(name);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodeDescriptors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

