/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.SelectInManager;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

final class FavoritesViewSelectInTarget
extends SelectInTargetPsiWrapper {
    FavoritesViewSelectInTarget(Project project2) {
        super(project2);
        if (PlatformUtils.isPyCharmEducational()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public String toString() {
        return SelectInManager.getFavorites();
    }

    @Override
    public String getToolWindowId() {
        return SelectInManager.getFavorites();
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile2, boolean requestFocus) {
        FavoritesViewSelectInTarget.select(this.myProject, selector, virtualFile2, requestFocus);
    }

    @Override
    protected void select(PsiElement element2, boolean requestFocus) {
        PsiElement toSelect2 = FavoritesViewSelectInTarget.findElementToSelect(element2, null);
        if (toSelect2 != null) {
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(toSelect2);
            virtualFile2 = BackedVirtualFile.getOriginFileIfBacked(virtualFile2);
            this.select(toSelect2, virtualFile2, requestFocus);
        }
    }

    private static ActionCallback select(@NotNull Project project2, Object toSelect2, VirtualFile virtualFile2, boolean requestFocus) {
        if (project2 == null) {
            FavoritesViewSelectInTarget.$$$reportNull$$$0(0);
        }
        ActionCallback result2 = new ActionCallback();
        ToolWindowManager windowManager = ToolWindowManager.getInstance(project2);
        ToolWindow favoritesToolWindow = windowManager.getToolWindow("Favorites");
        if (favoritesToolWindow != null) {
            Runnable runnable2 = () -> {
                FavoritesTreeViewPanel panel2 = UIUtil.findComponentOfType(favoritesToolWindow.getComponent(), FavoritesTreeViewPanel.class);
                if (panel2 != null) {
                    panel2.selectElement(toSelect2, virtualFile2, requestFocus);
                    result2.setDone();
                }
            };
            if (requestFocus) {
                favoritesToolWindow.activate(runnable2, false);
            } else {
                favoritesToolWindow.show(runnable2);
            }
        }
        return result2;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return FavoritesViewSelectInTarget.findSuitableFavoritesList(file2.getVirtualFile(), this.myProject, null) != null;
    }

    public static String findSuitableFavoritesList(VirtualFile file2, Project project2, String currentSubId) {
        FavoritesManager manager = FavoritesManager.getInstance(project2);
        return manager != null ? manager.getFavoriteListName(currentSubId, file2) : null;
    }

    @Override
    public String getMinorViewId() {
        return "Favorites";
    }

    @Override
    public float getWeight() {
        return 1.01f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesViewSelectInTarget", "select"));
    }
}

