/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import org.jetbrains.annotations.NotNull;

public class UsageProjectTreeNode
extends ProjectViewNodeWithChildrenList<UsageInfo> {
    private final UsagePresentation myUsagePresentation;

    public UsageProjectTreeNode(Project project2, @NotNull UsageInfo usage, ViewSettings viewSettings) {
        if (usage == null) {
            UsageProjectTreeNode.$$$reportNull$$$0(0);
        }
        super(project2, usage, viewSettings);
        UsageInfo2UsageAdapter adapter = new UsageInfo2UsageAdapter(usage);
        this.myUsagePresentation = adapter.getPresentation();
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        UsageInfo info;
        if (file2 == null) {
            UsageProjectTreeNode.$$$reportNull$$$0(1);
        }
        if ((info = (UsageInfo)this.getValue()) == null) {
            return false;
        }
        PsiElement element2 = info.getElement();
        return element2 != null && file2.equals(element2.getContainingFile().getVirtualFile());
    }

    @Override
    public String toString() {
        return this.myUsagePresentation.getPlainText();
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            UsageProjectTreeNode.$$$reportNull$$$0(2);
        }
        presentation.setIcon(this.myUsagePresentation.getIcon());
        presentation.setTooltip(this.myUsagePresentation.getTooltipText());
        TextChunk[] text2 = this.myUsagePresentation.getText();
        UsageProjectTreeNode.updatePresentationWithTextChunks(presentation, text2);
        presentation.setPresentableText(StringUtil.join(text2, chunk -> chunk.getText(), ""));
    }

    public static void updatePresentationWithTextChunks(PresentationData presentation, TextChunk[] text2) {
        for (TextChunk chunk : text2) {
            presentation.addText(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }

    @Override
    public void navigate(boolean requestFocus) {
        UsageViewUtil.navigateTo((UsageInfo)this.getValue(), requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    @Override
    public boolean canNavigateToSource() {
        return ((UsageInfo)this.getValue()).getElement().isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/UsageProjectTreeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

