/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddNewFavoritesListAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            AddNewFavoritesListAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) != null) {
            AddNewFavoritesListAction.doAddNewFavoritesList(project2);
        }
    }

    public static String doAddNewFavoritesList(final Project project2) {
        final FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        String name = Messages.showInputDialog(project2, IdeBundle.message("prompt.input.new.favorites.list.name", new Object[0]), IdeBundle.message("title.add.new.favorites.list", new Object[0]), Messages.getInformationIcon(), AddNewFavoritesListAction.getUniqueName(project2), new InputValidator(){

            @Override
            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            @Override
            public boolean canClose(String inputString) {
                inputString = inputString.trim();
                if (favoritesManager.getAvailableFavoritesListNames().contains(inputString)) {
                    Messages.showErrorDialog(project2, IdeBundle.message("error.favorites.list.already.exists", inputString.trim()), IdeBundle.message("title.unable.to.add.favorites.list", new Object[0]));
                    return false;
                }
                return inputString.length() > 0;
            }
        });
        if (name == null || name.length() == 0) {
            return null;
        }
        favoritesManager.createNewList(name);
        return name;
    }

    private static String getUniqueName(Project project2) {
        List<String> names2 = FavoritesManager.getInstance(project2).getAvailableFavoritesListNames();
        int i = 0;
        String newName;
        while (names2.contains(newName = IdeBundle.message("favorites.list.unnamed", i > 0 ? Integer.valueOf(i) : ""))) {
            ++i;
        }
        return newName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/favoritesTreeView/actions/AddNewFavoritesListAction", "actionPerformed"));
    }
}

