/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTManager {
    private static final Logger LOG = Logger.getInstance(FTManager.class);
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String myName;
    private final boolean myInternal;
    private final Path myTemplatesDir;
    @Nullable
    private final FTManager myOriginal;
    private final Map<String, FileTemplateBase> myTemplates;
    private volatile List<FileTemplateBase> mySortedTemplates;
    private final List<DefaultTemplate> myDefaultTemplates;

    FTManager(@NotNull @NonNls String name, @NotNull Path defaultTemplatesDirName) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(0);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(1);
        }
        this(name, defaultTemplatesDirName, false);
    }

    FTManager(@NotNull @NonNls String name, @NotNull Path defaultTemplatesDirName, boolean internal) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(2);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(3);
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myName = name;
        this.myInternal = internal;
        this.myTemplatesDir = defaultTemplatesDirName;
        this.myOriginal = null;
    }

    FTManager(@NotNull FTManager original) {
        if (original == null) {
            FTManager.$$$reportNull$$$0(4);
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myOriginal = original;
        this.myName = original.getName();
        this.myTemplatesDir = original.myTemplatesDir;
        this.myInternal = original.myInternal;
        this.myTemplates.putAll(original.myTemplates);
        this.myDefaultTemplates.addAll(original.myDefaultTemplates);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FTManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.mySortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            Collections.sort(sorted, (t1, t2) -> t1.getName().compareToIgnoreCase(t2.getName()));
            this.mySortedTemplates = sorted;
        }
        if (includeDisabled) {
            Collection<FileTemplateBase> collection = Collections.unmodifiableCollection(sorted);
            if (collection == null) {
                FTManager.$$$reportNull$$$0(6);
            }
            return collection;
        }
        ArrayList<FileTemplateBase> list2 = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list2.add(template);
        }
        ArrayList<FileTemplateBase> arrayList = list2;
        if (arrayList == null) {
            FTManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    FileTemplateBase getTemplate(@NotNull String templateQname) {
        if (templateQname == null) {
            FTManager.$$$reportNull$$$0(8);
        }
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(9);
        }
        if ((template = this.getTemplates().get(templateName)) != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(@NotNull String name, @NotNull String extension) {
        String qName;
        FileTemplateBase template;
        if (name == null) {
            FTManager.$$$reportNull$$$0(10);
        }
        if (extension == null) {
            FTManager.$$$reportNull$$$0(11);
        }
        if ((template = this.getTemplate(qName = FileTemplateBase.getQualifiedName(name, extension))) == null) {
            template = new CustomFileTemplate(name, extension);
            this.getTemplates().put(qName, template);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        FileTemplateBase fileTemplateBase = template;
        if (fileTemplateBase == null) {
            FTManager.$$$reportNull$$$0(12);
        }
        return fileTemplateBase;
    }

    public void removeTemplate(@NotNull String qName) {
        FileTemplateBase template;
        if (qName == null) {
            FTManager.$$$reportNull$$$0(13);
        }
        if ((template = this.getTemplates().get(qName)) instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    void updateTemplates(@NotNull Collection<? extends FileTemplate> newTemplates) {
        if (newTemplates == null) {
            FTManager.$$$reportNull$$$0(14);
        }
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.myDefaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
        }
        this.saveTemplates(true);
    }

    private void restoreDefaults(@NotNull Set<String> toDisable) {
        if (toDisable == null) {
            FTManager.$$$reportNull$$$0(15);
        }
        this.getTemplates().clear();
        this.mySortedTemplates = null;
        for (DefaultTemplate template : this.myDefaultTemplates) {
            BundledFileTemplate bundled = this.createAndStoreBundledTemplate(template);
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    void setDefaultTemplates(@NotNull Collection<? extends DefaultTemplate> templates) {
        if (templates == null) {
            FTManager.$$$reportNull$$$0(16);
        }
        this.myDefaultTemplates.clear();
        this.myDefaultTemplates.addAll(templates);
        for (DefaultTemplate defaultTemplate : templates) {
            this.createAndStoreBundledTemplate(defaultTemplate);
        }
    }

    @NotNull
    private BundledFileTemplate createAndStoreBundledTemplate(@NotNull DefaultTemplate template) {
        if (template == null) {
            FTManager.$$$reportNull$$$0(17);
        }
        BundledFileTemplate bundled = new BundledFileTemplate(template, this.myInternal);
        String qName = bundled.getQualifiedName();
        FileTemplateBase previous = this.getTemplates().put(qName, bundled);
        this.mySortedTemplates = null;
        LOG.assertTrue(previous == null, "Duplicate bundled template " + qName + " [" + template.getTemplateURL() + ", " + previous + ']');
        BundledFileTemplate bundledFileTemplate = bundled;
        if (bundledFileTemplate == null) {
            FTManager.$$$reportNull$$$0(18);
        }
        return bundledFileTemplate;
    }

    void loadCustomizedContent() {
        ArrayList<Path> templateWithDefaultExtension = new ArrayList<Path>();
        THashSet<String> processedNames = new THashSet<String>();
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(this.getConfigRoot(), file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));){
            for (Path file3 : stream2) {
                String fileName = file3.getFileName().toString();
                if (FileTypeManager.getInstance().isFileIgnored(fileName)) continue;
                if (fileName.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                    templateWithDefaultExtension.add(file3);
                    continue;
                }
                processedNames.add(fileName);
                this.addTemplateFromFile(fileName, file3);
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            LOG.error(e);
            return;
        }
        for (Path file4 : templateWithDefaultExtension) {
            String name = file4.getFileName().toString();
            if (!processedNames.contains(name = name.substring(0, name.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name, file4);
            }
            try {
                Files.delete(file4);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void addTemplateFromFile(@NotNull String fileName, @NotNull Path file2) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            FTManager.$$$reportNull$$$0(20);
        }
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName);
        String extension = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.isEmpty()) {
            return;
        }
        try {
            this.addTemplate(templateQName, extension).setText(PathKt.readText((Path)file2));
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public void saveTemplates() {
        this.saveTemplates(false);
    }

    private void saveTemplates(boolean removeDeleted) {
        THashSet<String> allNames = new THashSet<String>();
        Path configRoot = this.getConfigRoot();
        THashMap<String, Path> templatesOnDisk = new THashMap<String, Path>();
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(this.getConfigRoot(), file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));
            Object object = null;
            try {
                for (Path file3 : stream) {
                    String fileName = file3.getFileName().toString();
                    templatesOnDisk.put(fileName, file3);
                    allNames.add(fileName);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (NoSuchFileException stream) {
        }
        catch (IOException e) {
            LOG.error(e);
        }
        THashMap<String, FileTemplateBase> templatesToSave = new THashMap<String, FileTemplateBase>();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) continue;
            String name = template.getQualifiedName();
            templatesToSave.put(name, template);
            allNames.add(name);
        }
        if (allNames.isEmpty()) {
            return;
        }
        try {
            Files.createDirectories(this.myTemplatesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.info("Cannot create directory: " + this.myTemplatesDir);
        }
        String lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        for (String name : allNames) {
            Path customizedTemplateFile = (Path)templatesOnDisk.get(name);
            FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(name);
            if (customizedTemplateFile == null) {
                try {
                    FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + name, e);
                }
                continue;
            }
            if (templateToSave == null) {
                if (!removeDeleted) continue;
                try {
                    Files.delete(customizedTemplateFile);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
                continue;
            }
            try {
                String templateText;
                String diskText = StringUtilRt.convertLineSeparators(PathKt.readText((Path)customizedTemplateFile));
                if (diskText.equals(templateText = templateToSave.getText())) continue;
                FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
            }
            catch (IOException e) {
                LOG.error("Unable to save template " + name, e);
            }
        }
    }

    private static void saveTemplate(@NotNull Path parentDir, @NotNull FileTemplateBase template, @NotNull String lineSeparator) throws IOException {
        if (parentDir == null) {
            FTManager.$$$reportNull$$$0(21);
        }
        if (template == null) {
            FTManager.$$$reportNull$$$0(22);
        }
        if (lineSeparator == null) {
            FTManager.$$$reportNull$$$0(23);
        }
        Path templateFile = parentDir.resolve(FTManager.encodeFileName(template.getName(), template.getExtension()));
        try (OutputStream fileOutputStream = FTManager.startWriteOrCreate(templateFile);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, StandardCharsets.UTF_8);){
            String content2 = template.getText();
            if (!lineSeparator.equals("\n")) {
                content2 = StringUtilRt.convertLineSeparators(content2, lineSeparator);
            }
            outputStreamWriter.write(content2);
        }
    }

    @NotNull
    private static OutputStream startWriteOrCreate(@NotNull Path templateFile) throws IOException {
        OutputStream outputStream;
        if (templateFile == null) {
            FTManager.$$$reportNull$$$0(24);
        }
        try {
            outputStream = Files.newOutputStream(templateFile, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            PathKt.delete((Path)templateFile);
            OutputStream outputStream2 = Files.newOutputStream(templateFile, new OpenOption[0]);
            if (outputStream2 == null) {
                FTManager.$$$reportNull$$$0(26);
            }
            return outputStream2;
        }
        if (outputStream == null) {
            FTManager.$$$reportNull$$$0(25);
        }
        return outputStream;
    }

    @NotNull
    Path getConfigRoot() {
        Path path2 = this.myTemplatesDir;
        if (path2 == null) {
            FTManager.$$$reportNull$$$0(27);
        }
        return path2;
    }

    public String toString() {
        return this.myName + " file template manager";
    }

    @NotNull
    static String encodeFileName(@NotNull String templateName, @NotNull String extension) {
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(28);
        }
        if (extension == null) {
            FTManager.$$$reportNull$$$0(29);
        }
        String nameExtDelimiter = extension.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        String string = templateName + nameExtDelimiter + extension;
        if (string == null) {
            FTManager.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> decodeFileName(@NotNull String fileName) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(31);
        }
        String name = fileName;
        String ext = "";
        String nameExtDelimiter = fileName.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name = fileName.substring(0, extIndex);
            ext = fileName.substring(extIndex + nameExtDelimiter.length());
        }
        Pair<String, String> pair = Pair.create(name, ext);
        if (pair == null) {
            FTManager.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @NotNull
    public Map<String, FileTemplateBase> getTemplates() {
        Map<String, FileTemplateBase> map2 = this.myOriginal != null ? this.myOriginal.myTemplates : this.myTemplates;
        if (map2 == null) {
            FTManager.$$$reportNull$$$0(33);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplatesDirName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateQname";
                break;
            }
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTemplates";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDisable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemplate";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndStoreBundledTemplate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "startWriteOrCreate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigRoot";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeFileName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeFileName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTemplates";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaults";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultTemplates";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAndStoreBundledTemplate";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateFromFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveTemplate";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "startWriteOrCreate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "encodeFileName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "decodeFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

