/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateHighlighter;
import com.intellij.ide.fileTemplates.impl.FileTemplateTokenType;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.fileTemplates.impl._FileTemplateTextLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateConfigurable
implements Configurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(FileTemplateConfigurable.class);
    @NonNls
    private static final String EMPTY_HTML = "<html></html>";
    private JPanel myMainPanel;
    private FileTemplate myTemplate;
    private Editor myTemplateEditor;
    private JTextField myNameField;
    private JTextField myExtensionField;
    private JCheckBox myAdjustBox;
    private JCheckBox myLiveTemplateBox;
    private JPanel myTopPanel;
    private JEditorPane myDescriptionComponent;
    private boolean myModified;
    private URL myDefaultDescriptionUrl;
    private final Project myProject;
    private final List<ChangeListener> myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Splitter mySplitter;
    private final FileType myVelocityFileType = FileTypeManager.getInstance().getFileTypeByExtension("ft");
    private float myProportion = 0.6f;

    public FileTemplateConfigurable(Project project2) {
        this.myProject = project2;
    }

    public FileTemplate getTemplate() {
        return this.myTemplate;
    }

    public void setTemplate(FileTemplate template, URL defaultDescription) {
        this.myDefaultDescriptionUrl = defaultDescription;
        this.myTemplate = template;
        if (this.myMainPanel != null) {
            this.reset();
            this.myNameField.selectAll();
            this.myExtensionField.selectAll();
        }
    }

    void setShowInternalMessage(String message) {
        this.myTopPanel.removeAll();
        if (message == null) {
            this.myTopPanel.add((Component)new JLabel(IdeBundle.message("label.name", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, JBUI.insetsRight(2), 0, 0));
            this.myTopPanel.add((Component)this.myNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, JBInsets.create(3, 2), 0, 0));
            this.myTopPanel.add((Component)new JLabel(IdeBundle.message("label.extension", new Object[0])), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, JBInsets.create(0, 2), 0, 0));
            this.myTopPanel.add((Component)this.myExtensionField, new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 2, JBUI.insetsLeft(2), 0, 0));
            this.myExtensionField.setColumns(7);
        }
        this.myMainPanel.revalidate();
        this.myTopPanel.repaint();
    }

    void setShowAdjustCheckBox(boolean show2) {
        this.myAdjustBox.setEnabled(show2);
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message("title.edit.file.template", new Object[0]);
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    @Override
    public JComponent createComponent() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myNameField = new JTextField();
        this.myExtensionField = new JTextField();
        this.mySplitter = new Splitter(true, this.myProportion);
        this.myAdjustBox = new JCheckBox(IdeBundle.message("checkbox.reformat.according.to.style", new Object[0]));
        this.myLiveTemplateBox = new JCheckBox(IdeBundle.message("checkbox.enable.live.templates", new Object[0]));
        this.myTemplateEditor = this.createEditor(null);
        this.myDescriptionComponent = new JEditorPane();
        this.myDescriptionComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myDescriptionComponent.setText(EMPTY_HTML);
        this.myDescriptionComponent.setEditable(false);
        this.myDescriptionComponent.addHyperlinkListener(new BrowserHyperlinkListener());
        this.myTopPanel = new JPanel(new GridBagLayout());
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        descriptionPanel.add((Component)new JLabel(IdeBundle.message("label.description", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, JBUI.insetsBottom(2), 0, 0));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myDescriptionComponent), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, JBUI.insetsTop(2), 0, 0));
        this.myMainPanel.add((Component)this.myTopPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, JBUI.emptyInsets(), 0, 0));
        this.myMainPanel.add((Component)this.mySplitter, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, JBUI.emptyInsets(), 0, 0));
        this.mySplitter.setSecondComponent(descriptionPanel);
        this.setShowInternalMessage(null);
        this.myNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTemplateConfigurable.this.onNameChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$1", "focusLost"));
            }
        });
        this.myExtensionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileTemplateConfigurable.this.onNameChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$2", "focusLost"));
            }
        });
        this.myMainPanel.setPreferredSize(JBUI.size(400, 300));
        return this.myMainPanel;
    }

    public void setProportion(float proportion) {
        this.myProportion = proportion;
    }

    private Editor createEditor(@Nullable PsiFile file2) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document doc = this.createDocument(file2, editorFactory);
        Editor editor = editorFactory.createEditor(doc, this.myProject);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(3);
        editorSettings.setAdditionalLinesCount(3);
        editorSettings.setCaretRowShown(false);
        editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileTemplateConfigurable.this.onTextChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$3", "documentChanged"));
            }
        }, ((EditorImpl)editor).getDisposable());
        ((EditorEx)editor).setHighlighter(this.createHighlighter());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel(new HorizontalLayout(40));
        southPanel.add(this.myAdjustBox);
        southPanel.add(this.myLiveTemplateBox);
        topPanel.add((Component)southPanel, "South");
        topPanel.add((Component)editor.getComponent(), "Center");
        this.mySplitter.setFirstComponent(topPanel);
        return editor;
    }

    @NotNull
    private Document createDocument(@Nullable PsiFile file2, @NotNull EditorFactory editorFactory) {
        Document document;
        if (editorFactory == null) {
            FileTemplateConfigurable.$$$reportNull$$$0(0);
        }
        Document document2 = document = file2 != null ? PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2) : null;
        Document document3 = document != null ? document : editorFactory.createDocument(this.myTemplate == null ? "" : this.myTemplate.getText());
        if (document3 == null) {
            FileTemplateConfigurable.$$$reportNull$$$0(1);
        }
        return document3;
    }

    private void onTextChanged() {
        this.myModified = true;
    }

    private void onNameChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            FileTemplateConfigurable.$$$reportNull$$$0(2);
        }
        if (!this.myChangeListeners.contains(listener2)) {
            this.myChangeListeners.add(listener2);
        }
    }

    public void removeChangeListener(ChangeListener listener2) {
        this.myChangeListeners.remove(listener2);
    }

    @Override
    public boolean isModified() {
        String extension;
        if (this.myModified) {
            return true;
        }
        String name = this.myTemplate == null ? "" : this.myTemplate.getName();
        String string = extension = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        if (!Comparing.equal(name, this.myNameField.getText())) {
            return true;
        }
        if (!Comparing.equal(extension, this.myExtensionField.getText())) {
            return true;
        }
        return this.myTemplate != null && (this.myTemplate.isReformatCode() != this.myAdjustBox.isSelected() || this.myTemplate.isLiveTemplateEnabled() != this.myLiveTemplateBox.isSelected());
    }

    @Override
    public void apply() throws ConfigurationException {
        if (this.myTemplate != null) {
            this.myTemplate.setText(this.myTemplateEditor.getDocument().getText());
            String name = this.myNameField.getText();
            String extension = this.myExtensionField.getText();
            String filename = name + "." + extension;
            if (name.length() == 0 || !FileTemplateConfigurable.isValidFilename(filename)) {
                throw new ConfigurationException(IdeBundle.message("error.invalid.template.file.name.or.extension", new Object[0]));
            }
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filename);
            if (fileType == UnknownFileType.INSTANCE) {
                FileTypeChooser.associateFileType(filename);
            }
            this.myTemplate.setName(name);
            this.myTemplate.setExtension(extension);
            this.myTemplate.setReformatCode(this.myAdjustBox.isSelected());
            this.myTemplate.setLiveTemplateEnabled(this.myLiveTemplateBox.isSelected());
        }
        this.myModified = false;
    }

    private static boolean isValidFilename(String filename) {
        if (filename.contains("/") || filename.contains("\\") || filename.contains(":")) {
            return false;
        }
        File tempFile = new File(FileUtil.getTempDirectory() + File.separator + filename);
        return FileUtil.ensureCanCreateFile(tempFile);
    }

    @Override
    public void reset() {
        String description;
        String text2 = this.myTemplate == null ? "" : this.myTemplate.getText();
        String name = this.myTemplate == null ? "" : this.myTemplate.getName();
        String extension = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        String string = description = this.myTemplate == null ? "" : this.myTemplate.getDescription();
        if (description.isEmpty() && this.myDefaultDescriptionUrl != null) {
            try {
                description = UrlUtil.loadText(this.myDefaultDescriptionUrl);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
        this.myTemplateEditor = this.createEditor(this.createFile(text2, name));
        this.myNameField.setText(name);
        this.myExtensionField.setText(extension);
        this.myAdjustBox.setSelected(this.myTemplate != null && this.myTemplate.isReformatCode());
        this.myLiveTemplateBox.setSelected(this.myTemplate != null && this.myTemplate.isLiveTemplateEnabled());
        int i = description.indexOf("<html>");
        if (i > 0) {
            description = description.substring(i);
        }
        description = XmlStringUtil.stripHtml(description);
        description = description.replace("\n", "").replace("\r", "");
        description = XmlStringUtil.stripHtml(description);
        description = description + "<hr> <font face=\"verdana\" size=\"-1\"><a href='http://velocity.apache.org/engine/devel/user-guide.html#Velocity_Template_Language_VTL:_An_Introduction'>\nApache Velocity</a> template language is used</font>";
        this.myDescriptionComponent.setText(description);
        this.myDescriptionComponent.setCaretPosition(0);
        this.myNameField.setEditable(this.myTemplate != null && !this.myTemplate.isDefault());
        this.myExtensionField.setEditable(this.myTemplate != null && !this.myTemplate.isDefault());
        this.myModified = false;
    }

    @Nullable
    private PsiFile createFile(String text2, String name) {
        if (this.myTemplate == null) {
            return null;
        }
        FileType fileType = this.myVelocityFileType;
        if (fileType == FileTypes.UNKNOWN) {
            return null;
        }
        PsiFile file2 = PsiFileFactory.getInstance(this.myProject).createFileFromText(name + ".txt.ft", fileType, (CharSequence)text2, 0L, true);
        file2.getViewProvider().putUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES, FileTemplateManager.getInstance(this.myProject).getDefaultProperties());
        return file2;
    }

    @Override
    public void disposeUIResources() {
        this.myMainPanel = null;
        if (this.myTemplateEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
            this.myTemplateEditor = null;
        }
    }

    private EditorHighlighter createHighlighter() {
        SyntaxHighlighter originalHighlighter;
        if (this.myTemplate != null && this.myVelocityFileType != FileTypes.UNKNOWN) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, new LightVirtualFile("aaa." + this.myTemplate.getExtension() + ".ft"));
        }
        FileType fileType = null;
        if (this.myTemplate != null) {
            fileType = FileTypeManager.getInstance().getFileTypeByExtension(this.myTemplate.getExtension());
        }
        if (fileType == null) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        if ((originalHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, null, null)) == null) {
            originalHighlighter = new PlainSyntaxHighlighter();
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        LayeredLexerEditorHighlighter highlighter = new LayeredLexerEditorHighlighter(new FileTemplateHighlighter(), scheme);
        highlighter.registerLayer(FileTemplateTokenType.TEXT, new LayerDescriptor(originalHighlighter, ""));
        return highlighter;
    }

    @NotNull
    @VisibleForTesting
    public static Lexer createDefaultLexer() {
        return new MergingLexerAdapter(new FlexAdapter(new _FileTemplateTextLexer()), TokenSet.create(FileTemplateTokenType.TEXT));
    }

    public void focusToNameField() {
        this.myNameField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myNameField, true));
    }

    public void focusToExtensionField() {
        this.myExtensionField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myExtensionField, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

