/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateLoadResult;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.project.ProjectKt;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTemplatesLoader {
    private static final Logger LOG = Logger.getInstance(FileTemplatesLoader.class);
    static final String TEMPLATES_DIR = "fileTemplates";
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    private static final String DESCRIPTION_FILE_EXTENSION = "html";
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";
    private final FTManager myDefaultTemplatesManager;
    private final FTManager myInternalTemplatesManager;
    private final FTManager myPatternsManager;
    private final FTManager myCodeTemplatesManager;
    private final FTManager myJ2eeTemplatesManager;
    private final FTManager[] myAllManagers;
    private static final String INTERNAL_DIR = "internal";
    private static final String INCLUDES_DIR = "includes";
    private static final String CODE_TEMPLATES_DIR = "code";
    private static final String J2EE_TEMPLATES_DIR = "j2ee";
    private final URL myDefaultTemplateDescription;
    private final URL myDefaultIncludeDescription;

    FileTemplatesLoader(@Nullable Project project2) {
        Path configDir;
        if (project2 == null || project2.isDefault()) {
            configDir = PathManager.getConfigDir().resolve("fileTemplates");
        } else {
            String storeDirPath = Objects.requireNonNull(ProjectKt.getStateStore(project2).getDirectoryStorePath(true));
            configDir = Paths.get(storeDirPath, "fileTemplates");
        }
        this.myDefaultTemplatesManager = new FTManager("Default", configDir);
        this.myInternalTemplatesManager = new FTManager("Internal", configDir.resolve(INTERNAL_DIR), true);
        this.myPatternsManager = new FTManager("Includes", configDir.resolve(INCLUDES_DIR));
        this.myCodeTemplatesManager = new FTManager("Code", configDir.resolve(CODE_TEMPLATES_DIR));
        this.myJ2eeTemplatesManager = new FTManager("J2EE", configDir.resolve(J2EE_TEMPLATES_DIR));
        this.myAllManagers = new FTManager[]{this.myDefaultTemplatesManager, this.myInternalTemplatesManager, this.myPatternsManager, this.myCodeTemplatesManager, this.myJ2eeTemplatesManager};
        LinkedHashMap<FTManager, String> managerToPrefix = new LinkedHashMap<FTManager, String>();
        for (FTManager manager : this.myAllManagers) {
            Path managerRoot = manager.getConfigRoot();
            String relativePath = configDir.equals(managerRoot) ? "" : FileUtilRt.toSystemIndependentName(configDir.relativize(managerRoot).toString()) + "/";
            managerToPrefix.put(manager, relativePath);
        }
        FileTemplateLoadResult result2 = FileTemplatesLoader.loadDefaultTemplates(new ArrayList<String>(managerToPrefix.values()));
        this.myDefaultTemplateDescription = result2.getDefaultTemplateDescription();
        this.myDefaultIncludeDescription = result2.getDefaultIncludeDescription();
        for (FTManager manager : this.myAllManagers) {
            manager.setDefaultTemplates(result2.getResult().get((String)managerToPrefix.get(manager)));
            manager.loadCustomizedContent();
        }
    }

    FTManager @NotNull [] getAllManagers() {
        if (this.myAllManagers == null) {
            FileTemplatesLoader.$$$reportNull$$$0(0);
        }
        return this.myAllManagers;
    }

    @NotNull
    FTManager getDefaultTemplatesManager() {
        return new FTManager(this.myDefaultTemplatesManager);
    }

    @NotNull
    FTManager getInternalTemplatesManager() {
        return new FTManager(this.myInternalTemplatesManager);
    }

    @NotNull
    FTManager getPatternsManager() {
        return new FTManager(this.myPatternsManager);
    }

    @NotNull
    FTManager getCodeTemplatesManager() {
        return new FTManager(this.myCodeTemplatesManager);
    }

    @NotNull
    FTManager getJ2eeTemplatesManager() {
        return new FTManager(this.myJ2eeTemplatesManager);
    }

    URL getDefaultTemplateDescription() {
        return this.myDefaultTemplateDescription;
    }

    URL getDefaultIncludeDescription() {
        return this.myDefaultIncludeDescription;
    }

    @NotNull
    private static FileTemplateLoadResult loadDefaultTemplates(@NotNull List<String> prefixes) {
        IdeaPluginDescriptor[] plugins2;
        if (prefixes == null) {
            FileTemplatesLoader.$$$reportNull$$$0(1);
        }
        FileTemplateLoadResult result2 = new FileTemplateLoadResult(MultiMap.createSmart());
        THashSet<URL> processedUrls = new THashSet<URL>();
        HashSet<ClassLoader> processedLoaders = new HashSet<ClassLoader>();
        for (IdeaPluginDescriptor plugin : plugins2 = PluginManagerCore.getPlugins()) {
            ClassLoader loader;
            if (!(plugin instanceof IdeaPluginDescriptorImpl) || !plugin.isEnabled() || (loader = plugin.getPluginClassLoader()) instanceof PluginClassLoader && ((PluginClassLoader)loader).getUrls().isEmpty() || !processedLoaders.add(loader)) continue;
            try {
                Enumeration<URL> systemResources = loader.getResources("fileTemplates");
                if (!systemResources.hasMoreElements()) continue;
                while (systemResources.hasMoreElements()) {
                    URL url = systemResources.nextElement();
                    if (!processedUrls.add(url)) continue;
                    FileTemplatesLoader.loadDefaultsFromRoot(url, prefixes, result2);
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        FileTemplateLoadResult fileTemplateLoadResult = result2;
        if (fileTemplateLoadResult == null) {
            FileTemplatesLoader.$$$reportNull$$$0(2);
        }
        return fileTemplateLoadResult;
    }

    private static void loadDefaultsFromRoot(@NotNull URL root, @NotNull List<String> prefixes, @NotNull FileTemplateLoadResult result2) throws IOException {
        List<String> children2;
        if (root == null) {
            FileTemplatesLoader.$$$reportNull$$$0(3);
        }
        if (prefixes == null) {
            FileTemplatesLoader.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            FileTemplatesLoader.$$$reportNull$$$0(5);
        }
        if ((children2 = UrlUtil.getChildrenRelativePaths(root)).isEmpty()) {
            return;
        }
        HashSet<String> descriptionPaths = new HashSet<String>();
        for (String path2 : children2) {
            if (path2.equals("default.html")) {
                result2.setDefaultTemplateDescription(UrlClassLoader.internProtocol(new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path2)));
                continue;
            }
            if (path2.equals("includes/default.html")) {
                result2.setDefaultIncludeDescription(UrlClassLoader.internProtocol(new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path2)));
                continue;
            }
            if (!path2.endsWith(DESCRIPTION_EXTENSION_SUFFIX)) continue;
            descriptionPaths.add(path2);
        }
        block1: for (String path2 : children2) {
            if (!path2.endsWith(".ft")) continue;
            for (String prefix : prefixes) {
                URL descriptionUrl;
                if (!FileTemplatesLoader.matchesPrefix(path2, prefix)) continue;
                String filename = path2.substring(prefix.length(), path2.length() - ".ft".length());
                String extension = FileUtilRt.getExtension(filename);
                String templateName = filename.substring(0, filename.length() - extension.length() - 1);
                URL templateUrl = UrlClassLoader.internProtocol(new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path2));
                String descriptionPath = FileTemplatesLoader.getDescriptionPath(prefix, templateName, extension, descriptionPaths);
                URL uRL = descriptionUrl = descriptionPath == null ? null : UrlClassLoader.internProtocol(new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + descriptionPath));
                assert (templateUrl != null);
                result2.getResult().putValue(prefix, new DefaultTemplate(templateName, extension, templateUrl, descriptionUrl));
                continue block1;
            }
        }
    }

    private static boolean matchesPrefix(@NotNull String path2, @NotNull String prefix) {
        if (path2 == null) {
            FileTemplatesLoader.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            FileTemplatesLoader.$$$reportNull$$$0(7);
        }
        if (prefix.isEmpty()) {
            return path2.indexOf(47) == -1;
        }
        return FileUtil.startsWith(path2, prefix) && path2.indexOf(47, prefix.length()) == -1;
    }

    @Nullable
    private static String getDescriptionPath(@NotNull String pathPrefix, @NotNull String templateName, @NotNull String templateExtension, @NotNull Set<String> descriptionPaths) {
        String descPath;
        if (pathPrefix == null) {
            FileTemplatesLoader.$$$reportNull$$$0(8);
        }
        if (templateName == null) {
            FileTemplatesLoader.$$$reportNull$$$0(9);
        }
        if (templateExtension == null) {
            FileTemplatesLoader.$$$reportNull$$$0(10);
        }
        if (descriptionPaths == null) {
            FileTemplatesLoader.$$$reportNull$$$0(11);
        }
        Locale locale = Locale.getDefault();
        String descName = MessageFormat.format("{0}.{1}_{2}_{3}.html", templateName, templateExtension, locale.getLanguage(), locale.getCountry());
        String string = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = MessageFormat.format("{0}.{1}_{2}.html", templateName, templateExtension, locale.getLanguage());
        String string2 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        String string3 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExtension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllManagers";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadDefaultTemplates";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadDefaultsFromRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchesPrefix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

