/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplatePanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(CreateFromTemplateDialog.class);
    @NotNull
    private final PsiDirectory myDirectory;
    @NotNull
    private final Project myProject;
    private PsiElement myCreatedElement;
    private final CreateFromTemplatePanel myAttrPanel;
    private final JComponent myAttrComponent;
    @NotNull
    private final FileTemplate myTemplate;
    private final Properties myDefaultProperties;

    public CreateFromTemplateDialog(@NotNull Project project2, @NotNull PsiDirectory directory, @NotNull FileTemplate template, @Nullable AttributesDefaults attributesDefaults, @Nullable Properties defaultProperties) {
        if (project2 == null) {
            CreateFromTemplateDialog.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateFromTemplateDialog.$$$reportNull$$$0(1);
        }
        if (template == null) {
            CreateFromTemplateDialog.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.myDirectory = directory;
        this.myProject = project2;
        this.myTemplate = template;
        this.setTitle(IdeBundle.message("title.new.from.template", template.getName()));
        this.myDefaultProperties = defaultProperties == null ? FileTemplateManager.getInstance(project2).getDefaultProperties() : defaultProperties;
        FileTemplateUtil.fillDefaultProperties(this.myDefaultProperties, directory);
        boolean mustEnterName = FileTemplateUtil.findHandler(template).isNameRequired();
        if (attributesDefaults != null && attributesDefaults.isFixedName()) {
            this.myDefaultProperties.setProperty("NAME", attributesDefaults.getDefaultFileName());
            mustEnterName = false;
        }
        String[] unsetAttributes = null;
        try {
            unsetAttributes = this.myTemplate.getUnsetAttributes(this.myDefaultProperties, project2);
        }
        catch (ParseException e) {
            this.showErrorDialog((Exception)((Object)e));
        }
        if (unsetAttributes != null) {
            this.myAttrPanel = new CreateFromTemplatePanel(unsetAttributes, mustEnterName, attributesDefaults);
            this.myAttrComponent = this.myAttrPanel.getComponent();
            this.init();
        } else {
            this.myAttrPanel = null;
            this.myAttrComponent = null;
        }
    }

    public PsiElement create() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doCreate(this.myTemplate.getName() + "." + this.myTemplate.getExtension());
            Disposer.dispose(this.getDisposable());
            return this.myCreatedElement;
        }
        if (this.myAttrPanel != null) {
            if (this.myAttrPanel.hasSomethingToAsk()) {
                this.show();
                return this.myCreatedElement;
            }
            this.doCreate(null);
        }
        this.close(0);
        return this.myCreatedElement;
    }

    @Override
    protected void doOKAction() {
        String fileName = this.myAttrPanel.getFileName();
        if (fileName != null && fileName.length() == 0) {
            Messages.showMessageDialog(this.myAttrComponent, IdeBundle.message("error.please.enter.a.file.name", new Object[0]), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
            return;
        }
        this.doCreate(fileName);
        if (this.myCreatedElement != null) {
            super.doOKAction();
        }
    }

    private void doCreate(@Nullable String fileName) {
        try {
            String newName = fileName;
            PsiDirectory directory = this.myDirectory;
            if (fileName != null) {
                String finalFileName = fileName;
                CreateFileAction.MkDirs mkDirs = WriteAction.compute(() -> new CreateFileAction.MkDirs(finalFileName, this.myDirectory));
                newName = mkDirs.newName;
                directory = mkDirs.directory;
            }
            Properties properties = this.myAttrPanel.getProperties(this.myDefaultProperties);
            this.myCreatedElement = FileTemplateUtil.createFromTemplate(this.myTemplate, newName, properties, directory);
        }
        catch (Exception e) {
            this.showErrorDialog(e);
        }
    }

    public Properties getEnteredProperties() {
        return this.myAttrPanel.getProperties(new Properties());
    }

    private void showErrorDialog(Exception e) {
        LOG.info(e);
        Messages.showMessageDialog(this.myProject, this.filterMessage(e.getMessage()), this.getErrorMessage(), Messages.getErrorIcon());
    }

    private String getErrorMessage() {
        return FileTemplateUtil.findHandler(this.myTemplate).getErrorMessage();
    }

    @Nullable
    private String filterMessage(String message) {
        String ioExceptionPrefix;
        if (message == null) {
            message = "unknown error";
        }
        if (message.startsWith(ioExceptionPrefix = "java.io.IOException:")) {
            return message.substring(ioExceptionPrefix.length());
        }
        if (message.contains("File already exists")) {
            return message;
        }
        return IdeBundle.message("error.unable.to.parse.template.message", this.myTemplate.getName(), message);
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myAttrPanel.ensureFitToScreen(200, 200);
        JPanel centerPanel2 = new JPanel(new GridBagLayout());
        centerPanel2.add((Component)this.myAttrComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return centerPanel2;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myAttrComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "template";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

