/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Locations;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public final class EndUserAgreement {
    private static final Logger LOG = Logger.getInstance(EndUserAgreement.class);
    private static final String POLICY_TEXT_PROPERTY = "jb.privacy.policy.text";
    private static final String PRIVACY_POLICY_DOCUMENT_NAME = "privacy";
    private static final String PRIVACY_POLICY_EAP_DOCUMENT_NAME = "privacyEap";
    private static final String EULA_DOCUMENT_NAME = "eua";
    private static final String EULA_EAP_DOCUMENT_NAME = "euaEap";
    private static final String PRIVACY_POLICY_CONTENT_FILE_NAME = "Cached";
    private static final String DEFAULT_DOC_NAME = "eua";
    private static final String DEFAULT_DOC_EAP_NAME = "euaEap";
    private static final String ACTIVE_DOC_FILE_NAME = "documentName";
    private static final String ACTIVE_DOC_EAP_FILE_NAME = "documentName.eap";
    private static final String RELATIVE_RESOURCE_PATH = "PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final Version MAGIC_VERSION = new Version(999, 999);

    public static File getDocumentContentFile() {
        return EndUserAgreement.getDocumentContentFile(EndUserAgreement.getDocumentName());
    }

    @NotNull
    private static File getDocumentContentFile(String docName) {
        return new File(EndUserAgreement.getDataRoot(), PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? PRIVACY_POLICY_CONTENT_FILE_NAME : docName + ".cached");
    }

    @NotNull
    private static File getDocumentNameFile() {
        return new File(EndUserAgreement.getDataRoot(), EndUserAgreement.isEAP() ? ACTIVE_DOC_EAP_FILE_NAME : ACTIVE_DOC_FILE_NAME);
    }

    private static boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    private static File getDataRoot() {
        return new File(Locations.getDataRoot(), RELATIVE_RESOURCE_PATH);
    }

    private static String getBundledResourcePath(String docName) {
        return PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? "/PrivacyPolicy.html" : "/" + docName + ".html";
    }

    public static void setAccepted(@NotNull Document doc) {
        Version version2;
        if (doc == null) {
            EndUserAgreement.$$$reportNull$$$0(0);
        }
        if ((version2 = doc.getVersion()).isUnknown()) {
            Prefs.remove(EndUserAgreement.getAcceptedVersionKey(doc.getName()));
        } else {
            Prefs.put(EndUserAgreement.getAcceptedVersionKey(doc.getName()), version2.toString());
        }
    }

    @NotNull
    private static Version getAcceptedVersion(String docName) {
        Version version2 = Version.fromString(Prefs.get(EndUserAgreement.getAcceptedVersionKey(docName), null));
        if (version2 == null) {
            EndUserAgreement.$$$reportNull$$$0(1);
        }
        return version2;
    }

    @NotNull
    public static Document getLatestDocument() {
        String docName;
        block5: {
            Document document;
            Document fromProperty;
            String text2 = System.getProperty(POLICY_TEXT_PROPERTY, null);
            if (text2 != null && !(fromProperty = EndUserAgreement.loadContent(PRIVACY_POLICY_DOCUMENT_NAME, new ByteArrayInputStream(text2.getBytes(StandardCharsets.UTF_8)))).getVersion().isUnknown()) {
                Document document2 = fromProperty;
                if (document2 == null) {
                    EndUserAgreement.$$$reportNull$$$0(2);
                }
                return document2;
            }
            docName = EndUserAgreement.getDocumentName();
            try {
                Document fromFile = EndUserAgreement.loadContent(docName, new FileInputStream(EndUserAgreement.getDocumentContentFile(docName)));
                if (fromFile.getVersion().isUnknown()) break block5;
                document = fromFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (document == null) {
                EndUserAgreement.$$$reportNull$$$0(3);
            }
            return document;
        }
        return EndUserAgreement.loadContent(docName, EndUserAgreement.class.getResourceAsStream(EndUserAgreement.getBundledResourcePath(docName)));
    }

    public static boolean updateCachedContentToLatestBundledVersion() {
        block5: {
            try {
                Document bundled;
                Document cached;
                String docName = EndUserAgreement.getDocumentName();
                File cacheFile = EndUserAgreement.getDocumentContentFile(docName);
                if (!cacheFile.exists() || (cached = EndUserAgreement.loadContent(docName, new FileInputStream(cacheFile))).getVersion().isUnknown() || (bundled = EndUserAgreement.loadContent(docName, EndUserAgreement.class.getResourceAsStream(EndUserAgreement.getBundledResourcePath(docName)))).getVersion().isUnknown() || !bundled.getVersion().isNewer(cached.getVersion())) break block5;
                try {
                    FileUtil.writeToFile(EndUserAgreement.getDocumentContentFile(docName), bundled.getText());
                }
                catch (FileNotFoundException e) {
                    LOG.info(e.getMessage());
                }
                catch (IOException e) {
                    LOG.info(e);
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void update(String docName, String text2) {
        try {
            FileUtil.writeToFile(EndUserAgreement.getDocumentContentFile(docName), text2);
            FileUtil.writeToFile(EndUserAgreement.getDocumentNameFile(), docName);
        }
        catch (FileNotFoundException e) {
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            LOG.info(e);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Document loadContent(String docName, InputStream stream) {
        block17: {
            Document document;
            Throwable throwable;
            InputStreamReader reader;
            block15: {
                block16: {
                    if (stream == null) break block17;
                    reader = new InputStreamReader(stream instanceof ByteArrayInputStream ? stream : new BufferedInputStream(stream), StandardCharsets.UTF_8);
                    throwable = null;
                    document = new Document(docName, new String(FileUtil.adaptiveLoadText(reader)));
                    if (reader == null) break block15;
                    if (throwable == null) break block16;
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block15;
                }
                ((Reader)reader).close();
            }
            Document document2 = document;
            if (document2 == null) {
                EndUserAgreement.$$$reportNull$$$0(4);
            }
            return document2;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (reader != null) {
                                if (throwable != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((Reader)reader).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        LOG.info(e);
                    }
                }
            }
        }
        return new Document(docName, "");
    }

    @NotNull
    private static String getDocumentName() {
        block4: {
            String string;
            if (!PlatformUtils.isCommercialEdition()) {
                return EndUserAgreement.isEAP() ? PRIVACY_POLICY_EAP_DOCUMENT_NAME : PRIVACY_POLICY_DOCUMENT_NAME;
            }
            try {
                String docName = new String(FileUtilRt.loadFileText(EndUserAgreement.getDocumentNameFile(), StandardCharsets.UTF_8));
                if (StringUtil.isEmptyOrSpaces(docName)) break block4;
                string = docName;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                EndUserAgreement.$$$reportNull$$$0(5);
            }
            return string;
        }
        return EndUserAgreement.isEAP() ? "euaEap" : "eua";
    }

    @NotNull
    private static String getAcceptedVersionKey(String docName) {
        if (PRIVACY_POLICY_DOCUMENT_NAME.equals(docName)) {
            return "JetBrains.privacy_policy.accepted_version";
        }
        String keyName = docName;
        if ("euaEap".equals(docName)) {
            keyName = "ij_" + keyName;
        }
        String string = "JetBrains.privacy_policy." + keyName + "_accepted_version";
        if (string == null) {
            EndUserAgreement.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDocument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAccepted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Document {
        private final String myName;
        private final String myText;
        private final Version myVersion;

        public Document(String name, String text2) {
            this.myName = name;
            this.myText = text2;
            this.myVersion = Document.parseVersion(text2);
        }

        public boolean isPrivacyPolicy() {
            return EndUserAgreement.PRIVACY_POLICY_DOCUMENT_NAME.equals(this.myName) || EndUserAgreement.PRIVACY_POLICY_EAP_DOCUMENT_NAME.equals(this.myName);
        }

        public boolean isAccepted() {
            Version thisVersion = this.getVersion();
            if (thisVersion.isUnknown() || MAGIC_VERSION.equals(thisVersion)) {
                return true;
            }
            Version acceptedByUser = EndUserAgreement.getAcceptedVersion(this.getName());
            return !acceptedByUser.isUnknown() && acceptedByUser.getMajor() >= thisVersion.getMajor();
        }

        public String getName() {
            return this.myName;
        }

        public Version getVersion() {
            return this.myVersion;
        }

        public String getText() {
            return this.myText;
        }

        /*
         * Loose catch block
         */
        @NotNull
        private static Version parseVersion(String text2) {
            block24: {
                Throwable throwable;
                BufferedReader reader;
                block21: {
                    Version version2;
                    block22: {
                        block23: {
                            int endComment;
                            int startComment;
                            if (StringUtil.isEmptyOrSpaces(text2)) break block24;
                            reader = new BufferedReader(new StringReader(text2));
                            throwable = null;
                            String line = reader.readLine();
                            if (line == null || (startComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_START)) < 0 || (endComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_END)) <= startComment) break block21;
                            version2 = Version.fromString(line.substring(startComment + EndUserAgreement.VERSION_COMMENT_START.length(), endComment).trim());
                            if (reader == null) break block22;
                            if (throwable == null) break block23;
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block22;
                        }
                        reader.close();
                    }
                    Version version3 = version2;
                    if (version3 == null) {
                        Document.$$$reportNull$$$0(0);
                    }
                    return version3;
                }
                try {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                    break block24;
                    {
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (reader != null) {
                                    if (throwable != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        reader.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    LOG.info(e);
                }
            }
            Version version4 = Version.UNKNOWN;
            if (version4 == null) {
                Document.$$$reportNull$$$0(1);
            }
            return version4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/EndUserAgreement$Document", "parseVersion"));
        }
    }
}

