/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageMethodHierarchy;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class MethodHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String METHOD_TYPE = "Method {0}";
    public static final DataKey<MethodHierarchyBrowserBase> DATA_KEY = DataKey.create("com.intellij.ide.hierarchy.MethodHierarchyBrowserBase");

    public MethodHierarchyBrowserBase(Project project2, PsiElement method2) {
        super(project2, method2);
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string = IdeBundle.message("hierarchy.method.prev.occurence.name", new Object[0]);
        if (string == null) {
            MethodHierarchyBrowserBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected Map<String, Supplier<String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(METHOD_TYPE, MethodHierarchyBrowserBase::getMethodType);
        return map2;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string = IdeBundle.message("hierarchy.method.next.occurence.name", new Object[0]);
        if (string == null) {
            MethodHierarchyBrowserBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected static JPanel createStandardLegendPanel(String methodDefinedText, String methodNotDefinedLegallyText, String methodShouldBeDefined) {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, JBUI.insets(3, 5, 0, 5), 0, 0);
        JLabel label2 = new JLabel(methodDefinedText, AllIcons.Hierarchy.MethodDefined, 2);
        label2.setUI(new MultiLineLabelUI());
        label2.setIconTextGap(10);
        panel2.add((Component)label2, gc);
        ++gc.gridy;
        label2 = new JLabel(methodNotDefinedLegallyText, AllIcons.Hierarchy.MethodNotDefined, 2);
        label2.setUI(new MultiLineLabelUI());
        label2.setIconTextGap(10);
        panel2.add((Component)label2, gc);
        ++gc.gridy;
        label2 = new JLabel(methodShouldBeDefined, AllIcons.Hierarchy.ShouldDefineMethod, 2);
        label2.setUI(new MultiLineLabelUI());
        label2.setIconTextGap(10);
        panel2.add((Component)label2, gc);
        return panel2;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            MethodHierarchyBrowserBase.$$$reportNull$$$0(2);
        }
        actionGroup.add(new HierarchyBrowserBaseEx.AlphaSortAction());
        actionGroup.add(new ShowImplementationsOnlyAction());
        actionGroup.add(new HierarchyBrowserBaseEx.ChangeScopeAction());
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        String string = DATA_KEY.getName();
        if (string == null) {
            MethodHierarchyBrowserBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        return "MethodHierarchyViewToolbar";
    }

    public static String getMethodType() {
        return IdeBundle.message("title.hierarchy.method", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevOccurenceActionNameImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionNameImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserDataKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prependActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.messagePointer("action.base.on.this.method", new Object[0]), DATA_KEY.getName(), (LanguageExtension<HierarchyProvider>)LanguageMethodHierarchy.INSTANCE);
        }
    }

    private final class ShowImplementationsOnlyAction
    extends ToggleAction {
        private ShowImplementationsOnlyAction() {
            super(IdeBundle.messagePointer("action.hide.non.implementations", new Object[0]), AllIcons.General.Filter);
        }

        @Override
        public final boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowImplementationsOnlyAction.$$$reportNull$$$0(0);
            }
            return HierarchyBrowserManager.getInstance((Project)MethodHierarchyBrowserBase.this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED;
        }

        @Override
        public final void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowImplementationsOnlyAction.$$$reportNull$$$0(1);
            }
            HierarchyBrowserManager.getInstance((Project)MethodHierarchyBrowserBase.this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED = flag;
            ApplicationManager.getApplication().invokeLater(() -> MethodHierarchyBrowserBase.this.doRefresh(true));
        }

        @Override
        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowImplementationsOnlyAction.$$$reportNull$$$0(2);
            }
            super.update(event);
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(MethodHierarchyBrowserBase.this.isValidBase());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/hierarchy/MethodHierarchyBrowserBase$ShowImplementationsOnlyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

