/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataValidator;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.CopyProviderRule;
import com.intellij.ide.impl.dataRules.CutProviderRule;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.FileTextRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.impl.dataRules.InactiveEditorRule;
import com.intellij.ide.impl.dataRules.NavigatableArrayRule;
import com.intellij.ide.impl.dataRules.PasteProviderRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.reference.SoftReference;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataManagerImpl
extends DataManager {
    private static final Logger LOG = Logger.getInstance(DataManagerImpl.class);
    private final ConcurrentMap<String, GetDataRule> myDataConstantToRuleMap = ContainerUtil.newConcurrentMap();
    private static final Set<String> ourSafeKeys = ContainerUtil.set(CommonDataKeys.PROJECT.getName(), CommonDataKeys.EDITOR.getName(), PlatformDataKeys.IS_MODAL_CONTEXT.getName(), PlatformDataKeys.CONTEXT_COMPONENT.getName(), PlatformDataKeys.MODALITY_STATE.getName());

    public DataManagerImpl() {
        this.myDataConstantToRuleMap.put(PlatformDataKeys.COPY_PROVIDER.getName(), new CopyProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.CUT_PROVIDER.getName(), new CutProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.PASTE_PROVIDER.getName(), new PasteProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_TEXT.getName(), new FileTextRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_EDITOR.getName(), new FileEditorRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.NAVIGATABLE_ARRAY.getName(), new NavigatableArrayRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getName(), new InactiveEditorRule());
    }

    @Nullable
    private Object getData(@NotNull String dataId, Component focusedComponent) {
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(0);
        }
        GetDataRule rule2 = this.getDataRule(dataId);
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (Component c = focusedComponent; c != null; c = c.getParent()) {
                Object data2;
                DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
                if (dataProvider == null || (data2 = this.getDataFromProvider(dataProvider, dataId, null, rule2)) == null) continue;
                Object object = data2;
                return object;
            }
        }
        return null;
    }

    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds) {
        if (provider == null) {
            DataManagerImpl.$$$reportNull$$$0(1);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(2);
        }
        return this.getDataFromProvider(provider, dataId, alreadyComputedIds, this.getDataRule(dataId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object getDataFromProvider(@NotNull DataProvider provider, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds, @Nullable GetDataRule dataRule) {
        if (provider == null) {
            DataManagerImpl.$$$reportNull$$$0(3);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        if (alreadyComputedIds != null && alreadyComputedIds.contains(dataId)) {
            return null;
        }
        try {
            Object data2 = provider.getData(dataId);
            if (data2 != null) {
                Object object = DataManagerImpl.validated(data2, dataId, provider);
                return object;
            }
            if (dataRule != null) {
                THashSet<String> ids = alreadyComputedIds == null ? new THashSet<String>() : alreadyComputedIds;
                ids.add(dataId);
                data2 = dataRule.getData(id2 -> this.getDataFromProvider(provider, id2, ids));
                if (data2 != null) {
                    Object object = DataManagerImpl.validated(data2, dataId, provider);
                    return object;
                }
            }
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            if (alreadyComputedIds != null) {
                alreadyComputedIds.remove(dataId);
            }
        }
    }

    @Nullable
    public static DataProvider getDataProviderEx(Object component2) {
        DataProvider dataProvider = null;
        if (component2 instanceof DataProvider) {
            dataProvider = (DataProvider)component2;
        } else if (component2 instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component2);
        } else if (component2 instanceof JComponent) {
            dataProvider = DataManagerImpl.getDataProvider((JComponent)component2);
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(@NotNull String dataId) {
        GetDataRule rule2;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(5);
        }
        if ((rule2 = this.getRuleFromMap(dataId)) != null) {
            return rule2;
        }
        GetDataRule plainRule = this.getRuleFromMap(AnActionEvent.uninjectedId(dataId));
        if (plainRule != null) {
            return dataProvider -> plainRule.getData(id2 -> dataProvider.getData(AnActionEvent.injectedId(id2)));
        }
        return null;
    }

    @Nullable
    private GetDataRule getRuleFromMap(@NotNull String dataId) {
        GetDataRule rule2;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(6);
        }
        if ((rule2 = (GetDataRule)this.myDataConstantToRuleMap.get(dataId)) == null && !this.myDataConstantToRuleMap.containsKey(dataId)) {
            for (KeyedLazyInstanceEP<GetDataRule> ruleEP : GetDataRule.EP_NAME.getExtensions()) {
                if (!ruleEP.key.equals(dataId)) continue;
                rule2 = ruleEP.getInstance();
            }
            if (rule2 != null) {
                this.myDataConstantToRuleMap.putIfAbsent(dataId, rule2);
            }
        }
        return rule2;
    }

    @Nullable
    private static Object validated(@NotNull Object data2, @NotNull String dataId, @NotNull Object dataSource) {
        Object invalidData;
        if (data2 == null) {
            DataManagerImpl.$$$reportNull$$$0(7);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            DataManagerImpl.$$$reportNull$$$0(9);
        }
        if ((invalidData = DataValidator.findInvalidData(dataId, data2, dataSource)) != null) {
            return null;
        }
        return data2;
    }

    @Override
    @NotNull
    public DataContext getDataContext(Component component2) {
        return new MyDataContext(component2);
    }

    @Override
    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (component2 == null) {
            DataManagerImpl.$$$reportNull$$$0(10);
        }
        if (x < 0 || x >= component2.getWidth() || y < 0 || y >= component2.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component2 instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component2;
            int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            DataContext dataContext = this.getDataContext(index != -1 ? tabbedPane.getComponentAt(index) : tabbedPane);
            if (dataContext == null) {
                DataManagerImpl.$$$reportNull$$$0(11);
            }
            return dataContext;
        }
        DataContext dataContext = this.getDataContext(component2);
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(12);
        }
        return dataContext;
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        Component component2 = null;
        if (Registry.is("actionSystem.getContextByRecentMouseEvent")) {
            component2 = SwingHelper.getComponentFromRecentMouseEvent();
        }
        DataContext dataContext = this.getDataContext(component2 != null ? component2 : DataManagerImpl.getFocusedComponent());
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(13);
        }
        return dataContext;
    }

    @Override
    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> result2.setResult((Object)this.getDataContext()), ModalityState.any());
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            DataManagerImpl.$$$reportNull$$$0(14);
        }
        return asyncPromise;
    }

    @NotNull
    public DataContext getDataContextTest(Component component2) {
        DataContext dataContext = this.getDataContext(component2);
        WindowManager windowManager = WindowManager.getInstance();
        if (!(windowManager instanceof WindowManagerEx)) {
            DataContext dataContext2 = dataContext;
            if (dataContext2 == null) {
                DataManagerImpl.$$$reportNull$$$0(15);
            }
            return dataContext2;
        }
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = ((WindowManagerEx)windowManager).getFocusedComponent(project2);
        if (focusedComponent != null) {
            dataContext = this.getDataContext(focusedComponent);
        }
        DataContext dataContext3 = dataContext;
        if (dataContext3 == null) {
            DataManagerImpl.$$$reportNull$$$0(16);
        }
        return dataContext3;
    }

    @Nullable
    private static Component getFocusedComponent() {
        WindowManager windowManager = WindowManager.getInstance();
        if (!(windowManager instanceof WindowManagerEx)) {
            return null;
        }
        WindowManagerEx windowManagerEx = (WindowManagerEx)windowManager;
        Window activeWindow = windowManagerEx.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (activeWindow instanceof FloatingDecorator) {
            boolean toolWindowIsNotFocused;
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent(activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            boolean bl = toolWindowIsNotFocused = windowManagerEx.getFocusedComponent(activeWindow) == null;
            if (toolWindowIsNotFocused && lastFocusedWindow != null) {
                activeWindow = lastFocusedWindow;
            }
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = windowManagerEx.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    @Override
    public <T> void saveInDataContext(DataContext dataContext, @NotNull Key<T> dataKey, @Nullable T data2) {
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(17);
        }
        if (dataContext instanceof UserDataHolder) {
            ((UserDataHolder)((Object)dataContext)).putUserData(dataKey, data2);
        }
    }

    @Override
    @Nullable
    public <T> T loadFromDataContext(@NotNull DataContext dataContext, @NotNull Key<T> dataKey) {
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(18);
        }
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(19);
        }
        return dataContext instanceof UserDataHolder ? (T)((UserDataHolder)((Object)dataContext)).getUserData(dataKey) : null;
    }

    @Nullable
    public static Editor validateEditor(Editor editor) {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataRule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRuleFromMap";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveInDataContext";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static class MyDataContext
    implements DataContext,
    UserDataHolder {
        private int myEventCount = -1;
        private final Reference<Component> myRef;
        private Map<Key<?>, Object> myUserData;
        private final Map<String, Object> myCachedData = ContainerUtil.createWeakValueMap();

        public MyDataContext(@Nullable Component component2) {
            this.myRef = component2 == null ? null : new WeakReference<Component>(component2);
        }

        public void setEventCount(int eventCount) {
            assert (ReflectionUtil.getCallerClass(3) == IdeKeyEventDispatcher.class) : "This method might be accessible from " + IdeKeyEventDispatcher.class.getName() + " only";
            this.myCachedData.clear();
            this.myEventCount = eventCount;
        }

        @Override
        public Object getData(@NotNull String dataId) {
            Object answer;
            boolean cacheable;
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            boolean bl = cacheable = Registry.is("actionSystem.cache.data") || ourSafeKeys.contains(dataId);
            if (ApplicationManager.getApplication().isDispatchThread()) {
                int currentEventCount = IdeEventQueue.getInstance().getEventCount();
                if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                    LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
                    cacheable = false;
                }
            }
            Object object = answer = cacheable ? this.myCachedData.get(dataId) : null;
            if (answer != null) {
                return answer != NullResult.INSTANCE ? answer : null;
            }
            answer = this.doGetData(dataId);
            if (cacheable && !(answer instanceof Stream)) {
                this.myCachedData.put(dataId, answer == null ? NullResult.INSTANCE : answer);
            }
            return answer;
        }

        @Nullable
        private Object doGetData(@NotNull String dataId) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(1);
            }
            Component component2 = SoftReference.dereference(this.myRef);
            if (PlatformDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
                if (component2 == null) {
                    return null;
                }
                return IdeKeyEventDispatcher.isModalContext(component2);
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
                return component2;
            }
            if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
                return component2 != null ? ModalityState.stateForComponent(component2) : ModalityState.NON_MODAL;
            }
            Object data2 = this.calcData(dataId, component2);
            if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
                return DataManagerImpl.validateEditor((Editor)data2);
            }
            return data2;
        }

        protected Object calcData(@NotNull String dataId, Component component2) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(2);
            }
            return ((DataManagerImpl)DataManager.getInstance()).getData(dataId, component2);
        }

        @NonNls
        public String toString() {
            return "component=" + SoftReference.dereference(this.myRef);
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyDataContext.$$$reportNull$$$0(3);
            }
            return (T)this.getOrCreateMap().get(key);
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                MyDataContext.$$$reportNull$$$0(4);
            }
            this.getOrCreateMap().put(key, value2);
        }

        @NotNull
        private Map<Key<?>, Object> getOrCreateMap() {
            Map<Key<Object>, Object> userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = ContainerUtil.createWeakValueMap();
            }
            Map<Key<?>, Object> map2 = userData;
            if (map2 == null) {
                MyDataContext.$$$reportNull$$$0(5);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl$MyDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl$MyDataContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doGetData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NullResult {
        public static final NullResult INSTANCE = new NullResult();

        private NullResult() {
        }
    }
}

