/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;

public class ProjectSubViewSelectInTarget
implements SelectInTarget {
    private final ProjectViewSelectInTarget myBaseTarget;
    private final String mySubId;
    private final int myWeight;

    public ProjectSubViewSelectInTarget(ProjectViewSelectInTarget target2, String subId, int weight2) {
        this.myBaseTarget = target2;
        this.mySubId = subId;
        this.myWeight = weight2;
    }

    @Override
    public boolean canSelect(SelectInContext context) {
        return this.myBaseTarget.isSubIdSelectable(this.mySubId, context);
    }

    @Override
    public void selectIn(SelectInContext context, boolean requestFocus) {
        this.myBaseTarget.setSubId(this.mySubId);
        this.myBaseTarget.selectIn(context, requestFocus);
    }

    @Override
    public String getToolWindowId() {
        return this.myBaseTarget.getToolWindowId();
    }

    @Override
    public String getMinorViewId() {
        return this.myBaseTarget.getMinorViewId();
    }

    @Override
    public float getWeight() {
        return this.myWeight;
    }

    @Override
    public String toString() {
        return this.myBaseTarget.getSubIdPresentableName(this.mySubId);
    }
}

