/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.ide.impl.SelectProjectOpenProcessorDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.FocusUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class ProjectUtil {
    private static final Logger LOG = Logger.getInstance(ProjectUtil.class);
    public static final String MODE_PROPERTY = "OpenOrAttachDialog.OpenMode";
    public static final String MODE_ATTACH = "attach";
    public static final String MODE_REPLACE = "replace";
    public static final String MODE_NEW = "new";

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(@NotNull String projectFilePath) {
        File lastProjectLocation;
        if (projectFilePath == null) {
            ProjectUtil.$$$reportNull$$$0(0);
        }
        if ((lastProjectLocation = new File(projectFilePath)).isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path2 = lastProjectLocation.getPath();
        try {
            path2 = FileUtil.resolveShortWindowsName(path2);
        }
        catch (IOException e) {
            LOG.info(e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName(path2));
    }

    public static boolean closeAndDispose(@NotNull Project project2) {
        if (project2 == null) {
            ProjectUtil.$$$reportNull$$$0(1);
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project2);
    }

    public static Project openOrImport(@NotNull Path path2, Project projectToClose, boolean forceOpenInNewFrame) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(2);
        }
        return ProjectUtil.openOrImport(path2, new OpenProjectTask(forceOpenInNewFrame, projectToClose));
    }

    @Nullable
    public static Project openOrImport(@NotNull String path2, Project projectToClose, boolean forceOpenInNewFrame) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(3);
        }
        return ProjectUtil.openOrImport(Paths.get(path2, new String[0]), new OpenProjectTask(forceOpenInNewFrame, projectToClose));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Project openOrImport(@NotNull Path file2, @NotNull OpenProjectTask options) {
        VirtualFile virtualFile2;
        Project existing;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(4);
        }
        if (options == null) {
            ProjectUtil.$$$reportNull$$$0(5);
        }
        if ((existing = ProjectUtil.findAndFocusExistingProjectForPath(file2)) != null) {
            return existing;
        }
        NullableLazyValue<VirtualFile> lazyVirtualFile = NullableLazyValue.createValue(() -> ProjectUtil.getFileAndRefresh(file2));
        for (ProjectOpenProcessor projectOpenProcessor : ProjectOpenProcessor.EXTENSION_POINT_NAME.getIterable()) {
            if (!projectOpenProcessor.isStrongProjectInfoHolder()) continue;
            VirtualFile virtualFile3 = lazyVirtualFile.getValue();
            if (virtualFile3 == null) {
                return null;
            }
            if (!projectOpenProcessor.canOpenProject(virtualFile3)) continue;
            return ProjectUtil.chooseProcessorAndOpen(Collections.singletonList(projectOpenProcessor), virtualFile3, options);
        }
        if (ProjectUtil.isValidProjectPath(file2)) {
            return PlatformProjectOpenProcessor.openExistingProject(file2, file2, options);
        }
        if (options.checkDirectoryForFileBasedProjects && Files.isDirectory(file2, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file2);){
                    for (Path child2 : directoryStream) {
                        String childPath = child2.toString();
                        if (!childPath.endsWith(".ipr")) continue;
                        Project project2 = ProjectUtil.openProject(childPath, options.projectToClose, options.forceOpenInNewFrame);
                        return project2;
                    }
                }
                catch (Throwable virtualFile3) {
                    Throwable throwable2 = virtualFile3;
                    throw virtualFile3;
                }
            }
            catch (IOException directoryStream) {
                // empty catch block
            }
        }
        if ((virtualFile2 = lazyVirtualFile.getValue()) == null) {
            return null;
        }
        List<ProjectOpenProcessor> list2 = ProjectOpenProcessor.getOpenProcessors(virtualFile2, false);
        if (list2.isEmpty()) {
            return null;
        }
        Project project3 = ProjectUtil.chooseProcessorAndOpen(list2, virtualFile2, options);
        if (project3 == null) {
            return null;
        }
        StartupManager.getInstance(project3).runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance(project3).getToolWindow("Project");
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, ModalityState.NON_MODAL, project3.getDisposed()));
        return project3;
    }

    @Nullable
    private static Project chooseProcessorAndOpen(@NotNull List<ProjectOpenProcessor> processors, @NotNull VirtualFile virtualFile2, @NotNull OpenProjectTask options) {
        if (processors == null) {
            ProjectUtil.$$$reportNull$$$0(6);
        }
        if (virtualFile2 == null) {
            ProjectUtil.$$$reportNull$$$0(7);
        }
        if (options == null) {
            ProjectUtil.$$$reportNull$$$0(8);
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ProjectOpenProcessor processor2 = ProjectUtil.selectOpenProcessor(processors, virtualFile2);
            if (processor2 != null) {
                Project project2 = processor2.doOpenProject(virtualFile2, options.projectToClose, options.forceOpenInNewFrame);
                if (project2 != null && processor2 instanceof PlatformProjectOpenProcessor) {
                    project2.putUserData(PlatformProjectOpenProcessor.PROJECT_OPENED_BY_PLATFORM_PROCESSOR, Boolean.TRUE);
                }
                result2.set(project2);
            }
        });
        return (Project)result2.get();
    }

    @Nullable
    private static ProjectOpenProcessor selectOpenProcessor(@NotNull List<ProjectOpenProcessor> processors, @NotNull VirtualFile file2) {
        if (processors == null) {
            ProjectUtil.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(10);
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        List<ProjectOpenProcessor> notDefaultProcessors = ContainerUtil.filter(processors, p -> !(p instanceof PlatformProjectOpenProcessor));
        if (notDefaultProcessors.size() == 1) {
            return notDefaultProcessors.get(0);
        }
        return new SelectProjectOpenProcessorDialog(notDefaultProcessors, file2).showAndGetChoice();
    }

    @Nullable
    @ApiStatus.Internal
    public static VirtualFile getFileAndRefresh(@NotNull Path file2) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(11);
        }
        if ((virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(file2.toString()))) == null || !virtualFile2.isValid()) {
            return null;
        }
        virtualFile2.refresh(false, false);
        return virtualFile2;
    }

    @Nullable
    public static Project openProject(@NotNull String path2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Path dir;
        Path file2;
        BasicFileAttributes fileAttributes;
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(12);
        }
        if ((fileAttributes = PathKt.basicAttributesIfExists((Path)(file2 = Paths.get(path2, new String[0])))) == null) {
            Messages.showErrorDialog(IdeBundle.message("error.project.file.does.not.exist", file2.toString()), CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(file2);
        if (existing != null) {
            return existing;
        }
        if (ProjectUtil.isRemotePath(file2.toString()) && !RecentProjectsManager.getInstance().hasPath(FileUtil.toSystemIndependentName(file2.toString())) && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        if (fileAttributes.isDirectory() && !Files.isDirectory(dir = file2.resolve(".idea"), new LinkOption[0])) {
            Messages.showErrorDialog(IdeBundle.message("error.project.file.does.not.exist", dir.toString()), CommonBundle.getErrorTitle());
            return null;
        }
        try {
            return PlatformProjectOpenProcessor.openExistingProject(file2, file2, new OpenProjectTask(forceOpenInNewFrame, projectToClose));
        }
        catch (Exception e) {
            Messages.showMessageDialog(IdeBundle.message("error.cannot.load.project", e.getMessage()), IdeBundle.message("title.cannot.load.project", new Object[0]), Messages.getErrorIcon());
            return null;
        }
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path2, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(13);
        }
        if (msgKey == null) {
            ProjectUtil.$$$reportNull$$$0(14);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(15);
        }
        return ProjectUtil.showYesNoDialog(IdeBundle.message(msgKey, path2), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull String message, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (message == null) {
            ProjectUtil.$$$reportNull$$$0(16);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(17);
        }
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        Icon icon2 = Messages.getWarningIcon();
        String title = IdeBundle.message(titleKey, new Object[0]);
        int answer = window == null ? Messages.showYesNoDialog(message, title, icon2) : Messages.showYesNoDialog(window, message, title, icon2);
        return answer == 0;
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path2) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(18);
        }
        return path2.contains("://") || path2.contains("\\\\");
    }

    public static Project @NotNull [] getOpenProjects() {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        Project[] projectArray = projectManager == null ? new Project[]{} : projectManager.getOpenProjects();
        if (projectArray == null) {
            ProjectUtil.$$$reportNull$$$0(19);
        }
        return projectArray;
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(@NotNull Path file2) {
        Project[] openProjects;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(20);
        }
        if ((openProjects = ProjectUtil.getOpenProjects()).length == 0) {
            return null;
        }
        String path2 = FileUtil.toSystemIndependentName(file2.toString());
        for (Project project2 : openProjects) {
            if (!ProjectUtil.isSameProject(path2, project2)) continue;
            ProjectUtil.focusProjectWindow(project2, false);
            return project2;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog(IdeBundle.message("prompt.open.project.in.new.frame", new Object[0]), IdeBundle.message("title.new.project", new Object[0]), IdeBundle.message("button.existing.frame", new Object[0]), IdeBundle.message("button.new.frame", new Object[0]), Messages.getQuestionIcon(), new ProjectNewWindowDoNotAskOption());
                LifecycleUsageTriggerCollector.onProjectFrameSelected(exitCode);
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog(IdeBundle.message("prompt.open.project.in.new.frame", new Object[0]), IdeBundle.message("title.open.project", new Object[0]), IdeBundle.message("button.existing.frame", new Object[0]), IdeBundle.message("button.new.frame", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon(), new ProjectNewWindowDoNotAskOption());
            LifecycleUsageTriggerCollector.onProjectFrameSelected(exitCode);
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    public static int confirmOpenOrAttachProject() {
        String mode = PropertiesComponent.getInstance().getValue(MODE_PROPERTY);
        int exitCode = Messages.showDialog(IdeBundle.message("prompt.open.project.or.attach", new Object[0]), IdeBundle.message("prompt.open.project.or.attach.title", new Object[0]), new String[]{IdeBundle.message("prompt.open.project.or.attach.button.this.window", new Object[0]), IdeBundle.message("prompt.open.project.or.attach.button.new.window", new Object[0]), IdeBundle.message("prompt.open.project.or.attach.button.attach", new Object[0]), CommonBundle.getCancelButtonText()}, MODE_NEW.equals(mode) ? 1 : (MODE_REPLACE.equals(mode) ? 0 : (MODE_ATTACH.equals(mode) ? 2 : 0)), Messages.getQuestionIcon());
        LifecycleUsageTriggerCollector.onProjectFrameSelected(exitCode);
        return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : (exitCode == 2 ? 2 : -1));
    }

    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project2) {
        if (project2 == null) {
            ProjectUtil.$$$reportNull$$$0(21);
        }
        if (projectFilePath == null) {
            return false;
        }
        IProjectStore projectStore = ProjectKt.getStateStore(project2);
        String existingBaseDirPath = projectStore.getProjectBasePath();
        File projectFile = new File(projectFilePath);
        if (projectFile.isDirectory()) {
            return FileUtil.pathsEqual(projectFilePath, existingBaseDirPath);
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            return FileUtil.pathsEqual(projectFilePath, projectStore.getProjectFilePath());
        }
        File parent = projectFile.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.getName().equals(".idea")) {
            return (parent = parent.getParentFile()) != null && FileUtil.pathsEqual(parent.getPath(), existingBaseDirPath);
        }
        return FileUtil.pathsEqual(parent.getPath(), existingBaseDirPath) && "ipr".equals(FileUtilRt.getExtension(projectFile.getName()));
    }

    public static void focusProjectWindow(@Nullable Project project2, boolean executeIfAppInactive) {
        JFrame frame = WindowManager.getInstance().getFrame(project2);
        if (frame == null) {
            return;
        }
        Component mostRecentFocusOwner = frame.getMostRecentFocusOwner();
        if (executeIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)((Object)WindowManager.getInstance().getFrame(project2)));
            frame.toFront();
            if (!SystemInfo.isMac && !frame.isAutoRequestFocus()) {
                if (mostRecentFocusOwner != null) {
                    IdeFocusManager.getInstance(project2).requestFocus(mostRecentFocusOwner, true);
                } else {
                    LOG.warn("frame.getMostRecentFocusOwner() is null");
                }
            }
        } else if (mostRecentFocusOwner != null) {
            IdeFocusManager.getInstance(project2).requestFocusInProject(mostRecentFocusOwner, project2);
        } else {
            Component defaultFocusComponentInPanel = FocusUtil.getDefaultComponentInPanel(frame.getFocusCycleRootAncestor());
            if (defaultFocusComponentInPanel != null) {
                IdeFocusManager.getInstance(project2).requestFocusInProject(defaultFocusComponentInPanel, project2);
            }
        }
    }

    public static String getBaseDir() {
        String defaultDirectory = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (StringUtil.isNotEmpty(defaultDirectory)) {
            return defaultDirectory.replace('/', File.separatorChar);
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        if (PlatformUtils.isCLion() || PlatformUtils.isAppCode()) {
            productName = ApplicationNamesInfo.getInstance().getProductName();
        }
        return userHome.replace('/', File.separatorChar) + File.separator + productName + "Projects";
    }

    @Nullable
    public static Project tryOpenFileList(@Nullable Project project2, @NotNull List<? extends File> list2, String location2) {
        if (list2 == null) {
            ProjectUtil.$$$reportNull$$$0(22);
        }
        Project result2 = null;
        for (File file2 : list2) {
            result2 = ProjectUtil.openOrImport(file2.toPath().toAbsolutePath(), project2, true);
            if (result2 == null) continue;
            LOG.debug(location2 + ": load project from ", file2);
            return result2;
        }
        for (File file3 : list2) {
            Project opened;
            VirtualFile virtualFile2;
            if (!file3.exists()) continue;
            LOG.debug(location2 + ": open file ", file3);
            String path2 = file3.getAbsolutePath();
            if (project2 != null) {
                OpenFileAction.openFile(path2, project2);
                result2 = project2;
                continue;
            }
            CommandLineProjectOpenProcessor processor2 = CommandLineProjectOpenProcessor.getInstanceIfExists();
            if (processor2 == null || (virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2)) == null || !virtualFile2.isValid() || (opened = processor2.openProjectAndFile(virtualFile2, -1, -1, false)) == null || result2 != null) continue;
            result2 = opened;
        }
        return result2;
    }

    public static boolean isValidProjectPath(@NotNull Path file2) {
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(23);
        }
        return Files.isDirectory(file2.resolve(".idea"), new LinkOption[0]) || StringUtil.endsWith(file2.toString(), ".ipr") && Files.isRegularFile(file2, new LinkOption[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePath";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgKey";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/ProjectUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/ProjectUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateLastProjectLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDispose";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openOrImport";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseProcessorAndOpen";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectOpenProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileAndRefresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "confirmLoadingFromRemotePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isRemotePath";
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAndFocusExistingProjectForPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSameProject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryOpenFileList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isValidProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

